/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.PropertyConfigurationMapper;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.web.ResourceNotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AuthorizeControllerServiceReference {
    public static void authorizeControllerServiceReferences(ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup, boolean authorizeTransitiveServices) {
        authorizable.getPropertyDescriptors().forEach(descriptor -> {
            String serviceId;
            if (descriptor.getControllerServiceDefinition() != null && (serviceId = authorizable.getValue(descriptor)) != null) {
                try {
                    ComponentAuthorizable currentServiceAuthorizable = lookup.getControllerService(serviceId);
                    currentServiceAuthorizable.getAuthorizable().authorize(authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                    if (authorizeTransitiveServices) {
                        AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)currentServiceAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
                    }
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public static void authorizeControllerServiceReferences(Map<String, String> proposedProperties, ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup) {
        if (proposedProperties != null) {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            for (Map.Entry<String, String> entry : proposedProperties.entrySet()) {
                boolean referencesParameter;
                String propertyName = entry.getKey();
                PropertyDescriptor propertyDescriptor = authorizable.getPropertyDescriptor(propertyName);
                if (propertyDescriptor.getControllerServiceDefinition() == null) continue;
                String proposedValue = entry.getValue();
                String proposedEffectiveValue = new PropertyConfigurationMapper().mapRawPropertyValuesToPropertyConfiguration(propertyDescriptor, proposedValue).getEffectiveValue((ParameterLookup)authorizable.getParameterContext());
                String currentValue = authorizable.getValue(propertyDescriptor);
                if (Objects.equals(currentValue, proposedValue)) continue;
                if (currentValue != null) {
                    try {
                        Authorizable currentServiceAuthorizable = lookup.getControllerService(currentValue).getAuthorizable();
                        currentServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
                    }
                    catch (ResourceNotFoundException currentServiceAuthorizable) {
                        // empty catch block
                    }
                }
                if (proposedValue == null) continue;
                ExpressionLanguageAgnosticParameterParser parser = new ExpressionLanguageAgnosticParameterParser();
                ParameterTokenList tokenList = parser.parseTokens(proposedValue);
                boolean bl = referencesParameter = !tokenList.toReferenceList().isEmpty();
                if (referencesParameter) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReference((ComponentAuthorizable)authorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (NiFiUser)user, (PropertyDescriptor)propertyDescriptor, (String)proposedEffectiveValue);
                    continue;
                }
                Authorizable newServiceAuthorizable = lookup.getControllerService(proposedValue).getAuthorizable();
                newServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
            }
        }
    }

    public static void authorizeControllerServiceReference(ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup, NiFiUser user, PropertyDescriptor propertyDescriptor, String proposedEffectiveValue) {
        String currentValue = authorizable.getValue(propertyDescriptor);
        if (!(authorizable.getAuthorizable() instanceof ComponentNode)) {
            throw new IllegalArgumentException(authorizable.getAuthorizable().getResource().getSafeDescription() + " cannot reference Controller Services through Parameters.");
        }
        AuthorizeControllerServiceReference.authorize((Authorizer)authorizer, (AuthorizableLookup)lookup, (NiFiUser)user, (String)currentValue);
        AuthorizeControllerServiceReference.authorize((Authorizer)authorizer, (AuthorizableLookup)lookup, (NiFiUser)user, (String)proposedEffectiveValue);
    }

    private static void authorize(Authorizer authorizer, AuthorizableLookup lookup, NiFiUser user, String serviceId) {
        Optional.ofNullable(serviceId).map(arg_0 -> ((AuthorizableLookup)lookup).getControllerService(arg_0)).ifPresent(service -> {
            Authorizable serviceAuthorizable = service.getAuthorizable();
            serviceAuthorizable.authorize(authorizer, RequestAction.READ, user);
        });
    }
}

