/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ProcessGroupAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessGroupAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup createProcessGroup(String, org.apache.nifi.web.api.dto.ProcessGroupDTO))")
    public ProcessGroup createProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ProcessGroup processGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processGroup, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return processGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateProcessGroup(org.apache.nifi.web.api.dto.ProcessGroupDTO)) && args(processGroupDTO)")
    public ProcessGroup updateProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, ProcessGroupDTO processGroupDTO) throws Throwable {
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(processGroupDTO.getId());
        String name = processGroup.getName();
        ParameterContext parameterContext = processGroup.getParameterContext();
        String comments = processGroup.getComments();
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeConfigureDetails configDetails;
            ArrayList<FlowChangeConfigureDetails> details = new ArrayList<FlowChangeConfigureDetails>();
            if (name != null && updatedProcessGroup.getName() != null && !name.equals(updatedProcessGroup.getName())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Name");
                configDetails.setValue(updatedProcessGroup.getName());
                configDetails.setPreviousValue(name);
                details.add(configDetails);
            }
            if (comments != null && updatedProcessGroup.getComments() != null && !comments.equals(updatedProcessGroup.getComments())) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Comments");
                configDetails.setValue(updatedProcessGroup.getComments());
                configDetails.setPreviousValue(comments);
                details.add(configDetails);
            }
            if (parameterContext != null && updatedProcessGroup.getParameterContext() != null) {
                if (!parameterContext.getIdentifier().equals(updatedProcessGroup.getParameterContext().getIdentifier())) {
                    configDetails = new FlowChangeConfigureDetails();
                    configDetails.setName("Parameter Context");
                    configDetails.setValue(updatedProcessGroup.getParameterContext().getIdentifier());
                    configDetails.setPreviousValue(parameterContext.getIdentifier());
                    details.add(configDetails);
                }
            } else if (updatedProcessGroup.getParameterContext() != null) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Parameter Context");
                configDetails.setValue(updatedProcessGroup.getParameterContext().getIdentifier());
                configDetails.setPreviousValue(null);
                details.add(configDetails);
            } else if (parameterContext != null) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Parameter Context");
                configDetails.setValue(null);
                configDetails.setPreviousValue(parameterContext.getIdentifier());
                details.add(configDetails);
            }
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            if (!details.isEmpty()) {
                Date timestamp = new Date();
                for (ActionDetails actionDetails : details) {
                    Operation operation = Operation.Configure;
                    if (actionDetails instanceof FlowChangeMoveDetails) {
                        operation = Operation.Move;
                    }
                    FlowChangeAction processGroupAction = new FlowChangeAction();
                    processGroupAction.setUserIdentity(user.getIdentity());
                    processGroupAction.setOperation(operation);
                    processGroupAction.setTimestamp(timestamp);
                    processGroupAction.setSourceId(updatedProcessGroup.getIdentifier());
                    processGroupAction.setSourceName(updatedProcessGroup.getName());
                    processGroupAction.setSourceType(Component.ProcessGroup);
                    processGroupAction.setActionDetails(actionDetails);
                    actions.add(processGroupAction);
                }
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void scheduleComponents(String, org.apache.nifi.controller.ScheduledState, java.util.Set<String>)) && args(groupId, state, componentIds)")
    public void scheduleComponentsAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId, ScheduledState state, Set<String> componentIds) throws Throwable {
        proceedingJoinPoint.proceed();
        Operation operation = ScheduledState.RUNNING.equals((Object)state) ? Operation.Start : Operation.Stop;
        this.saveUpdateAction(groupId, operation);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void enableComponents(String, org.apache.nifi.controller.ScheduledState, java.util.Set<String>)) && args(groupId, state, componentIds)")
    public void enableComponentsAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId, ScheduledState state, Set<String> componentIds) throws Throwable {
        proceedingJoinPoint.proceed();
        Operation operation = ScheduledState.DISABLED.equals((Object)state) ? Operation.Disable : Operation.Enable;
        this.saveUpdateAction(groupId, operation);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void activateControllerServices(String, org.apache.nifi.controller.service.ControllerServiceState, java.util.Collection<String>)) && args(groupId, state, serviceIds)")
    public void activateControllerServicesAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId, ControllerServiceState state, Collection<String> serviceIds) throws Throwable {
        proceedingJoinPoint.proceed();
        Operation operation = ControllerServiceState.ENABLED.equals((Object)state) ? Operation.Enable : Operation.Disable;
        this.saveUpdateAction(groupId, operation);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateVariableRegistry(org.apache.nifi.web.api.dto.VariableRegistryDTO)) && args(variableRegistry)")
    public ProcessGroup updateVariableRegistryAdvice(ProceedingJoinPoint proceedingJoinPoint, VariableRegistryDTO variableRegistry) throws Throwable {
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        this.saveUpdateAction(variableRegistry.getProcessGroupId(), Operation.Configure);
        return updatedProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateProcessGroupFlow(..))")
    public ProcessGroup updateProcessGroupFlowAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object[] args = proceedingJoinPoint.getArgs();
        String groupId = (String)args[0];
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(groupId);
        VersionControlInformation vci = processGroup.getVersionControlInformation();
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        VersionControlInformation updatedVci = updatedProcessGroup.getVersionControlInformation();
        Operation operation = vci == null ? Operation.StartVersionControl : (updatedVci == null ? Operation.StopVersionControl : (vci.getVersion() == updatedVci.getVersion() ? Operation.RevertLocalChanges : Operation.ChangeVersion));
        this.saveUpdateAction(groupId, operation);
        return updatedProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup updateVersionControlInformation(..))")
    public ProcessGroup updateVersionControlInformationAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        VersionControlInformationDTO vciDto = (VersionControlInformationDTO)proceedingJoinPoint.getArgs()[0];
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(vciDto.getGroupId());
        VersionControlInformation vci = processGroup.getVersionControlInformation();
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        Operation operation = vci == null ? Operation.StartVersionControl : Operation.CommitLocalChanges;
        this.saveUpdateAction(vciDto.getGroupId(), operation);
        return updatedProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(org.apache.nifi.groups.ProcessGroup disconnectVersionControl(String)) && args(groupId)")
    public ProcessGroup disconnectVersionControlAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId) throws Throwable {
        ProcessGroup updatedProcessGroup = (ProcessGroup)proceedingJoinPoint.proceed();
        this.saveUpdateAction(groupId, Operation.StopVersionControl);
        return updatedProcessGroup;
    }

    private void saveUpdateAction(String groupId, Operation operation) throws Throwable {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(groupId);
        FlowChangeAction action = new FlowChangeAction();
        action.setUserIdentity(user.getIdentity());
        action.setSourceId(processGroup.getIdentifier());
        action.setSourceName(processGroup.getName());
        action.setSourceType(Component.ProcessGroup);
        action.setTimestamp(new Date());
        action.setOperation(operation);
        this.saveAction((Action)action, logger);
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessGroupDAO+) && execution(void deleteProcessGroup(String)) && args(groupId)")
    public void removeProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, String groupId) throws Throwable {
        ProcessGroupDAO processGroupDAO = this.getProcessGroupDAO();
        ProcessGroup processGroup = processGroupDAO.getProcessGroup(groupId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processGroup, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(ProcessGroup processGroup, Operation operation) {
        return this.generateAuditRecord(processGroup, operation, null);
    }

    public Action generateAuditRecord(ProcessGroup processGroup, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(processGroup.getIdentifier());
            action.setSourceName(processGroup.getName());
            action.setSourceType(Component.ProcessGroup);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

