/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.migration;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.impl.StandardAuditService;
import org.apache.nifi.admin.service.transaction.TransactionBuilder;
import org.apache.nifi.admin.service.transaction.impl.StandardTransactionBuilder;
import org.apache.nifi.h2.database.migration.H2DatabaseUpdater;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.h2.jdbcx.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowConfigurationHistoryMigrator {
    private static final String H2_DATABASE_URL_FORMAT = "%s%s;AUTOCOMMIT=OFF;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=3";
    private static final String H2_DATABASE_NAME = "nifi-flow-audit";
    private static final String H2_DATABASE_FILE_NAME = String.format("%s.mv.db", "nifi-flow-audit");
    private static final String BACKUP_FILE_NAME_FORMAT = "%s.backup.%d";
    private static final String H2_CREDENTIALS = "nf";
    private static final int PAGE_COUNT = 1000;
    private static final Logger logger = LoggerFactory.getLogger(FlowConfigurationHistoryMigrator.class);

    public static void reconcileDatabaseRepository(Path databaseRepositoryPath, AuditService auditService) throws Exception {
        Objects.requireNonNull(databaseRepositoryPath, "Repository Path required");
        Path databaseFilePath = databaseRepositoryPath.resolve(H2_DATABASE_FILE_NAME);
        if (Files.exists(databaseFilePath, new LinkOption[0])) {
            logger.info("H2 DB migration for Flow Configuration History required for [{}]", (Object)databaseFilePath);
            AuditService sourceAuditService = FlowConfigurationHistoryMigrator.getSourceAuditSource((Path)databaseFilePath);
            int migrated = FlowConfigurationHistoryMigrator.migrateActions((AuditService)sourceAuditService, (AuditService)auditService);
            logger.info("H2 DB migration for Flow Configuration History completed for [{}] containing [{}] records", (Object)databaseFilePath, (Object)migrated);
            String backupFileName = String.format("%s.backup.%d", databaseFilePath.getFileName(), System.currentTimeMillis());
            Path backupFilePath = databaseFilePath.resolveSibling(backupFileName);
            Files.move(databaseFilePath, backupFilePath, new CopyOption[0]);
            logger.info("H2 DB migration for Flow Configuration History moved [{}] to [{}]", (Object)databaseFilePath, (Object)backupFilePath);
        } else {
            logger.debug("H2 DB migration for Flow Configuration History not required");
        }
    }

    private static AuditService getSourceAuditSource(Path databaseFilePath) throws Exception {
        String databaseNamePath = databaseFilePath.resolveSibling("nifi-flow-audit").toString();
        String databaseUrl = String.format("%s%s;AUTOCOMMIT=OFF;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=3", "jdbc:h2:", databaseNamePath);
        H2DatabaseUpdater.checkAndPerformMigration((String)databaseNamePath, (String)databaseUrl, (String)"nf", (String)"nf");
        JdbcConnectionPool dataSource = JdbcConnectionPool.create((String)databaseUrl, (String)"nf", (String)"nf");
        StandardTransactionBuilder transactionBuilder = new StandardTransactionBuilder();
        transactionBuilder.setDataSource((DataSource)dataSource);
        StandardAuditService auditService = new StandardAuditService();
        auditService.setTransactionBuilder((TransactionBuilder)transactionBuilder);
        return auditService;
    }

    private static int migrateActions(AuditService sourceAuditService, AuditService auditService) {
        int migrated;
        HistoryQuery query = new HistoryQuery();
        query.setCount(Integer.valueOf(1000));
        query.setOffset(Integer.valueOf(0));
        History initialHistory = sourceAuditService.getActions(query);
        int total = initialHistory.getTotal();
        Collection actions = initialHistory.getActions();
        for (migrated = 0; migrated < total; migrated += actions.size()) {
            auditService.addActions(actions);
            query.setOffset(Integer.valueOf(query.getOffset() + 1000));
            History history = sourceAuditService.getActions(query);
            actions = history.getActions();
        }
        return migrated;
    }
}

