/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class BackPressureMatcher
implements AttributeMatcher<Connection> {
    private static final String MATCH_PREFIX_SIZE = "Back pressure data size: ";
    private static final String MATCH_PREFIX_COUNT = "Back pressure count: ";
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("back pressure", "pressure"));

    public void match(Connection component, SearchQuery query, List<String> matches) {
        if (this.containsKeyword(query)) {
            String backPressureDataSize = component.getFlowFileQueue().getBackPressureDataSizeThreshold();
            Double backPressureBytes = DataUnit.parseDataSize((String)backPressureDataSize, (DataUnit)DataUnit.B);
            long backPressureCount = component.getFlowFileQueue().getBackPressureObjectThreshold();
            if (backPressureBytes > 0.0) {
                matches.add(MATCH_PREFIX_SIZE + backPressureDataSize);
            }
            if (backPressureCount > 0L) {
                matches.add(MATCH_PREFIX_COUNT + backPressureCount);
            }
        }
    }

    private boolean containsKeyword(SearchQuery query) {
        return KEYWORDS.stream().anyMatch(keyword -> StringUtils.containsIgnoreCase((CharSequence)keyword, (CharSequence)query.getTerm()));
    }
}

