/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.StandardParameterProviderConfiguration;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextReferenceDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.ParameterProviderConfigurationDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ParameterProviderConfigurationEntity;
import org.apache.nifi.web.dao.ParameterContextDAO;

/*
 * Exception performing whole class analysis ignored.
 */
public class StandardParameterContextDAO
implements ParameterContextDAO {
    private FlowManager flowManager;
    private Authorizer authorizer;

    public boolean hasParameterContext(String parameterContextId) {
        return this.flowManager.getParameterContextManager().getParameterContext(parameterContextId) != null;
    }

    public void verifyCreate(ParameterContextDTO parameterContextDto) {
        this.verifyNoNamingConflict(parameterContextDto.getName());
        this.verifyInheritedParameterContextRefs(parameterContextDto);
        this.verifyParameterSourceConflicts(parameterContextDto);
    }

    private void verifyInheritedParameterContextRefs(ParameterContextDTO parameterContextDto) {
        List inheritedParameterContexts = parameterContextDto.getInheritedParameterContexts();
        if (inheritedParameterContexts != null) {
            this.resolveInheritedParameterContexts(parameterContextDto);
            inheritedParameterContexts.forEach(entity -> this.flowManager.getParameterContextManager().getParameterContext(entity.getComponent().getId()));
        }
        this.authorizeReferences(parameterContextDto);
    }

    public ParameterContext createParameterContext(ParameterContextDTO parameterContextDto) {
        Map parameters = this.getParameters(parameterContextDto, null);
        ParameterProviderConfigurationEntity parameterProviderConfigurationEntity = parameterContextDto.getParameterProviderConfiguration();
        this.resolveInheritedParameterContexts(parameterContextDto);
        this.verifyParameterSourceConflicts(parameterContextDto);
        AtomicReference parameterContextReference = new AtomicReference();
        this.flowManager.withParameterContextResolution(() -> {
            List referencedIds = parameterContextDto.getInheritedParameterContexts() == null ? Collections.emptyList() : parameterContextDto.getInheritedParameterContexts().stream().map(ParameterContextReferenceEntity::getId).collect(Collectors.toList());
            ParameterProviderConfiguration parameterProviderConfiguration = this.createParameterProviderConfiguration(parameterProviderConfigurationEntity);
            ParameterContext parameterContext = this.flowManager.createParameterContext(parameterContextDto.getId(), parameterContextDto.getName(), parameters, referencedIds, parameterProviderConfiguration);
            if (parameterContextDto.getDescription() != null) {
                parameterContext.setDescription(parameterContextDto.getDescription());
            }
            parameterContextReference.set(parameterContext);
        });
        return (ParameterContext)parameterContextReference.get();
    }

    private ParameterProviderConfiguration createParameterProviderConfiguration(ParameterProviderConfigurationEntity parameterProviderConfigurationEntity) {
        if (parameterProviderConfigurationEntity == null || parameterProviderConfigurationEntity.getComponent() == null) {
            return null;
        }
        ParameterProviderConfigurationDTO dto = parameterProviderConfigurationEntity.getComponent();
        return new StandardParameterProviderConfiguration(dto.getParameterProviderId(), dto.getParameterGroupName(), dto.getSynchronized());
    }

    public static String getParameterProviderId(ParameterProviderConfigurationEntity parameterProviderConfigurationEntity) {
        if (parameterProviderConfigurationEntity == null) {
            return null;
        }
        ParameterProviderConfigurationDTO dto = parameterProviderConfigurationEntity.getComponent();
        if (dto == null) {
            return null;
        }
        return dto.getParameterProviderId();
    }

    private void authorizeReferences(ParameterContextDTO parameterContextDto) {
        ParameterProviderNode parameterProvider;
        NiFiUser nifiUser = NiFiUserUtils.getNiFiUser();
        if (parameterContextDto.getInheritedParameterContexts() != null) {
            for (ParameterContextReferenceEntity ref : parameterContextDto.getInheritedParameterContexts()) {
                ParameterContext parameterContext = this.getParameterContext(ref.getComponent().getId());
                parameterContext.authorize(this.authorizer, RequestAction.READ, nifiUser);
            }
        }
        if ((parameterProvider = this.getParameterProviderNode(parameterContextDto.getParameterProviderConfiguration())) != null) {
            parameterProvider.authorize(this.authorizer, RequestAction.READ, nifiUser);
        }
    }

    private void resolveInheritedParameterContexts(ParameterContextDTO parameterContextDto) {
        List inheritedParameterContexts = parameterContextDto.getInheritedParameterContexts();
        if (inheritedParameterContexts == null || inheritedParameterContexts.isEmpty()) {
            return;
        }
        Map paramContextNameMap = this.flowManager.getParameterContextManager().getParameterContextNameMapping();
        for (ParameterContextReferenceEntity ref : inheritedParameterContexts) {
            if (ref.getComponent() == null || ref.getComponent().getId() == null && ref.getComponent().getName() == null) {
                throw new IllegalArgumentException(String.format("Could not resolve inherited parameter context references in Parameter Context [%s]", parameterContextDto.getName()));
            }
            ParameterContextReferenceDTO refDto = ref.getComponent();
            if (refDto.getId() != null) continue;
            ParameterContext resolvedParameterContext = (ParameterContext)paramContextNameMap.get(refDto.getName());
            if (resolvedParameterContext == null) {
                throw new IllegalArgumentException(String.format("Parameter Context [%s] references missing inherited Parameter Context [%s]", parameterContextDto.getName(), refDto.getName()));
            }
            ref.setId(resolvedParameterContext.getIdentifier());
            ref.getComponent().setId(resolvedParameterContext.getIdentifier());
        }
    }

    public Map<String, Parameter> getParameters(ParameterContextDTO parameterContextDto, ParameterContext context) {
        Set parameterEntities = parameterContextDto.getParameters();
        if (parameterEntities == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
        for (ParameterEntity parameterEntity : parameterEntities) {
            boolean deletion;
            ParameterDTO parameterDto = parameterEntity.getParameter();
            if (parameterDto.getInherited() != null && parameterDto.getInherited().booleanValue()) continue;
            if (parameterDto.getName() == null) {
                throw new IllegalArgumentException("Cannot specify a Parameter without a name");
            }
            boolean bl = deletion = parameterDto.getDescription() == null && parameterDto.getSensitive() == null && parameterDto.getValue() == null;
            if (deletion) {
                parameterMap.put(parameterDto.getName().trim(), null);
                continue;
            }
            Parameter parameter = this.createParameter(parameterDto, context);
            parameterMap.put(parameterDto.getName().trim(), parameter);
        }
        return parameterMap;
    }

    private Parameter createParameter(ParameterDTO dto, ParameterContext context) {
        String value;
        ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(dto.getName()).description(dto.getDescription()).sensitive(Boolean.TRUE.equals(dto.getSensitive())).build();
        if (dto.getValue() == null && Boolean.TRUE.equals(dto.getValueRemoved())) {
            value = null;
        } else if (dto.getValue() == null && context != null) {
            Optional optionalParameter = context.getParameter(dto.getName());
            value = optionalParameter.map(Parameter::getValue).orElse(dto.getValue());
        } else {
            value = dto.getValue();
        }
        String parameterContextId = dto.getParameterContext() == null ? null : dto.getParameterContext().getId();
        return new Parameter(descriptor, value, parameterContextId, dto.getProvided());
    }

    public ParameterContext getParameterContext(String parameterContextId) {
        ParameterContext context = this.flowManager.getParameterContextManager().getParameterContext(parameterContextId);
        if (context == null) {
            throw new ResourceNotFoundException(String.format("Unable to find Parameter Context with id '%s'.", parameterContextId));
        }
        return context;
    }

    public Set<ParameterContext> getParameterContexts() {
        return this.flowManager.getParameterContextManager().getParameterContexts();
    }

    public ParameterContext updateParameterContext(ParameterContextDTO parameterContextDto) {
        this.verifyUpdate(parameterContextDto, true);
        ParameterContext context = this.getParameterContext(parameterContextDto.getId());
        if (parameterContextDto.getName() != null) {
            this.verifyNoNamingConflict(parameterContextDto.getName(), parameterContextDto.getId());
            context.setName(parameterContextDto.getName());
        }
        if (parameterContextDto.getDescription() != null) {
            context.setDescription(parameterContextDto.getDescription());
        }
        if (parameterContextDto.getParameters() != null) {
            Map parameters = this.getParameters(parameterContextDto, context);
            context.setParameters(parameters);
        }
        if (parameterContextDto.getInheritedParameterContexts() != null) {
            List inheritedParameterContexts = this.getInheritedParameterContexts(parameterContextDto);
            context.setInheritedParameterContexts(inheritedParameterContexts);
        }
        return context;
    }

    public List<ParameterContext> getInheritedParameterContexts(ParameterContextDTO parameterContextDto) {
        this.resolveInheritedParameterContexts(parameterContextDto);
        ArrayList<ParameterContext> inheritedParameterContexts = new ArrayList<ParameterContext>();
        if (parameterContextDto.getInheritedParameterContexts() != null) {
            inheritedParameterContexts.addAll(parameterContextDto.getInheritedParameterContexts().stream().map(entity -> this.flowManager.getParameterContextManager().getParameterContext(entity.getComponent().getId())).collect(Collectors.toList()));
        }
        return inheritedParameterContexts;
    }

    public void verifyUpdate(ParameterContextDTO parameterContextDto, boolean verifyComponentStates) {
        this.verifyNoNamingConflict(parameterContextDto.getName(), parameterContextDto.getId());
        this.verifyInheritedParameterContextRefs(parameterContextDto);
        this.verifyParameterSourceConflicts(parameterContextDto);
        String parameterProviderId = StandardParameterContextDAO.getParameterProviderId((ParameterProviderConfigurationEntity)parameterContextDto.getParameterProviderConfiguration());
        ParameterContext currentContext = this.getParameterContext(parameterContextDto.getId());
        if (parameterProviderId != null && currentContext.getParameterProvider() == null) {
            throw new IllegalArgumentException(String.format("A Parameter Provider [%s] cannot be added to Parameter Context [%s]", parameterProviderId, parameterContextDto.getName()));
        }
        List inheritedParameterContexts = this.getInheritedParameterContexts(parameterContextDto);
        Map parameters = parameterContextDto.getParameters() == null ? Collections.emptyMap() : this.getParameters(parameterContextDto, currentContext);
        currentContext.verifyCanUpdateParameterContext(parameters, inheritedParameterContexts);
        HashMap proposedParameters = new HashMap();
        if (parameterContextDto.getParameters() != null) {
            proposedParameters.putAll(this.getParameters(parameterContextDto, currentContext));
        }
    }

    public ParameterProvider getParameterProvider(ParameterContextDTO parameterContextDTO) {
        return this.getParameterProvider(parameterContextDTO.getParameterProviderConfiguration());
    }

    private ParameterProvider getParameterProvider(ParameterProviderConfigurationEntity parameterProviderConfiguration) {
        ParameterProviderNode parameterProviderNode = this.getParameterProviderNode(parameterProviderConfiguration);
        return parameterProviderNode == null ? null : parameterProviderNode.getParameterProvider();
    }

    private void verifyParameterSourceConflicts(ParameterContextDTO parameterContextDTO) {
        String parameterProviderId = StandardParameterContextDAO.getParameterProviderId((ParameterProviderConfigurationEntity)parameterContextDTO.getParameterProviderConfiguration());
        Set parameters = parameterContextDTO.getParameters();
        if (parameters == null) {
            return;
        }
        if (parameterProviderId != null) {
            boolean hasUserEnteredParameters = parameters.stream().anyMatch(parameter -> parameter.getParameter().getProvided() == null || parameter.getParameter().getProvided() == false);
            if (hasUserEnteredParameters) {
                throw new IllegalArgumentException(String.format("User-entered Parameters may not be set on Context [%s] because its parameters are already provided by [%s]", parameterContextDTO.getName(), parameterProviderId));
            }
        } else {
            boolean hasProvidedParameters = parameters.stream().anyMatch(parameter -> parameter.getParameter().getProvided() != null && parameter.getParameter().getProvided() != false);
            if (hasProvidedParameters) {
                throw new IllegalArgumentException(String.format("Provided Parameters may not be set on Context [%s] because its parameters can only be user-entered", parameterContextDTO.getName()));
            }
        }
    }

    private ParameterProviderNode getParameterProviderNode(ParameterProviderConfigurationEntity parameterProviderConfiguration) {
        ParameterProviderNode parameterProviderNode = null;
        String parameterProviderId = StandardParameterContextDAO.getParameterProviderId((ParameterProviderConfigurationEntity)parameterProviderConfiguration);
        if (parameterProviderId != null && (parameterProviderNode = this.flowManager.getParameterProvider(parameterProviderId)) == null) {
            throw new IllegalArgumentException("Unable to locate Parameter Provider with id '" + parameterProviderId + "'");
        }
        return parameterProviderNode;
    }

    private void verifyNoNamingConflict(String contextName) {
        this.verifyNoNamingConflict(contextName, null);
    }

    private void verifyNoNamingConflict(String contextName, String contextId) {
        if (contextName == null) {
            return;
        }
        for (ParameterContext parameterContext : this.flowManager.getParameterContextManager().getParameterContexts()) {
            if (!parameterContext.getName().equals(contextName) || contextId == null || contextId.equals(parameterContext.getIdentifier())) continue;
            throw new IllegalStateException("Cannot update Parameter Context name because another Parameter Context already exists with the name '" + contextName + "'");
        }
    }

    public void verifyDelete(String parameterContextId) {
        List groupsReferencingParameterContext = this.getBoundProcessGroups(parameterContextId);
        for (ProcessGroup group : groupsReferencingParameterContext) {
            for (ProcessorNode processor : group.getProcessors()) {
                if (!processor.isReferencingParameter() || !processor.isRunning()) continue;
                throw new IllegalStateException("Cannot delete Parameter Context with ID " + parameterContextId + " because it is in use by at least one Processor that is running");
            }
            for (ControllerServiceNode service : group.getControllerServices(false)) {
                if (!service.isReferencingParameter() || service.getState() == ControllerServiceState.DISABLED) continue;
                throw new IllegalStateException("Cannot delete Parameter Context with ID " + parameterContextId + " because it is in use by at least one Controller Service that is enabled");
            }
        }
        for (ParameterContext parameterContext : this.flowManager.getParameterContextManager().getParameterContexts()) {
            if (!parameterContext.getInheritedParameterContexts().stream().anyMatch(pc -> pc.getIdentifier().equals(parameterContextId))) continue;
            throw new IllegalStateException(String.format("Cannot delete Parameter Context with ID [%s] because it is referenced by at least one Parameter Context [%s]", parameterContextId, parameterContext.getName()));
        }
    }

    public void deleteParameterContext(String parameterContextId) {
        this.verifyDelete(parameterContextId);
        this.flowManager.getParameterContextManager().removeParameterContext(parameterContextId);
        this.getBoundProcessGroups(parameterContextId).forEach(group -> group.setParameterContext(null));
        this.flowManager.getAllParameterProviders().forEach(provider -> {
            ArrayList referencesToRemove = new ArrayList();
            provider.getReferences().stream().filter(reference -> parameterContextId.equals(reference.getIdentifier())).forEach(referencesToRemove::add);
            referencesToRemove.forEach(arg_0 -> ((ParameterProviderNode)provider).removeReference(arg_0));
        });
    }

    public void setFlowController(FlowController flowController) {
        this.flowManager = flowController.getFlowManager();
    }

    private List<ProcessGroup> getBoundProcessGroups(String parameterContextId) {
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        return rootGroup.findAllProcessGroups(group -> group.getParameterContext() != null && group.getParameterContext().getIdentifier().equals(parameterContextId));
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

