/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class SchedulingMatcher
implements AttributeMatcher<ProcessorNode> {
    private static final String SEARCH_TERM_EVENT = "event";
    private static final String SEARCH_TERM_TIMER = "timer";
    private static final String SEARCH_TERM_PRIMARY = "primary";
    private static final String MATCH_PREFIX = "Scheduling strategy: ";
    private static final String MATCH_EVENT = "Event driven";
    private static final String MATCH_TIMER = "Timer driven";
    private static final String MATCH_PRIMARY = "On primary node";

    public void match(ProcessorNode component, SearchQuery query, List<String> matches) {
        String searchTerm = query.getTerm();
        SchedulingStrategy schedulingStrategy = component.getSchedulingStrategy();
        if (SchedulingStrategy.EVENT_DRIVEN.equals((Object)schedulingStrategy) && StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_EVENT, (CharSequence)searchTerm)) {
            matches.add("Scheduling strategy: Event driven");
        } else if (SchedulingStrategy.TIMER_DRIVEN.equals((Object)schedulingStrategy) && StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_TIMER, (CharSequence)searchTerm)) {
            matches.add("Scheduling strategy: Timer driven");
        } else if (SchedulingStrategy.PRIMARY_NODE_ONLY.equals((Object)schedulingStrategy) && StringUtils.containsIgnoreCase((CharSequence)SEARCH_TERM_PRIMARY, (CharSequence)searchTerm)) {
            matches.add("Scheduling strategy: On primary node");
        }
    }
}

