/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.Date;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.web.dao.FunnelDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FunnelAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(FunnelAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.FunnelDAO+) && execution(org.apache.nifi.connectable.Funnel createFunnel(java.lang.String, org.apache.nifi.web.api.dto.FunnelDTO))")
    public Funnel createFunnelAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Funnel funnel = (Funnel)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(funnel, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return funnel;
    }

    @Around(value="within(org.apache.nifi.web.dao.FunnelDAO+) && execution(void deleteFunnel(java.lang.String)) && args(funnelId) && target(funnelDAO)")
    public void removeFunnelAdvice(ProceedingJoinPoint proceedingJoinPoint, String funnelId, FunnelDAO funnelDAO) throws Throwable {
        Funnel funnel = funnelDAO.getFunnel(funnelId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(funnel, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(Funnel funnel, Operation operation) {
        return this.generateAuditRecord(funnel, operation, null);
    }

    public Action generateAuditRecord(Funnel funnel, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(funnel.getIdentifier());
            action.setSourceName(funnel.getName());
            action.setSourceType(Component.Funnel);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

