/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.controller.ControllerFacade;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ControllerAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ControllerAuditor.class);

    @Around(value="within(org.apache.nifi.web.controller.ControllerFacade) && execution(void setMaxTimerDrivenThreadCount(int)) && args(maxTimerDrivenThreadCount) && target(controllerFacade)")
    public void updateControllerTimerDrivenThreadsAdvice(ProceedingJoinPoint proceedingJoinPoint, int maxTimerDrivenThreadCount, ControllerFacade controllerFacade) throws Throwable {
        NiFiUser user;
        int previousMaxTimerDrivenThreadCount = controllerFacade.getMaxTimerDrivenThreadCount();
        proceedingJoinPoint.proceed();
        if (previousMaxTimerDrivenThreadCount != maxTimerDrivenThreadCount && (user = NiFiUserUtils.getNiFiUser()) != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeConfigureDetails configDetails = new FlowChangeConfigureDetails();
            configDetails.setName("Controller Max Timer Driven Thread Count");
            configDetails.setValue(String.valueOf(maxTimerDrivenThreadCount));
            configDetails.setPreviousValue(String.valueOf(previousMaxTimerDrivenThreadCount));
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.Configure);
            configAction.setTimestamp(new Date());
            configAction.setSourceId("Flow Controller");
            configAction.setSourceName("Flow Controller");
            configAction.setSourceType(Component.Controller);
            configAction.setActionDetails((ActionDetails)configDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
    }

    @Around(value="within(org.apache.nifi.web.controller.ControllerFacade) && execution(void setMaxEventDrivenThreadCount(int)) && args(maxEventDrivenThreadCount) && target(controllerFacade)")
    public void updateControllerEventDrivenThreadsAdvice(ProceedingJoinPoint proceedingJoinPoint, int maxEventDrivenThreadCount, ControllerFacade controllerFacade) throws Throwable {
        NiFiUser user;
        int previousMaxEventDrivenThreadCount = controllerFacade.getMaxEventDrivenThreadCount();
        proceedingJoinPoint.proceed();
        if (previousMaxEventDrivenThreadCount != maxEventDrivenThreadCount && (user = NiFiUserUtils.getNiFiUser()) != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeConfigureDetails configDetails = new FlowChangeConfigureDetails();
            configDetails.setName("Controller Max Event Driven Thread Count");
            configDetails.setValue(String.valueOf(maxEventDrivenThreadCount));
            configDetails.setPreviousValue(String.valueOf(previousMaxEventDrivenThreadCount));
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.Configure);
            configAction.setTimestamp(new Date());
            configAction.setSourceId("Flow Controller");
            configAction.setSourceName("Flow Controller");
            configAction.setSourceType(Component.Controller);
            configAction.setActionDetails((ActionDetails)configDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
    }
}

