/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.FormatUtils;

public final class StopWatch {
    private long startNanos = -1L;
    private long duration = -1L;

    public StopWatch() {
        this(false);
    }

    public StopWatch(boolean autoStart) {
        if (autoStart) {
            this.start();
        }
    }

    public void start() {
        this.startNanos = System.nanoTime();
        this.duration = -1L;
    }

    public void stop() {
        if (this.startNanos < 0L) {
            throw new IllegalStateException("StopWatch has not been started");
        }
        this.duration = System.nanoTime() - this.startNanos;
        this.startNanos = -1L;
    }

    public long getDuration(TimeUnit timeUnit) {
        if (this.duration < 0L) {
            throw new IllegalStateException("Cannot get duration until StopWatch has been stopped");
        }
        return timeUnit.convert(this.duration, TimeUnit.NANOSECONDS);
    }

    public long getElapsed(TimeUnit timeUnit) {
        return timeUnit.convert(System.nanoTime() - this.startNanos, TimeUnit.NANOSECONDS);
    }

    public String calculateDataRate(long bytes) {
        double seconds = (double)this.duration / 1.0E9;
        long dataSize = (long)((double)bytes / seconds);
        return FormatUtils.formatDataSize(dataSize) + "/sec";
    }

    public String getDuration() {
        StringBuilder sb = new StringBuilder();
        long duration = this.duration;
        long minutes = duration > 60000000000L ? duration / 60000000000L : 0L;
        long seconds = (duration -= TimeUnit.NANOSECONDS.convert(minutes, TimeUnit.MINUTES)) > 1000000000L ? duration / 1000000000L : 0L;
        long millis = (duration -= TimeUnit.NANOSECONDS.convert(seconds, TimeUnit.SECONDS)) > 1000000L ? duration / 1000000L : 0L;
        long nanos = (duration -= TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS)) % 1000000L;
        if (minutes > 0L) {
            sb.append(minutes).append(" minutes");
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                sb.append(", ");
            }
            sb.append(seconds).append(" seconds");
        }
        if (millis > 0L) {
            if (seconds > 0L) {
                sb.append(", ");
            }
            sb.append(millis).append(" millis");
        }
        if (seconds == 0L && millis == 0L) {
            sb.append(nanos).append(" nanos");
        }
        return sb.toString();
    }
}

