/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class NetworkUtils {
    public static int availablePort() {
        return NetworkUtils.getAvailableTcpPort();
    }

    public static int getAvailableTcpPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Available TCP Port not found", e);
            }
        }
        socket.close();
        return n;
    }

    public static int getAvailableUdpPort() {
        DatagramSocket socket = new DatagramSocket();
        try {
            int n = socket.getLocalPort();
            socket.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Available UDP Port not found", e);
            }
        }
    }

    public static boolean isListening(String hostname, int port) {
        boolean bl;
        Socket s = new Socket(hostname, port);
        try {
            bl = s.isConnected();
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        s.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isListening(String hostname, int port, int timeoutMillis) {
        Boolean result = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            result = executor.submit(() -> {
                while (!NetworkUtils.isListening(hostname, port)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                return true;
            }).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                executor.shutdown();
            }
            catch (Exception exception) {}
        }
        return result != null && result != false;
    }

    public static InetAddress getInterfaceAddress(String interfaceName) throws SocketException {
        InetAddress interfaceAddress = null;
        if (interfaceName != null && !interfaceName.isEmpty()) {
            NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
            interfaceAddress = networkInterface.getInetAddresses().nextElement();
        }
        return interfaceAddress;
    }
}

