/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.update.attributes.serde;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.update.attributes.Criteria;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;

public class CriteriaSerDe {
    private static final JAXBContext JAXB_CONTEXT;

    public static String serialize(Criteria criteria) {
        StringWriter writer = new StringWriter();
        try {
            CriteriaBinding binding = new CriteriaBinding();
            binding.setFlowFilePolicy(criteria.getFlowFilePolicy());
            binding.setRules(criteria.getRules());
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)binding, (Writer)writer);
        }
        catch (JAXBException jaxbe) {
            throw new IllegalArgumentException(jaxbe);
        }
        return writer.toString();
    }

    public static Criteria deserialize(String string) {
        Criteria criteria = null;
        if (string != null && !string.trim().equals("")) {
            try {
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                XMLStreamReader xsr = provider.getStreamReader(new StreamSource(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))));
                JAXBElement element = unmarshaller.unmarshal(xsr, CriteriaBinding.class);
                CriteriaBinding binding = (CriteriaBinding)element.getValue();
                criteria = new Criteria(binding.getFlowFilePolicy(), binding.getRules());
            }
            catch (JAXBException | ProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return criteria;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{CriteriaBinding.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create JAXB Context for UpdateAttribute", e);
        }
    }

    @XmlRootElement(name="criteria")
    private static class CriteriaBinding {
        private List<Rule> rules = null;
        private FlowFilePolicy flowFilePolicy = FlowFilePolicy.USE_CLONE;

        private CriteriaBinding() {
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        public FlowFilePolicy getFlowFilePolicy() {
            return this.flowFilePolicy;
        }

        public void setFlowFilePolicy(FlowFilePolicy flowFilePolicy) {
            this.flowFilePolicy = flowFilePolicy;
        }
    }
}

