/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog.events;

import java.util.Map;

public class Syslog5424Event {
    private final Map<String, Object> fieldMap;
    private final String fullMessage;
    private final byte[] rawMessage;
    private final String sender;
    private final boolean valid;
    private final Exception exception;

    private Syslog5424Event(Builder builder) {
        this.fieldMap = builder.fieldMap;
        this.fullMessage = builder.fullMessage;
        this.rawMessage = builder.rawMessage;
        this.sender = builder.sender;
        this.valid = builder.valid;
        this.exception = builder.exception;
    }

    public Map<String, Object> getFieldMap() {
        return this.fieldMap;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public String getSender() {
        return this.sender;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static final class Builder {
        private Exception exception;
        private String fullMessage;
        private String sender;
        private Map<String, Object> fieldMap;
        private byte[] rawMessage;
        private boolean valid;

        public void reset() {
            this.fieldMap = null;
            this.sender = null;
            this.fullMessage = null;
            this.valid = false;
            this.exception = null;
        }

        public Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public Builder exception(Exception exception) {
            this.exception = exception;
            return this;
        }

        public Builder fieldMap(Map<String, Object> fieldMap) {
            this.fieldMap = fieldMap;
            return this;
        }

        public Builder fullMessage(String fullMessage) {
            this.fullMessage = fullMessage;
            return this;
        }

        public Builder rawMessage(byte[] rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public Syslog5424Event build() {
            return new Syslog5424Event(this);
        }
    }
}

