/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.stateless.retrieval;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.File;
import java.io.IOException;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.stateless.ExecuteStateless;
import org.apache.nifi.processors.stateless.retrieval.DataflowProvider;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;

public class CachingDataflowProvider
implements DataflowProvider {
    private final String processorId;
    private final ComponentLog logger;
    private final DataflowProvider delegate;
    private final ObjectMapper objectMapper;

    public CachingDataflowProvider(String processorId, ComponentLog logger, DataflowProvider delegate) {
        this.processorId = processorId;
        this.logger = logger;
        this.delegate = delegate;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(this.objectMapper.getTypeFactory()));
    }

    @Override
    public VersionedFlowSnapshot retrieveDataflowContents(ProcessContext context) throws IOException {
        try {
            VersionedFlowSnapshot retrieved = this.delegate.retrieveDataflowContents(context);
            this.cacheFlowSnapshot(context, retrieved);
            return retrieved;
        }
        catch (Exception e) {
            File cacheFile = this.getFlowCacheFile(context, this.processorId);
            if (cacheFile.exists()) {
                this.logger.warn("Failed to retrieve Flow Snapshot. Will restore Flow Snapshot from cached version at {}", new Object[]{cacheFile.getAbsolutePath(), e});
                return this.readCachedFlow(cacheFile);
            }
            throw new IOException("Failed to retrieve Flow Snapshot from configured endpoint and no cached version is available", e);
        }
    }

    private void cacheFlowSnapshot(ProcessContext context, VersionedFlowSnapshot flowSnapshot) {
        File cacheFile = this.getFlowCacheFile(context, this.processorId);
        if (!cacheFile.getParentFile().exists() && !cacheFile.getParentFile().mkdirs()) {
            this.logger.warn("Fetched dataflow but cannot create directory {} in order to cache the dataflow. Upon restart, processor will not be able to function unless flow endpoint is available", new Object[]{cacheFile});
            return;
        }
        try {
            this.objectMapper.writeValue(cacheFile, (Object)flowSnapshot);
        }
        catch (Exception e) {
            this.logger.warn("Fetched dataflow but failed to write the dataflow to disk at {} in order to cache the dataflow. Upon restart, processor will not be able to function unless flow endpoint is available", new Object[]{cacheFile, e});
        }
    }

    protected File getFlowCacheFile(ProcessContext context, String processorId) {
        String workingDirName = context.getProperty(ExecuteStateless.WORKING_DIRECTORY).getValue();
        File workingDir = new File(workingDirName);
        File dataflowCache = new File(workingDir, "dataflow-cache");
        File flowSnapshotFile = new File(dataflowCache, processorId + ".flow.snapshot.json");
        return flowSnapshotFile;
    }

    private VersionedFlowSnapshot readCachedFlow(File cacheFile) throws IOException {
        return (VersionedFlowSnapshot)this.objectMapper.readValue(cacheFile, VersionedFlowSnapshot.class);
    }
}

