/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.config;

import javax.net.ssl.SSLContext;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;

public class SslConfigurationUtil {
    public static SSLContext createSslContext(SslContextDefinition sslContextDefinition) throws StatelessConfigurationException {
        if (sslContextDefinition == null) {
            return null;
        }
        if (sslContextDefinition.getTruststoreFile() == null) {
            return null;
        }
        TlsConfiguration tlsConfiguration = SslConfigurationUtil.createTlsConfiguration(sslContextDefinition);
        try {
            return SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
        }
        catch (Exception e) {
            throw new StatelessConfigurationException("Failed to create SSL Context", (Throwable)e);
        }
    }

    public static TlsConfiguration createTlsConfiguration(SslContextDefinition sslContextDefinition) {
        return new StandardTlsConfiguration(sslContextDefinition.getKeystoreFile(), sslContextDefinition.getKeystorePass(), sslContextDefinition.getKeyPass(), sslContextDefinition.getKeystoreType(), sslContextDefinition.getTruststoreFile(), sslContextDefinition.getTruststorePass(), sslContextDefinition.getTruststoreType(), TlsConfiguration.getHighestCurrentSupportedTlsProtocolVersion());
    }
}

