/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.bootstrap;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionDiscovery.class);

    public static ExtensionDiscoveringManager discover(File narWorkingDirectory, ClassLoader systemClassLoader, NarClassLoaders narClassLoaders, boolean logExtensionDiscovery) throws IOException {
        logger.info("Initializing NAR ClassLoaders");
        try {
            narClassLoaders.init(systemClassLoader, null, narWorkingDirectory, logExtensionDiscovery);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not initialize Class Loaders", cnfe);
        }
        Set narBundles = narClassLoaders.getBundles();
        long discoveryStart = System.nanoTime();
        StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager(Collections.singleton(ParameterValueProvider.class));
        extensionManager.discoverExtensions(narBundles, logExtensionDiscovery);
        long discoveryMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - discoveryStart);
        logger.info("Successfully discovered extensions in {} milliseconds", (Object)discoveryMillis);
        return extensionManager;
    }
}

