/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StatelessStateManagerProvider;
import org.apache.nifi.components.validation.StandardValidationTrigger;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.reporting.LogComponentStatuses;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.extensions.ExtensionRepository;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.VersionedExternalFlowMetadata;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.processor.StandardValidationContext;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.stateless.config.ConfigurableExtensionDefinition;
import org.apache.nifi.stateless.config.ParameterContextDefinition;
import org.apache.nifi.stateless.config.ParameterDefinition;
import org.apache.nifi.stateless.config.ParameterValueProviderDefinition;
import org.apache.nifi.stateless.config.ReportingTaskDefinition;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.engine.StandardParameterValueProviderInitializationContext;
import org.apache.nifi.stateless.engine.StatelessEngine;
import org.apache.nifi.stateless.engine.StatelessEngineInitializationContext;
import org.apache.nifi.stateless.engine.StatelessReloadComponent;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.StandardStatelessFlow;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.parameter.CompositeParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProviderInitializationContext;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStatelessEngine
implements StatelessEngine {
    private static final Logger logger = LoggerFactory.getLogger(StandardStatelessEngine.class);
    private static final int CONCURRENT_EXTENSION_DOWNLOADS = 8;
    public static final Duration DEFAULT_STATUS_TASK_PERIOD = Duration.of(1L, ChronoUnit.MINUTES);
    private final ExtensionManager extensionManager;
    private final BulletinRepository bulletinRepository;
    private final StatelessStateManagerProvider stateManagerProvider;
    private final PropertyEncryptor propertyEncryptor;
    private final VariableRegistry rootVariableRegistry;
    private final ProcessScheduler processScheduler;
    private final KerberosConfig kerberosConfig;
    private final FlowFileEventRepository flowFileEventRepository;
    private final ProvenanceRepository provenanceRepository;
    private final ExtensionRepository extensionRepository;
    private final CounterRepository counterRepository;
    private final Duration statusTaskInterval;
    private final ReloadComponent reloadComponent;
    private final ValidationTrigger validationTrigger;
    private FlowManager flowManager;
    private ControllerServiceProvider controllerServiceProvider;
    private ProcessContextFactory processContextFactory;
    private RepositoryContextFactory repositoryContextFactory;
    private boolean initialized = false;

    private StandardStatelessEngine(Builder builder) {
        this.extensionManager = Objects.requireNonNull(builder.extensionManager, "Extension Manager must be provided");
        this.bulletinRepository = Objects.requireNonNull(builder.bulletinRepository, "Bulletin Repository must be provided");
        this.stateManagerProvider = Objects.requireNonNull(builder.stateManagerProvider, "State Manager Provider must be provided");
        this.propertyEncryptor = Objects.requireNonNull(builder.propertyEncryptor, "Encryptor must be provided");
        this.rootVariableRegistry = Objects.requireNonNull(builder.variableRegistry, "Variable Registry must be provided");
        this.processScheduler = Objects.requireNonNull(builder.processScheduler, "Process Scheduler must be provided");
        this.kerberosConfig = Objects.requireNonNull(builder.kerberosConfig, "Kerberos Configuration must be provided");
        this.flowFileEventRepository = Objects.requireNonNull(builder.flowFileEventRepository, "FlowFile Event Repository must be provided");
        this.provenanceRepository = Objects.requireNonNull(builder.provenanceRepository, "Provenance Repository must be provided");
        this.extensionRepository = Objects.requireNonNull(builder.extensionRepository, "Extension Repository must be provided");
        this.counterRepository = Objects.requireNonNull(builder.counterRepository, "Counter Repository must be provided");
        this.statusTaskInterval = StandardStatelessEngine.parseDuration(builder.statusTaskInterval);
        this.reloadComponent = new StatelessReloadComponent(this);
        this.validationTrigger = new StandardValidationTrigger((ExecutorService)new FlowEngine(1, "Component Validation", true), () -> true);
    }

    @Override
    public void initialize(StatelessEngineInitializationContext initContext) {
        this.flowManager = initContext.getFlowManager();
        this.controllerServiceProvider = initContext.getControllerServiceProvider();
        this.processContextFactory = initContext.getProcessContextFactory();
        this.repositoryContextFactory = initContext.getRepositoryContextFactory();
        this.initialized = true;
    }

    @Override
    public StatelessDataflow createFlow(DataflowDefinition dataflowDefinition) {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot create Flow without first initializing Stateless Engine");
        }
        VersionedExternalFlowMetadata metadata = dataflowDefinition.getVersionedExternalFlow().getMetadata();
        String flowName = metadata == null ? "" : metadata.getFlowName();
        logger.info("Building Dataflow {}", (Object)flowName);
        this.loadNecessaryExtensions(dataflowDefinition);
        this.extensionManager.logClassLoaderDetails();
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        ProcessGroup childGroup = this.flowManager.createProcessGroup("stateless-flow");
        childGroup.setName("Stateless Flow");
        rootGroup.addProcessGroup(childGroup);
        LogRepositoryFactory.purge();
        childGroup.updateFlow(dataflowDefinition.getVersionedExternalFlow(), "stateless-component-id-seed", false, true, true);
        ParameterValueProvider parameterValueProvider = this.createParameterValueProvider(dataflowDefinition);
        Map parameterContextMap = this.flowManager.getParameterContextManager().getParameterContextNameMapping();
        List parameterContextDefinitions = dataflowDefinition.getParameterContexts();
        if (parameterContextDefinitions != null) {
            parameterContextDefinitions.forEach(contextDefinition -> this.registerParameterContext((ParameterContextDefinition)contextDefinition, parameterContextMap));
        }
        this.overrideParameters(parameterContextMap, parameterValueProvider);
        List<ReportingTaskNode> reportingTaskNodes = this.createReportingTasks(dataflowDefinition);
        StandardStatelessFlow dataflow = new StandardStatelessFlow(childGroup, reportingTaskNodes, this.controllerServiceProvider, this.processContextFactory, this.repositoryContextFactory, dataflowDefinition, this.stateManagerProvider, this.processScheduler, this.bulletinRepository);
        if (this.statusTaskInterval != null) {
            LogComponentStatuses logComponentStatuses = new LogComponentStatuses(this.flowFileEventRepository, this.counterRepository, this.flowManager);
            dataflow.scheduleBackgroundTask(logComponentStatuses, this.statusTaskInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
        return dataflow;
    }

    private ParameterValueProvider createParameterValueProvider(DataflowDefinition dataflowDefinition) {
        ArrayList<ParameterValueProvider> providers = new ArrayList<ParameterValueProvider>();
        for (ParameterValueProviderDefinition definition : dataflowDefinition.getParameterValueProviderDefinitions()) {
            providers.add(this.createParameterValueProvider(definition));
        }
        CompositeParameterValueProvider provider = new CompositeParameterValueProvider(providers);
        StandardParameterValueProviderInitializationContext initializationContext = new StandardParameterValueProviderInitializationContext(provider, Collections.emptyMap(), UUID.randomUUID().toString());
        provider.initialize(initializationContext);
        return provider;
    }

    private ParameterValueProvider createParameterValueProvider(ParameterValueProviderDefinition definition) {
        BundleCoordinate bundleCoordinate = this.determineBundleCoordinate((ConfigurableExtensionDefinition)definition, "Parameter Value Provider");
        org.apache.nifi.bundle.Bundle bundle = this.extensionManager.getBundle(bundleCoordinate);
        if (bundle == null) {
            throw new IllegalStateException("Unable to find bundle for coordinate " + bundleCoordinate.getCoordinate());
        }
        String providerType = definition.getType();
        String providerId = UUID.randomUUID().toString();
        InstanceClassLoader classLoader = this.extensionManager.createInstanceClassLoader(providerType, providerId, bundle, Collections.emptySet());
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> rawClass = Class.forName(providerType, true, (ClassLoader)classLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            ParameterValueProvider parameterValueProvider = (ParameterValueProvider)rawClass.newInstance();
            Map<String, String> properties = this.resolveProperties(definition.getPropertyValues(), (ConfigurableComponent)parameterValueProvider, parameterValueProvider.getPropertyDescriptors());
            StandardParameterValueProviderInitializationContext initializationContext = new StandardParameterValueProviderInitializationContext(parameterValueProvider, properties, providerId);
            parameterValueProvider.initialize((ParameterValueProviderInitializationContext)initializationContext);
            List<ValidationResult> validationResults = this.validate((ConfigurableComponent)parameterValueProvider, properties, providerId);
            if (!validationResults.isEmpty()) {
                throw new IllegalStateException("Parameter Value Provider with name <" + definition.getName() + "> is not valid: " + validationResults);
            }
            ParameterValueProvider parameterValueProvider2 = parameterValueProvider;
            return parameterValueProvider2;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create Parameter Value Provider " + definition.getName() + " of type " + definition.getType(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialClassLoader);
        }
    }

    private List<ValidationResult> validate(ConfigurableComponent component, Map<String, String> properties, String componentId) {
        HashMap<PropertyDescriptor, PropertyConfiguration> explicitlyConfiguredPropertyMap = new HashMap<PropertyDescriptor, PropertyConfiguration>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            String propertyValue = property.getValue();
            PropertyDescriptor descriptor = component.getPropertyDescriptor(propertyName);
            PropertyConfiguration propertyConfiguration = new PropertyConfiguration(propertyValue, null, Collections.emptyList(), VariableImpact.NEVER_IMPACTED);
            explicitlyConfiguredPropertyMap.put(descriptor, propertyConfiguration);
        }
        Map<PropertyDescriptor, PropertyConfiguration> fullPropertyMap = this.buildConfiguredAndDefaultPropertyMap(component, explicitlyConfiguredPropertyMap);
        StandardValidationContext validationContext = new StandardValidationContext(this.controllerServiceProvider, fullPropertyMap, null, null, componentId, VariableRegistry.EMPTY_REGISTRY, null, true);
        Collection validationResults = component.validate((ValidationContext)validationContext);
        return validationResults.stream().filter(validationResult -> !validationResult.isValid()).collect(Collectors.toList());
    }

    public Map<PropertyDescriptor, PropertyConfiguration> buildConfiguredAndDefaultPropertyMap(ConfigurableComponent component, Map<PropertyDescriptor, PropertyConfiguration> properties) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, component.getClass(), (String)component.getIdentifier());){
            List supported = component.getPropertyDescriptors();
            if (supported == null || supported.isEmpty()) {
                Map<PropertyDescriptor, PropertyConfiguration> map = Collections.unmodifiableMap(properties);
                return map;
            }
            LinkedHashMap<PropertyDescriptor, PropertyConfiguration> props = new LinkedHashMap<PropertyDescriptor, PropertyConfiguration>();
            for (PropertyDescriptor descriptor : supported) {
                props.put(descriptor, null);
            }
            props.putAll(properties);
            LinkedHashMap<PropertyDescriptor, PropertyConfiguration> linkedHashMap = props;
            return linkedHashMap;
        }
    }

    private void loadNecessaryExtensions(DataflowDefinition dataflowDefinition) {
        Set<org.apache.nifi.bundle.Bundle> downloadedBundles;
        BundleCoordinate coordinate;
        VersionedProcessGroup group = dataflowDefinition.getVersionedExternalFlow().getFlowContents();
        Set<BundleCoordinate> requiredBundles = this.gatherRequiredBundles(group);
        for (ReportingTaskDefinition reportingTaskDefinition : dataflowDefinition.getReportingTaskDefinitions()) {
            coordinate = this.parseBundleCoordinate((ConfigurableExtensionDefinition)reportingTaskDefinition);
            if (coordinate == null) continue;
            requiredBundles.add(coordinate);
        }
        for (ParameterValueProviderDefinition parameterValueProviderDefinition : dataflowDefinition.getParameterValueProviderDefinitions()) {
            coordinate = this.parseBundleCoordinate((ConfigurableExtensionDefinition)parameterValueProviderDefinition);
            if (coordinate == null) continue;
            requiredBundles.add(coordinate);
        }
        Set<BundleCoordinate> unavailableBundles = this.determineUnavailableBundles(requiredBundles);
        FlowEngine executor = new FlowEngine(8, "Download Extensions", true);
        Future<Set<org.apache.nifi.bundle.Bundle>> future = this.extensionRepository.fetch(unavailableBundles, (ExecutorService)executor, 8);
        executor.shutdown();
        logger.info("Waiting for {} bundles to complete download...", (Object)unavailableBundles.size());
        long downloadStart = System.currentTimeMillis();
        try {
            downloadedBundles = future.get();
        }
        catch (Exception e) {
            logger.error("Failed to obtain all necessary extension bundles", (Throwable)e);
            throw new RuntimeException(e);
        }
        long downloadMillis = System.currentTimeMillis() - downloadStart;
        logger.info("Successfully downloaded {} bundles in {} millis", (Object)downloadedBundles.size(), (Object)downloadMillis);
    }

    private Set<BundleCoordinate> determineUnavailableBundles(Set<BundleCoordinate> coordinates) {
        HashSet<BundleCoordinate> unavailable = new HashSet<BundleCoordinate>();
        this.determineUnavailableBundles(coordinates, unavailable);
        return unavailable;
    }

    private void determineUnavailableBundles(Set<BundleCoordinate> coordinates, Set<BundleCoordinate> unavailable) {
        for (BundleCoordinate coordinate : coordinates) {
            org.apache.nifi.bundle.Bundle bundle = this.extensionManager.getBundle(coordinate);
            if (bundle == null) {
                unavailable.add(coordinate);
                continue;
            }
            BundleCoordinate parentCoordinate = bundle.getBundleDetails().getDependencyCoordinate();
            if (parentCoordinate == null) continue;
            this.determineUnavailableBundles(Collections.singleton(parentCoordinate), unavailable);
        }
    }

    private Set<BundleCoordinate> gatherRequiredBundles(VersionedProcessGroup group) {
        HashSet<BundleCoordinate> requiredBundles = new HashSet<BundleCoordinate>();
        this.gatherRequiredBundles(group, requiredBundles);
        return requiredBundles;
    }

    private void gatherRequiredBundles(VersionedProcessGroup group, Set<BundleCoordinate> requiredBundles) {
        group.getControllerServices().forEach(cs -> requiredBundles.add(this.toBundleCoordinate(cs.getBundle())));
        group.getProcessors().forEach(processor -> requiredBundles.add(this.toBundleCoordinate(processor.getBundle())));
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.gatherRequiredBundles(childGroup, requiredBundles);
        }
    }

    private BundleCoordinate toBundleCoordinate(Bundle bundle) {
        return new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }

    private List<ReportingTaskNode> createReportingTasks(DataflowDefinition dataflowDefinition) {
        ArrayList<ReportingTaskNode> reportingTaskNodes = new ArrayList<ReportingTaskNode>();
        for (ReportingTaskDefinition taskDefinition : dataflowDefinition.getReportingTaskDefinitions()) {
            ReportingTaskNode taskNode = this.createReportingTask(taskDefinition);
            reportingTaskNodes.add(taskNode);
        }
        return reportingTaskNodes;
    }

    private ReportingTaskNode createReportingTask(ReportingTaskDefinition taskDefinition) {
        BundleCoordinate bundleCoordinate = this.determineBundleCoordinate((ConfigurableExtensionDefinition)taskDefinition, "Reporting Task");
        ReportingTaskNode taskNode = this.flowManager.createReportingTask(taskDefinition.getType(), UUID.randomUUID().toString(), bundleCoordinate, Collections.emptySet(), true, true, null);
        Map<String, String> properties = this.resolveProperties(taskDefinition.getPropertyValues(), taskNode.getComponent(), taskNode.getProperties().keySet());
        taskNode.setProperties(properties);
        taskNode.setSchedulingStrategy(SchedulingStrategy.TIMER_DRIVEN);
        taskNode.setSchedulingPeriod(taskDefinition.getSchedulingFrequency());
        List<ValidationResult> validationResults = this.validate(taskNode.getComponent(), properties, taskNode.getIdentifier());
        if (!validationResults.isEmpty()) {
            throw new IllegalStateException("Reporting Task with name <" + taskNode.getName() + "> is not valid: " + validationResults);
        }
        return taskNode;
    }

    private Map<String, String> resolveProperties(Map<String, String> configured, ConfigurableComponent component, Collection<PropertyDescriptor> componentDescriptors) {
        HashMap<String, String> displayNameToActualName = new HashMap<String, String>();
        for (PropertyDescriptor descriptor : componentDescriptors) {
            displayNameToActualName.put(descriptor.getDisplayName(), descriptor.getName());
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : configured.entrySet()) {
            PropertyDescriptor descriptor;
            List allowableValues;
            String configuredName = entry.getKey();
            String configuredValue = entry.getValue();
            String actual = (String)displayNameToActualName.get(configuredName);
            String resolvedName = actual == null ? configuredName : actual;
            String resolvedValue = configuredValue;
            if (actual != null && (allowableValues = (descriptor = component.getPropertyDescriptor(actual)).getAllowableValues()) != null && !allowableValues.isEmpty()) {
                for (AllowableValue allowableValue : allowableValues) {
                    if (!allowableValue.getDisplayName().equalsIgnoreCase(configuredValue)) continue;
                    resolvedValue = allowableValue.getValue();
                    logger.debug("Resolving property value of {} for {} of {} to {}", new Object[]{configuredValue, configuredName, component, resolvedValue});
                    break;
                }
            }
            resolved.put(resolvedName, resolvedValue);
        }
        return resolved;
    }

    private BundleCoordinate determineBundleCoordinate(ConfigurableExtensionDefinition extensionDefinition, String extensionType) {
        List possibleBundles;
        String specifiedType;
        String explicitCoordinates = extensionDefinition.getBundleCoordinates();
        if (explicitCoordinates != null && !explicitCoordinates.trim().isEmpty()) {
            String resolvedClassName = this.resolveExtensionClassName(extensionDefinition, extensionType);
            extensionDefinition.setType(resolvedClassName);
            BundleCoordinate coordinate = this.parseBundleCoordinate(extensionDefinition);
            return coordinate;
        }
        String resolvedClassName = specifiedType = extensionDefinition.getType();
        if (!specifiedType.contains(".") && (possibleBundles = this.extensionManager.getBundles(extensionDefinition.getType())).isEmpty()) {
            logger.debug("Could not find extension type of <{}>. Will try to find matching Reporting Task type based on class name", (Object)specifiedType);
            resolvedClassName = this.resolveExtensionClassName(extensionDefinition, extensionType);
            extensionDefinition.setType(resolvedClassName);
            logger.info("Resolved extension class {} to {}", (Object)specifiedType, (Object)resolvedClassName);
        }
        if ((possibleBundles = this.extensionManager.getBundles(resolvedClassName)).isEmpty()) {
            throw new IllegalArgumentException("Extension '" + extensionDefinition.getName() + "' (" + extensionDefinition.getType() + ") does not specify a Bundle and no Bundles could be found for type " + extensionDefinition.getType());
        }
        if (possibleBundles.size() > 1) {
            throw new IllegalArgumentException("Extension '" + extensionDefinition.getName() + "' (" + extensionDefinition.getType() + ") does not specify a Bundle and multiple Bundles exist for this type. The extension must specify a bundle to use.");
        }
        org.apache.nifi.bundle.Bundle bundle = (org.apache.nifi.bundle.Bundle)possibleBundles.get(0);
        BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
        return coordinate;
    }

    private BundleCoordinate parseBundleCoordinate(ConfigurableExtensionDefinition extensionDefinition) {
        String specifiedCoordinates = extensionDefinition.getBundleCoordinates();
        if (specifiedCoordinates == null) {
            return null;
        }
        String[] splits = specifiedCoordinates.split(":", 3);
        if (splits.length != 3) {
            throw new IllegalArgumentException("Reporting Task '" + extensionDefinition.getName() + "' (" + extensionDefinition.getType() + ") specifies bundle as '" + specifiedCoordinates + "', but this is not a valid Bundle format. Format should be <group>:<id>:<version>");
        }
        return new BundleCoordinate(splits[0], splits[1], splits[2]);
    }

    private String resolveExtensionClassName(ConfigurableExtensionDefinition extensionDefinition, String extensionType) {
        String specifiedType = extensionDefinition.getType();
        if (specifiedType.contains(".")) {
            return specifiedType;
        }
        HashSet<String> possibleResolvedClassNames = new HashSet<String>();
        Set definitions = this.extensionManager.getExtensions(ReportingTask.class);
        for (ExtensionDefinition definition : definitions) {
            String implementationClassName = definition.getImplementationClassName();
            String simpleName = implementationClassName.contains(".") ? StringUtils.substringAfterLast((String)implementationClassName, (String)".") : implementationClassName;
            if (!simpleName.equals(specifiedType)) continue;
            logger.debug("Found possible matching class {}", (Object)implementationClassName);
            possibleResolvedClassNames.add(implementationClassName);
        }
        if (possibleResolvedClassNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s '%s' (%s) does not specify a Bundle, and no %s implementations exist with a class name of %s.", extensionType, extensionDefinition.getName(), extensionDefinition.getType(), extensionType, extensionDefinition.getType()));
        }
        if (possibleResolvedClassNames.size() > 1) {
            throw new IllegalArgumentException(String.format("%s '%s' (%s) does not specify a Bundle, and no %s implementations exist with a class name of %s. Perhaps you meant one of: %s", extensionType, extensionDefinition.getName(), extensionDefinition.getType(), extensionType, extensionDefinition.getType(), possibleResolvedClassNames));
        }
        return (String)possibleResolvedClassNames.iterator().next();
    }

    private void overrideParameters(Map<String, ParameterContext> parameterContextMap, ParameterValueProvider parameterValueProvider) {
        for (ParameterContext context : parameterContextMap.values()) {
            String contextName = context.getName();
            Map parameters = context.getEffectiveParameters();
            HashMap<String, Parameter> updatedParameters = new HashMap<String, Parameter>();
            for (Parameter parameter : parameters.values()) {
                String parameterName = parameter.getDescriptor().getName();
                if (!parameterValueProvider.isParameterDefined(contextName, parameterName)) continue;
                String providedValue = parameterValueProvider.getParameterValue(contextName, parameterName);
                Parameter updatedParameter = new Parameter(parameter.getDescriptor(), providedValue, parameter.getParameterContextId(), Boolean.valueOf(parameter.isProvided()));
                updatedParameters.put(parameterName, updatedParameter);
            }
            context.setParameters(updatedParameters);
        }
    }

    private void registerParameterContext(ParameterContextDefinition parameterContextDefinition, Map<String, ParameterContext> parameterContextMap) {
        String contextName = parameterContextDefinition.getName();
        ParameterContext existingContext = parameterContextMap.get(contextName);
        if (existingContext == null) {
            logger.warn("Configuration contains a Parameter Context with name <" + contextName + "> but the flow does not contain any Parameter Context with this name. These Parameters will be ignored.");
            return;
        }
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        List parameterDefinitions = parameterContextDefinition.getParameters();
        if (parameterDefinitions != null) {
            for (ParameterDefinition parameterDefinition : parameterDefinitions) {
                String parameterName = parameterDefinition.getName();
                Optional optionalParameter = existingContext.getParameter(parameterName);
                if (!optionalParameter.isPresent()) {
                    logger.warn("Configuration contains a Parameter with name <{}> for Parameter Context <{}> but the Parameter Context does not have a Parameter with that name. This Parameter will be ignored.", (Object)parameterName, (Object)contextName);
                    continue;
                }
                Parameter existingParameter = (Parameter)optionalParameter.get();
                Parameter updatedParameter = new Parameter(existingParameter.getDescriptor(), parameterDefinition.getValue(), existingParameter.getParameterContextId(), Boolean.valueOf(existingParameter.isProvided()));
                parameters.put(parameterName, updatedParameter);
            }
        }
        existingContext.setParameters(parameters);
        logger.info("Registered Parameter Context {}", (Object)parameterContextDefinition.getName());
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    @Override
    public StateManagerProvider getStateManagerProvider() {
        return this.stateManagerProvider;
    }

    @Override
    public PropertyEncryptor getPropertyEncryptor() {
        return this.propertyEncryptor;
    }

    @Override
    public VariableRegistry getRootVariableRegistry() {
        return this.rootVariableRegistry;
    }

    @Override
    public ProcessScheduler getProcessScheduler() {
        return this.processScheduler;
    }

    @Override
    public ReloadComponent getReloadComponent() {
        return this.reloadComponent;
    }

    @Override
    public ControllerServiceProvider getControllerServiceProvider() {
        return this.controllerServiceProvider;
    }

    @Override
    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    @Override
    public FlowFileEventRepository getFlowFileEventRepository() {
        return this.flowFileEventRepository;
    }

    @Override
    public KerberosConfig getKerberosConfig() {
        return this.kerberosConfig;
    }

    @Override
    public ValidationTrigger getValidationTrigger() {
        return this.validationTrigger;
    }

    @Override
    public FlowManager getFlowManager() {
        return this.flowManager;
    }

    @Override
    public CounterRepository getCounterRepository() {
        return this.counterRepository;
    }

    @Override
    public Duration getStatusTaskInterval() {
        return this.statusTaskInterval;
    }

    static Duration parseDuration(String durationValue) {
        if (durationValue == null || durationValue.trim().isEmpty()) {
            return null;
        }
        try {
            Long taskScheduleSeconds = FormatUtils.getTimeDuration((String)durationValue.trim(), (TimeUnit)TimeUnit.SECONDS);
            Duration taskScheduleDuration = Duration.ofSeconds(taskScheduleSeconds);
            if (taskScheduleDuration.toMillis() < 1000L) {
                logger.warn("Status task schedule period [{}] must be at least one second", (Object)durationValue);
                throw new IllegalArgumentException("Status task schedule period is too small");
            }
            return taskScheduleDuration;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Encountered invalid status task schedule: <{}>. Will ignore this property.", (Object)durationValue);
            return DEFAULT_STATUS_TASK_PERIOD;
        }
    }

    public static class Builder {
        private ExtensionManager extensionManager = null;
        private BulletinRepository bulletinRepository = null;
        private StatelessStateManagerProvider stateManagerProvider = null;
        private PropertyEncryptor propertyEncryptor = null;
        private VariableRegistry variableRegistry = null;
        private ProcessScheduler processScheduler = null;
        private KerberosConfig kerberosConfig = null;
        private FlowFileEventRepository flowFileEventRepository = null;
        private ProvenanceRepository provenanceRepository = null;
        private ExtensionRepository extensionRepository = null;
        private CounterRepository counterRepository = null;
        private String statusTaskInterval = null;

        public Builder extensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        public Builder bulletinRepository(BulletinRepository bulletinRepository) {
            this.bulletinRepository = bulletinRepository;
            return this;
        }

        public Builder stateManagerProvider(StatelessStateManagerProvider stateManagerProvider) {
            this.stateManagerProvider = stateManagerProvider;
            return this;
        }

        public Builder encryptor(PropertyEncryptor propertyEncryptor) {
            this.propertyEncryptor = propertyEncryptor;
            return this;
        }

        public Builder variableRegistry(VariableRegistry variableRegistry) {
            this.variableRegistry = variableRegistry;
            return this;
        }

        public Builder processScheduler(ProcessScheduler processScheduler) {
            this.processScheduler = processScheduler;
            return this;
        }

        public Builder kerberosConfiguration(KerberosConfig kerberosConfig) {
            this.kerberosConfig = kerberosConfig;
            return this;
        }

        public Builder flowFileEventRepository(FlowFileEventRepository flowFileEventRepository) {
            this.flowFileEventRepository = flowFileEventRepository;
            return this;
        }

        public Builder provenanceRepository(ProvenanceRepository provenanceRepository) {
            this.provenanceRepository = provenanceRepository;
            return this;
        }

        public Builder extensionRepository(ExtensionRepository extensionRepository) {
            this.extensionRepository = extensionRepository;
            return this;
        }

        public Builder counterRepository(CounterRepository counterRepository) {
            this.counterRepository = counterRepository;
            return this;
        }

        public Builder statusTaskInterval(String statusTaskInterval) {
            this.statusTaskInterval = statusTaskInterval;
            return this;
        }

        public StandardStatelessEngine build() {
            return new StandardStatelessEngine(this);
        }
    }
}

