/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.groups.ProcessGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousCommitTracker {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousCommitTracker.class);
    private final Set<Connectable> ready = new LinkedHashSet<Connectable>();
    private final Stack<CommitCallbacks> commitCallbacks = new Stack();
    private int flowFilesProduced = 0;
    private long bytesProduced = 0L;
    private boolean progressMade = false;

    public void addConnectable(Connectable connectable) {
        boolean removed = this.ready.remove(connectable);
        this.ready.add(connectable);
        if (removed) {
            logger.debug("{} Added {} to list of Ready Connectables but it was already in the list", (Object)this, (Object)connectable);
        } else {
            logger.debug("{} Added {} to list of Ready Connectables", (Object)this, (Object)connectable);
        }
    }

    public Connectable getNextReady() {
        if (this.ready.isEmpty()) {
            return null;
        }
        Connectable last = null;
        Iterator<Connectable> iterator = this.ready.iterator();
        while (iterator.hasNext()) {
            Connectable connectable;
            last = connectable = iterator.next();
        }
        return last;
    }

    public List<Connectable> getReady() {
        ArrayList<Connectable> reversed = new ArrayList<Connectable>(this.ready);
        Collections.reverse(reversed);
        return reversed;
    }

    public boolean isAnyReady() {
        boolean anyReady = !this.ready.isEmpty();
        logger.debug("{} Any components ready = {}, list={}", new Object[]{this, anyReady, this.ready});
        return anyReady;
    }

    public boolean isReady(Connectable connectable) {
        if (!this.ready.contains(connectable)) {
            logger.debug("{} {} is not ready because it's not in the list of ready components", (Object)this, (Object)connectable);
            return false;
        }
        if (this.isRootGroupOutputPort(connectable)) {
            this.ready.remove(connectable);
            logger.debug("{} {} is not ready because it's a root group output port", (Object)this, (Object)connectable);
            return false;
        }
        if (this.isDataQueued(connectable)) {
            logger.debug("{} {} is ready because it has data queued", (Object)this, (Object)connectable);
            return true;
        }
        if (connectable.isTriggerWhenEmpty() && this.isDataHeld(connectable)) {
            logger.debug("{} {} is ready because it is triggered when its input queue is empty and has unacknowledged data", (Object)this, (Object)connectable);
            return true;
        }
        logger.debug("{} {} is not ready because it has no data queued or held (or has no data queued and is not to be triggered when input queue is empty)", (Object)this, (Object)connectable);
        this.ready.remove(connectable);
        return false;
    }

    private boolean isRootGroupOutputPort(Connectable connectable) {
        ConnectableType connectableType = connectable.getConnectableType();
        if (connectableType == ConnectableType.OUTPUT_PORT) {
            ProcessGroup outputPortGroup = connectable.getProcessGroup();
            return outputPortGroup.getParent() == null;
        }
        return false;
    }

    private boolean isDataQueued(Connectable connectable) {
        for (Connection incoming : connectable.getIncomingConnections()) {
            if (incoming.getFlowFileQueue().isActiveQueueEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isDataHeld(Connectable connectable) {
        for (Connection incoming : connectable.getIncomingConnections()) {
            if (!incoming.getFlowFileQueue().isUnacknowledgedFlowFile()) continue;
            return true;
        }
        return false;
    }

    public void addCallback(Connectable connectable, Runnable successCallback, Consumer<Throwable> failureCallback) {
        if (successCallback == null && failureCallback == null) {
            return;
        }
        this.commitCallbacks.add(new CommitCallbacks(connectable, successCallback, failureCallback));
    }

    public void triggerCallbacks() {
        Throwable failure = null;
        while (!this.commitCallbacks.isEmpty()) {
            CommitCallbacks callbacks = this.commitCallbacks.pop();
            if (failure != null) {
                this.handleCallbackFailure(callbacks, failure);
                continue;
            }
            try {
                this.triggerSuccessCallback(callbacks);
            }
            catch (Throwable t) {
                logger.error("Failed to trigger onSuccess Aysnchronous Commit Callback on {}", (Object)callbacks.getConnectable(), (Object)t);
                failure = t;
            }
        }
    }

    public void triggerFailureCallbacks(Throwable failure) {
        while (!this.commitCallbacks.isEmpty()) {
            CommitCallbacks callbacks = this.commitCallbacks.pop();
            this.handleCallbackFailure(callbacks, failure);
        }
    }

    private void triggerSuccessCallback(CommitCallbacks callbacks) {
        Runnable callback = callbacks.getSuccessCallback();
        if (callback == null) {
            return;
        }
        callback.run();
    }

    private void handleCallbackFailure(CommitCallbacks commitCallbacks, Throwable failure) {
        Consumer<Throwable> failureCallback = commitCallbacks.getFailureCallback();
        if (failureCallback == null) {
            return;
        }
        logger.debug("When triggering Asynchronous Commit callbacks, there was previously a failure so will call failure handler for {}", (Object)commitCallbacks.getConnectable());
        try {
            failureCallback.accept(failure);
        }
        catch (Throwable t) {
            logger.error("Tried to invoke failure callback for asynchronous commits on {} but failed to do so", (Object)commitCallbacks.getConnectable(), (Object)t);
        }
    }

    public void recordProgress(int flowFilesProduced, long bytesProduced) {
        this.flowFilesProduced += flowFilesProduced;
        this.bytesProduced += bytesProduced;
        this.progressMade = true;
    }

    public void resetProgress() {
        this.flowFilesProduced = 0;
        this.bytesProduced = 0L;
        this.progressMade = false;
    }

    public boolean isProgress() {
        return this.progressMade;
    }

    public int getFlowFilesProduced() {
        return this.flowFilesProduced;
    }

    public long getBytesProduced() {
        return this.bytesProduced;
    }

    private static class CommitCallbacks {
        private final Connectable connectable;
        private final Runnable successCallback;
        private final Consumer<Throwable> failureCallback;

        public CommitCallbacks(Connectable connectable, Runnable successCallback, Consumer<Throwable> failureCallback) {
            this.connectable = connectable;
            this.successCallback = successCallback;
            this.failureCallback = failureCallback;
        }

        public Connectable getConnectable() {
            return this.connectable;
        }

        public Runnable getSuccessCallback() {
            return this.successCallback;
        }

        public Consumer<Throwable> getFailureCallback() {
            return this.failureCallback;
        }
    }
}

