/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StatelessStateManagerProvider;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.ContentRepositoryContext;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.StandardCounterRepository;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardResourceClaimManager;
import org.apache.nifi.controller.repository.metrics.RingBufferEventRepository;
import org.apache.nifi.controller.scheduling.StatelessProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardControllerServiceProvider;
import org.apache.nifi.encrypt.PropertyEncryptionMethod;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorBuilder;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.extensions.ExtensionClient;
import org.apache.nifi.extensions.FileSystemExtensionRepository;
import org.apache.nifi.extensions.NexusExtensionClient;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.StandardParameterContextManager;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.InMemoryFlowRegistry;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.stateless.bootstrap.ExtensionDiscovery;
import org.apache.nifi.stateless.config.ExtensionClientDefinition;
import org.apache.nifi.stateless.config.SslConfigurationUtil;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.stateless.engine.CachingProcessContextFactory;
import org.apache.nifi.stateless.engine.StandardStatelessEngine;
import org.apache.nifi.stateless.engine.StatelessAuthorizer;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.engine.StatelessEngineInitializationContext;
import org.apache.nifi.stateless.engine.StatelessFlowManager;
import org.apache.nifi.stateless.engine.StatelessProcessContextFactory;
import org.apache.nifi.stateless.engine.StatelessProvenanceAuthorizableFactory;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.StatelessDataflowFactory;
import org.apache.nifi.stateless.repository.ByteArrayContentRepository;
import org.apache.nifi.stateless.repository.StatelessFileSystemContentRepository;
import org.apache.nifi.stateless.repository.StatelessFlowFileRepository;
import org.apache.nifi.stateless.repository.StatelessProvenanceRepository;
import org.apache.nifi.stateless.repository.StatelessRepositoryContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStatelessDataflowFactory
implements StatelessDataflowFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardStatelessDataflowFactory.class);

    public StatelessDataflow createDataflow(final StatelessEngineConfiguration engineConfiguration, DataflowDefinition dataflowDefinition, ClassLoader extensionRootClassLoader) throws IOException, StatelessConfigurationException {
        long start = System.currentTimeMillis();
        StatelessProvenanceRepository provenanceRepo = null;
        ContentRepository contentRepo = null;
        StatelessProcessScheduler processScheduler = null;
        StatelessFlowFileRepository flowFileRepo = null;
        RingBufferEventRepository flowFileEventRepo = null;
        try {
            SSLContext sslContext;
            VolatileBulletinRepository bulletinRepository = new VolatileBulletinRepository();
            File workingDir = engineConfiguration.getWorkingDirectory();
            File narExpansionDirectory = new File(workingDir, "nar");
            if (!narExpansionDirectory.exists() && !narExpansionDirectory.mkdirs()) {
                throw new IOException("Working Directory " + narExpansionDirectory + " does not exist and could not be created");
            }
            NarClassLoaders narClassLoaders = new NarClassLoaders();
            File extensionsWorkingDir = new File(narExpansionDirectory, "extensions");
            ClassLoader systemClassLoader = this.createSystemClassLoader(engineConfiguration.getNarDirectory(), extensionRootClassLoader);
            ExtensionDiscoveringManager extensionManager = ExtensionDiscovery.discover(extensionsWorkingDir, systemClassLoader, narClassLoaders, engineConfiguration.isLogExtensionDiscovery());
            flowFileEventRepo = new RingBufferEventRepository(5);
            StatelessStateManagerProvider stateManagerProvider = new StatelessStateManagerProvider();
            StandardParameterContextManager parameterContextManager = new StandardParameterContextManager();
            processScheduler = new StatelessProcessScheduler((ExtensionManager)extensionManager);
            provenanceRepo = new StatelessProvenanceRepository(1000);
            provenanceRepo.initialize(EventReporter.NO_OP, new StatelessAuthorizer(), new StatelessProvenanceAuthorizableFactory(), IdentifierLookup.EMPTY);
            try {
                sslContext = SslConfigurationUtil.createSslContext(engineConfiguration.getSslContext());
            }
            catch (StatelessConfigurationException e) {
                throw new StatelessConfigurationException("Could not create SSLContext", (Throwable)e);
            }
            ArrayList<ExtensionClient> extensionClients = new ArrayList<ExtensionClient>();
            for (ExtensionClientDefinition extensionClientDefinition : engineConfiguration.getExtensionClients()) {
                ExtensionClient extensionClient = this.createExtensionClient(extensionClientDefinition, engineConfiguration.getSslContext());
                extensionClients.add(extensionClient);
            }
            FileSystemExtensionRepository extensionRepository = new FileSystemExtensionRepository(extensionManager, engineConfiguration, narClassLoaders, extensionClients);
            extensionRepository.initialize();
            VariableRegistry variableRegistry = VariableRegistry.EMPTY_REGISTRY;
            PropertyEncryptor lazyInitializedEncryptor = new PropertyEncryptor(){
                private PropertyEncryptor created = null;

                public String encrypt(String property) {
                    return this.getEncryptor().encrypt(property);
                }

                public String decrypt(String encryptedProperty) {
                    return this.getEncryptor().decrypt(encryptedProperty);
                }

                private synchronized PropertyEncryptor getEncryptor() {
                    if (this.created != null) {
                        return this.created;
                    }
                    this.created = new PropertyEncryptorBuilder(engineConfiguration.getSensitivePropsKey()).setAlgorithm(PropertyEncryptionMethod.NIFI_PBKDF2_AES_GCM_256.toString()).build();
                    return this.created;
                }
            };
            StandardCounterRepository counterRepo = new StandardCounterRepository();
            File krb5File = engineConfiguration.getKrb5File();
            KerberosConfig kerberosConfig = new KerberosConfig(null, null, krb5File);
            if (krb5File != null) {
                logger.info("Setting java.security.krb5.conf to {}", (Object)krb5File.getAbsolutePath());
                System.setProperty("java.security.krb5.conf", krb5File.getAbsolutePath());
            }
            StandardStatelessEngine statelessEngine = new StandardStatelessEngine.Builder().bulletinRepository((BulletinRepository)bulletinRepository).encryptor(lazyInitializedEncryptor).extensionManager((ExtensionManager)extensionManager).stateManagerProvider(stateManagerProvider).variableRegistry(variableRegistry).processScheduler(processScheduler).kerberosConfiguration(kerberosConfig).flowFileEventRepository((FlowFileEventRepository)flowFileEventRepo).provenanceRepository(provenanceRepo).extensionRepository(extensionRepository).counterRepository((CounterRepository)counterRepo).statusTaskInterval(engineConfiguration.getStatusTaskInterval()).build();
            StatelessFlowManager flowManager = new StatelessFlowManager((FlowFileEventRepository)flowFileEventRepo, (ParameterContextManager)parameterContextManager, statelessEngine, () -> true, sslContext, (BulletinRepository)bulletinRepository);
            flowManager.createFlowRegistryClient(InMemoryFlowRegistry.class.getTypeName(), "in-memory-flow-registry", null, Collections.emptySet(), true, true, null);
            ((InMemoryFlowRegistry)flowManager.getFlowRegistryClient("in-memory-flow-registry").getComponent()).addFlowSnapshot(dataflowDefinition.getVersionedExternalFlow());
            StandardControllerServiceProvider controllerServiceProvider = new StandardControllerServiceProvider((ProcessScheduler)processScheduler, (BulletinRepository)bulletinRepository, (FlowManager)flowManager, (ExtensionManager)extensionManager);
            StatelessProcessContextFactory rawProcessContextFactory = new StatelessProcessContextFactory((ControllerServiceProvider)controllerServiceProvider, lazyInitializedEncryptor, (StateManagerProvider)stateManagerProvider);
            CachingProcessContextFactory processContextFactory = new CachingProcessContextFactory(rawProcessContextFactory);
            contentRepo = this.createContentRepository(engineConfiguration);
            flowFileRepo = new StatelessFlowFileRepository();
            StatelessRepositoryContextFactory repositoryContextFactory = new StatelessRepositoryContextFactory(contentRepo, flowFileRepo, (FlowFileEventRepository)flowFileEventRepo, (CounterRepository)counterRepo, (ProvenanceEventRepository)provenanceRepo, (StateManagerProvider)stateManagerProvider);
            StatelessEngineInitializationContext statelessEngineInitializationContext = new StatelessEngineInitializationContext((ControllerServiceProvider)controllerServiceProvider, flowManager, processContextFactory, repositoryContextFactory);
            processScheduler.initialize(processContextFactory, dataflowDefinition);
            statelessEngine.initialize(statelessEngineInitializationContext);
            StandardResourceClaimManager resourceClaimManager = new StandardResourceClaimManager();
            EventReporter & Serializable eventReporter = (arg_0, arg_1, arg_2) -> StandardStatelessDataflowFactory.lambda$createDataflow$b60589ff$1((BulletinRepository)bulletinRepository, arg_0, arg_1, arg_2);
            contentRepo.initialize(new ContentRepositoryContext((ResourceClaimManager)resourceClaimManager, eventReporter){
                final /* synthetic */ ResourceClaimManager val$resourceClaimManager;
                final /* synthetic */ EventReporter val$eventReporter;
                {
                    this.val$resourceClaimManager = resourceClaimManager;
                    this.val$eventReporter = eventReporter;
                }

                public ResourceClaimManager getResourceClaimManager() {
                    return this.val$resourceClaimManager;
                }

                public EventReporter getEventReporter() {
                    return this.val$eventReporter;
                }
            });
            flowFileRepo.initialize((ResourceClaimManager)resourceClaimManager);
            flowManager.initialize((ControllerServiceProvider)controllerServiceProvider);
            ProcessGroup rootGroup = flowManager.createProcessGroup("root");
            rootGroup.setName("root");
            flowManager.setRootGroup(rootGroup);
            StatelessDataflow dataflow = statelessEngine.createFlow(dataflowDefinition);
            long millis = System.currentTimeMillis() - start;
            logger.info("NiFi Stateless Engine and Dataflow created and initialized in {} millis", (Object)millis);
            return dataflow;
        }
        catch (Exception e) {
            try {
                if (provenanceRepo != null) {
                    provenanceRepo.close();
                }
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            if (contentRepo != null) {
                contentRepo.shutdown();
            }
            if (processScheduler != null) {
                processScheduler.shutdown();
            }
            if (flowFileRepo != null) {
                try {
                    flowFileRepo.close();
                }
                catch (IOException ioe) {
                    e.addSuppressed(ioe);
                }
            }
            if (flowFileEventRepo != null) {
                try {
                    flowFileEventRepo.close();
                }
                catch (IOException ioe) {
                    e.addSuppressed(ioe);
                }
            }
            throw e;
        }
    }

    private ContentRepository createContentRepository(StatelessEngineConfiguration engineConfiguration) {
        Optional contentRepoStorageDirectory = engineConfiguration.getContentRepositoryDirectory();
        if (contentRepoStorageDirectory.isPresent()) {
            return new StatelessFileSystemContentRepository((File)contentRepoStorageDirectory.get());
        }
        return new ByteArrayContentRepository();
    }

    private ExtensionClient createExtensionClient(ExtensionClientDefinition definition, SslContextDefinition sslContextDefinition) {
        String type = definition.getExtensionClientType();
        if (!this.isValidExtensionClientType(type)) {
            throw new IllegalArgumentException("Invalid Extension Client type: <" + definition.getExtensionClientType() + ">. Currently, the only supported type is <nexus>");
        }
        SslContextDefinition sslContext = definition.isUseSslContext() && sslContextDefinition != null ? sslContextDefinition : null;
        return new NexusExtensionClient(definition.getBaseUrl(), sslContext, definition.getCommsTimeout());
    }

    private boolean isValidExtensionClientType(String type) {
        return "nexus".equalsIgnoreCase(type.trim());
    }

    private ClassLoader createSystemClassLoader(File narDirectory, ClassLoader extensionRootClassLoader) throws StatelessConfigurationException {
        int javaMajorVersion = this.getJavaMajorVersion();
        if (javaMajorVersion >= 11) {
            return this.createJava11OrLaterSystemClassLoader(javaMajorVersion, narDirectory, extensionRootClassLoader);
        }
        return extensionRootClassLoader;
    }

    private ClassLoader createJava11OrLaterSystemClassLoader(int javaMajorVersion, File narDirectory, ClassLoader parentClassLoader) throws StatelessConfigurationException {
        ArrayList<URL> java11JarFileUrls = new ArrayList<URL>();
        File java11Dir = new File(narDirectory, "java11");
        if (!java11Dir.exists()) {
            throw new StatelessConfigurationException("Could not create System-level ClassLoader because Java version is " + javaMajorVersion + " but could not find the requisite Java 11 libraries at " + java11Dir.getAbsolutePath());
        }
        File[] java11JarFiles = java11Dir.listFiles(filename -> filename.getName().toLowerCase().endsWith(".jar"));
        if (java11JarFiles == null || java11JarFiles.length == 0) {
            throw new StatelessConfigurationException("Could not create System-level ClassLoader because Java version is " + javaMajorVersion + " but could not find the requisite Java 11 libraries at " + java11Dir.getAbsolutePath());
        }
        try {
            for (File file : java11JarFiles) {
                java11JarFileUrls.add(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new StatelessConfigurationException("Could not create System-level ClassLoader", (Throwable)e);
        }
        URLClassLoader classLoader = new URLClassLoader(java11JarFileUrls.toArray(new URL[0]), parentClassLoader);
        return classLoader;
    }

    private int getJavaMajorVersion() {
        String javaVersion = System.getProperty("java.version");
        logger.debug("Java Version is {}", (Object)javaVersion);
        if (javaVersion.startsWith("1.")) {
            return Integer.parseInt(javaVersion.substring(2, 3));
        }
        int dotIndex = javaVersion.indexOf(".");
        if (dotIndex < 0) {
            return Integer.parseInt(javaVersion);
        }
        return Integer.parseInt(javaVersion.substring(0, dotIndex));
    }

    private static /* synthetic */ void lambda$createDataflow$b60589ff$1(BulletinRepository bulletinRepository, Severity severity, String category, String message) {
        Bulletin bulletin = BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
        bulletinRepository.addBulletin(bulletin);
    }
}

