/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.QueueDiagnostics;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.stateless.queue.DrainableFlowFileQueue;
import org.apache.nifi.util.FormatUtils;

public class StatelessFlowFileQueue
implements DrainableFlowFileQueue {
    private final String identifier;
    private volatile long expirationMillis;
    private final BlockingQueue<FlowFileRecord> flowFiles = new LinkedBlockingQueue<FlowFileRecord>();
    private final AtomicInteger unacknowledgedCount = new AtomicInteger(0);
    private final AtomicLong totalBytes = new AtomicLong(0L);

    public StatelessFlowFileQueue(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<FlowFilePrioritizer> getPriorities() {
        return Collections.emptyList();
    }

    public SwapSummary recoverSwappedFlowFiles() {
        return null;
    }

    public void purgeSwapFiles() {
    }

    public void setPriorities(List<FlowFilePrioritizer> newPriorities) {
    }

    public void setBackPressureObjectThreshold(long maxQueueSize) {
    }

    public long getBackPressureObjectThreshold() {
        return 0L;
    }

    public void setBackPressureDataSizeThreshold(String maxDataSize) {
    }

    public String getBackPressureDataSizeThreshold() {
        return "0 B";
    }

    public QueueSize size() {
        return new QueueSize(this.flowFiles.size() + this.unacknowledgedCount.get(), this.totalBytes.get());
    }

    public long getTotalQueuedDuration(long fromTimestamp) {
        long sum = 0L;
        for (FlowFileRecord flowFileRecord : this.flowFiles) {
            long l = fromTimestamp - flowFileRecord.getLastQueueDate();
            sum += l;
        }
        return sum;
    }

    public long getMinLastQueueDate() {
        long min = 0L;
        for (FlowFileRecord flowFile : this.flowFiles) {
            min = min == 0L ? flowFile.getLastQueueDate() : Long.min(min, flowFile.getLastQueueDate());
        }
        return min;
    }

    public boolean isEmpty() {
        return this.flowFiles.isEmpty() && this.unacknowledgedCount.get() == 0;
    }

    public FlowFileAvailability getFlowFileAvailability() {
        return this.isActiveQueueEmpty() ? FlowFileAvailability.ACTIVE_QUEUE_EMPTY : FlowFileAvailability.FLOWFILE_AVAILABLE;
    }

    public boolean isActiveQueueEmpty() {
        return this.flowFiles.isEmpty();
    }

    public void acknowledge(FlowFileRecord flowFile) {
        this.unacknowledgedCount.decrementAndGet();
        this.totalBytes.addAndGet(-flowFile.getSize());
    }

    public void acknowledge(Collection<FlowFileRecord> flowFiles) {
        this.unacknowledgedCount.addAndGet(-flowFiles.size());
        flowFiles.forEach(ff -> this.totalBytes.addAndGet(-ff.getSize()));
    }

    public boolean isUnacknowledgedFlowFile() {
        return this.unacknowledgedCount.get() > 0;
    }

    public boolean isFull() {
        return false;
    }

    public void put(FlowFileRecord flowFile) {
        this.flowFiles.add(flowFile);
        this.totalBytes.addAndGet(flowFile.getSize());
    }

    public void putAll(Collection<FlowFileRecord> flowFiles) {
        this.flowFiles.addAll(flowFiles);
        flowFiles.forEach(ff -> this.totalBytes.addAndGet(ff.getSize()));
    }

    public synchronized FlowFileRecord poll(Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        while (!this.flowFiles.isEmpty()) {
            FlowFileRecord flowFile = (FlowFileRecord)this.flowFiles.peek();
            if (flowFile == null) {
                return null;
            }
            if (this.isExpired(flowFile)) {
                expiredRecords.add(flowFile);
                if (expiredRecords.size() < 10000) continue;
                return null;
            }
            if (flowFile.isPenalized() && pollStrategy == PollStrategy.UNPENALIZED_FLOWFILES) {
                return null;
            }
            this.unacknowledgedCount.incrementAndGet();
            return (FlowFileRecord)this.flowFiles.poll();
        }
        return null;
    }

    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords) {
        return this.poll(expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    private boolean isExpired(FlowFileRecord flowFile) {
        if (this.expirationMillis == 0L) {
            return false;
        }
        long expirationTime = flowFile.getEntryDate() + this.expirationMillis;
        return System.currentTimeMillis() > expirationTime;
    }

    public synchronized List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        ArrayList<FlowFileRecord> selected = new ArrayList<FlowFileRecord>(Math.min(maxResults, this.flowFiles.size()));
        for (int i = 0; i < maxResults; ++i) {
            FlowFileRecord flowFile = this.poll(expiredRecords, pollStrategy);
            if (flowFile != null) {
                selected.add(flowFile);
            }
            if (flowFile == null || expiredRecords.size() >= 10000) break;
        }
        return selected;
    }

    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords) {
        return this.poll(maxResults, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    public synchronized List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        ArrayList<FlowFileRecord> selected = new ArrayList<FlowFileRecord>();
        Iterator itr = this.flowFiles.iterator();
        while (itr.hasNext()) {
            FlowFileRecord flowFile = (FlowFileRecord)itr.next();
            if (this.isExpired(flowFile)) {
                expiredRecords.add(flowFile);
                if (expiredRecords.size() < 10000) continue;
                break;
            }
            if (flowFile.isPenalized() && pollStrategy == PollStrategy.UNPENALIZED_FLOWFILES) break;
            FlowFileFilter.FlowFileFilterResult filterResult = filter.filter((FlowFile)flowFile);
            if (filterResult.isAccept()) {
                selected.add(flowFile);
                itr.remove();
            }
            if (filterResult.isContinue()) continue;
            break;
        }
        this.unacknowledgedCount.addAndGet(selected.size());
        return selected;
    }

    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        return this.poll(filter, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    public String getFlowFileExpiration() {
        return this.expirationMillis + " millis";
    }

    public long getFlowFileExpiration(TimeUnit timeUnit) {
        return timeUnit.convert(this.expirationMillis, TimeUnit.MILLISECONDS);
    }

    public void setFlowFileExpiration(String flowExpirationPeriod) {
        this.expirationMillis = Math.round(FormatUtils.getPreciseTimeDuration((String)flowExpirationPeriod, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public DropFlowFileStatus dropFlowFiles(String requestIdentifier, String requestor) {
        throw new UnsupportedOperationException("Cannot drop FlowFiles from a queue in Stateless NiFi");
    }

    public DropFlowFileStatus getDropFlowFileStatus(String requestIdentifier) {
        throw new UnsupportedOperationException("Cannot drop FlowFiles from a queue in Stateless NiFi");
    }

    public DropFlowFileStatus cancelDropFlowFileRequest(String requestIdentifier) {
        throw new UnsupportedOperationException("Cannot drop FlowFiles from a queue in Stateless NiFi");
    }

    public ListFlowFileStatus listFlowFiles(String requestIdentifier, int maxResults) {
        throw new UnsupportedOperationException("Cannot list FlowFiles in a queue in Stateless NiFi");
    }

    public ListFlowFileStatus getListFlowFileStatus(String requestIdentifier) {
        throw new UnsupportedOperationException("Cannot list FlowFiles in a queue in Stateless NiFi");
    }

    public ListFlowFileStatus cancelListFlowFileRequest(String requestIdentifier) {
        throw new UnsupportedOperationException("Cannot list FlowFiles in a queue in Stateless NiFi");
    }

    public FlowFileRecord getFlowFile(String flowFileUuid) {
        throw new UnsupportedOperationException("Cannot fetch particular FlowFile from a queue in Stateless NiFi");
    }

    public void verifyCanList() throws IllegalStateException {
        throw new IllegalStateException("Cannot list FlowFiles in a queue in Stateless NiFi");
    }

    public QueueDiagnostics getQueueDiagnostics() {
        return null;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy, String partitioningAttribute) {
    }

    public void offloadQueue() {
        throw new UnsupportedOperationException("Node Offloading is not supported in Stateless NiFi");
    }

    public void resetOffloadedQueue() {
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        return LoadBalanceStrategy.DO_NOT_LOAD_BALANCE;
    }

    public void setLoadBalanceCompression(LoadBalanceCompression compression) {
    }

    public LoadBalanceCompression getLoadBalanceCompression() {
        return LoadBalanceCompression.DO_NOT_COMPRESS;
    }

    public String getPartitioningAttribute() {
        return null;
    }

    public void startLoadBalancing() {
    }

    public void stopLoadBalancing() {
    }

    public boolean isActivelyLoadBalancing() {
        return false;
    }

    @Override
    public void drainTo(List<FlowFileRecord> destination) {
        this.flowFiles.drainTo(destination);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

