/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extensions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.extensions.BundleAvailability;
import org.apache.nifi.extensions.DownloadQueue;
import org.apache.nifi.extensions.ExtensionClient;
import org.apache.nifi.extensions.ExtensionRepository;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.NarLoadResult;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.apache.nifi.stateless.engine.NarUnpackLock;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemExtensionRepository
implements ExtensionRepository {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemExtensionRepository.class);
    private final ExtensionDiscoveringManager extensionManager;
    private final NarClassLoaders narClassLoaders;
    private final File narDirectory;
    private final File writableExtensionDirectory;
    private final Set<File> readOnlyExtensionDirectories;
    private final File workingDirectory;
    private final List<ExtensionClient> clients;

    public FileSystemExtensionRepository(ExtensionDiscoveringManager extensionManager, StatelessEngineConfiguration engineConfiguration, NarClassLoaders narClassLoaders, List<ExtensionClient> clients) {
        this.extensionManager = extensionManager;
        this.narDirectory = engineConfiguration.getNarDirectory();
        this.writableExtensionDirectory = engineConfiguration.getExtensionsDirectory();
        this.readOnlyExtensionDirectories = engineConfiguration.getReadOnlyExtensionsDirectories() == null ? Collections.emptySet() : new HashSet(engineConfiguration.getReadOnlyExtensionsDirectories());
        this.workingDirectory = engineConfiguration.getWorkingDirectory();
        this.narClassLoaders = narClassLoaders;
        this.clients = clients;
    }

    @Override
    public void initialize() throws IOException {
        HashSet<File> narFiles = new HashSet<File>();
        if (this.writableExtensionDirectory != null && !this.writableExtensionDirectory.equals(this.narDirectory)) {
            narFiles.addAll(this.listNarFiles(this.writableExtensionDirectory));
        }
        for (File extensionDir : this.readOnlyExtensionDirectories) {
            narFiles.addAll(this.listNarFiles(extensionDir));
        }
        this.loadExtensions(narFiles);
    }

    private Collection<File> listNarFiles(File extensionDir) {
        File[] narFiles = extensionDir.listFiles(file -> file.getName().endsWith(".nar"));
        if (narFiles == null) {
            logger.warn("Failed to perform listing of extensions directory {}. Will not preload extensions from this directory.", (Object)extensionDir.getAbsolutePath());
            return Collections.emptyList();
        }
        return Arrays.asList(narFiles);
    }

    @Override
    public BundleAvailability getBundleAvailability(BundleCoordinate bundleCoordinate) {
        Bundle bundle = this.extensionManager.getBundle(bundleCoordinate);
        if (bundle == null) {
            return BundleAvailability.BUNDLE_NOT_AVAILABLE;
        }
        BundleDetails details = bundle.getBundleDetails();
        BundleCoordinate parentCoordinates = details.getDependencyCoordinate();
        BundleAvailability parentAvailability = this.getBundleAvailability(parentCoordinates);
        switch (parentAvailability) {
            case BUNDLE_AVAILABLE: {
                return BundleAvailability.BUNDLE_AVAILABLE;
            }
            case BUNDLE_NOT_AVAILABLE: 
            case PARENT_NOT_AVAILABLE: {
                return BundleAvailability.PARENT_NOT_AVAILABLE;
            }
        }
        return BundleAvailability.BUNDLE_NOT_AVAILABLE;
    }

    @Override
    public Future<Set<Bundle>> fetch(Set<BundleCoordinate> bundleCoordinates, ExecutorService executorService, int concurrentDownloads) {
        if (this.clients.isEmpty()) {
            logger.info("Requested {} bundles for download but not configured with any Extension Clients so will not download any", (Object)bundleCoordinates.size());
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        DownloadQueue downloadQueue = new DownloadQueue((ExtensionManager)this.extensionManager, executorService, concurrentDownloads, bundleCoordinates, this.writableExtensionDirectory, this.clients);
        CompletableFuture<Void> downloadFuture = downloadQueue.download();
        logger.info("Beginning download of extensions {}", bundleCoordinates);
        CompletionStage loadFuture = downloadFuture.thenApply(voidDownloadResult -> this.loadExtensions(downloadQueue));
        return loadFuture;
    }

    private Set<Bundle> loadExtensions(DownloadQueue downloadQueue) {
        Set<File> downloadedFiles = downloadQueue.getDownloadedFiles();
        logger.info("Completed download of {} bundles. Unpacking NAR files now", (Object)downloadedFiles.size());
        try {
            return this.loadExtensions(downloadedFiles);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load extensions", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Bundle> loadExtensions(Set<File> downloadedFiles) throws IOException {
        ArrayList<File> unpackedDirs = new ArrayList<File>();
        long start = System.currentTimeMillis();
        for (File downloadedFile : downloadedFiles) {
            NarUnpackLock.lock();
            try {
                logger.info("Unpacking {}", (Object)downloadedFile);
                File extensionsWorkingDirectory = new File(this.workingDirectory, "extensions");
                File unpackedDir = NarUnpacker.unpackNar((File)downloadedFile, (File)extensionsWorkingDirectory, (boolean)false, (NarUnpackMode)NarUnpackMode.UNPACK_TO_UBER_JAR);
                unpackedDirs.add(unpackedDir);
            }
            finally {
                NarUnpackLock.unlock();
            }
        }
        long unpackMillis = System.currentTimeMillis() - start;
        logger.info("Unpacked {} bundles in {} millis. Loading Extensions now", (Object)downloadedFiles.size(), (Object)unpackMillis);
        NarLoadResult narLoadResult = this.narClassLoaders.loadAdditionalNars(unpackedDirs);
        Set bundleDetails = narLoadResult.getSkippedBundles();
        if (!bundleDetails.isEmpty()) {
            throw new IOException(String.format("After loading downloaded bundles, %s bundles were skipped: %s", bundleDetails.size(), bundleDetails));
        }
        Set loadedBundles = narLoadResult.getLoadedBundles();
        this.extensionManager.discoverExtensions(loadedBundles);
        return loadedBundles;
    }
}

