/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.StandardFlowFileEvent;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.TerminatedTaskException;
import org.apache.nifi.stateless.engine.ExecutionProgress;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.flow.StatelessFlowCurrent;
import org.apache.nifi.stateless.flow.TransactionThresholdMeter;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.stateless.session.AsynchronousCommitTracker;
import org.apache.nifi.stateless.session.StatelessProcessSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStatelessFlowCurrent
implements StatelessFlowCurrent {
    private static final Logger logger = LoggerFactory.getLogger(StandardStatelessFlowCurrent.class);
    private final TransactionThresholdMeter transactionThresholdMeter;
    private final AsynchronousCommitTracker tracker;
    private final ExecutionProgress executionProgress;
    private final Set<Connectable> rootConnectables;
    private final RepositoryContextFactory repositoryContextFactory;
    private final ProcessContextFactory processContextFactory;
    private Connectable currentComponent = null;

    private StandardStatelessFlowCurrent(Builder builder) {
        this.transactionThresholdMeter = builder.transactionThresholdMeter;
        this.tracker = builder.tracker;
        this.executionProgress = builder.executionProgress;
        this.rootConnectables = builder.rootConnectables;
        this.repositoryContextFactory = builder.repositoryContextFactory;
        this.processContextFactory = builder.processContextFactory;
    }

    @Override
    public void triggerFlow() {
        try {
            boolean completionReached = false;
            while (!completionReached) {
                this.triggerRootConnectables();
                while (this.tracker.isAnyReady()) {
                    Connectable connectable = this.tracker.getNextReady();
                    logger.debug("The next ready component to be triggered: {}", (Object)connectable);
                    NextConnectable nextConnectable = this.triggerWhileReady(connectable);
                    if (nextConnectable == NextConnectable.NONE) {
                        return;
                    }
                    if (nextConnectable == NextConnectable.NEXT_READY) continue;
                }
                completionReached = !this.tracker.isAnyReady() && this.isFlowQueueEmpty();
            }
        }
        catch (Throwable t) {
            if (t instanceof TerminatedTaskException) {
                logger.debug("Encountered TerminatedTaskException when triggering {}", (Object)this.currentComponent, (Object)t);
            } else {
                logger.error("Failed to trigger {}", (Object)this.currentComponent, (Object)t);
            }
            this.executionProgress.notifyExecutionFailed(t);
            this.tracker.triggerFailureCallbacks(t);
            throw t;
        }
    }

    private boolean isFlowQueueEmpty() {
        if (this.executionProgress.isDataQueued()) {
            return false;
        }
        for (Connectable rootConnectable : this.rootConnectables) {
            for (Connection connection : rootConnectable.getIncomingConnections()) {
                if (!connection.getFlowFileQueue().isUnacknowledgedFlowFile()) continue;
                return false;
            }
        }
        return true;
    }

    private void triggerRootConnectables() {
        Iterator<Connectable> iterator = this.rootConnectables.iterator();
        while (iterator.hasNext()) {
            Connectable connectable;
            this.currentComponent = connectable = iterator.next();
            this.tracker.resetProgress();
            this.trigger(connectable, this.executionProgress, this.tracker);
            this.transactionThresholdMeter.incrementFlowFiles(this.tracker.getFlowFilesProduced());
            this.transactionThresholdMeter.incrementBytes(this.tracker.getBytesProduced());
        }
    }

    private NextConnectable triggerWhileReady(Connectable connectable) {
        while (this.tracker.isReady(connectable)) {
            if (this.executionProgress.isCanceled()) {
                logger.info("Dataflow was canceled so will not trigger any more components");
                return NextConnectable.NONE;
            }
            this.currentComponent = connectable;
            this.tracker.resetProgress();
            this.trigger(connectable, this.executionProgress, this.tracker);
            boolean progressed = this.tracker.isProgress();
            if (progressed) {
                logger.debug("{} was triggered and made progress", (Object)connectable);
                continue;
            }
            if (connectable.getConnectableType() == ConnectableType.OUTPUT_PORT && connectable.getProcessGroup().getFlowFileOutboundPolicy() == FlowFileOutboundPolicy.BATCH_OUTPUT && connectable.getProcessGroup().isDataQueuedForProcessing()) {
                logger.debug("{} was triggered but unable to make process. Data is still available for processing, so continue triggering components within the Process Group", (Object)connectable);
                return NextConnectable.NEXT_READY;
            }
            boolean thresholdMet = this.transactionThresholdMeter.isThresholdMet();
            if (thresholdMet) {
                logger.debug("{} was triggered but unable to make progress. The transaction thresholds {} have been met (currently at {}). Will not trigger source components to run.", new Object[]{connectable, this.transactionThresholdMeter.getThresholds(), this.transactionThresholdMeter});
                continue;
            }
            logger.debug("{} was triggered but unable to make progress. Maximum transaction thresholds {} have not been reached (currently at {}) so will trigger source components to run.", new Object[]{connectable, this.transactionThresholdMeter.getThresholds(), this.transactionThresholdMeter});
            return NextConnectable.SOURCE_CONNECTABLE;
        }
        return NextConnectable.NEXT_READY;
    }

    private void trigger(Connectable connectable, ExecutionProgress executionProgress, AsynchronousCommitTracker tracker) {
        ProcessContext processContext = this.processContextFactory.createProcessContext(connectable);
        StatelessProcessSessionFactory sessionFactory = new StatelessProcessSessionFactory(connectable, this.repositoryContextFactory, this.processContextFactory, executionProgress, false, tracker);
        long start = System.nanoTime();
        logger.debug("Triggering {}", (Object)connectable);
        connectable.onTrigger(processContext, (ProcessSessionFactory)sessionFactory);
        long processingNanos = System.nanoTime() - start;
        this.registerProcessEvent(connectable, 1, processingNanos);
    }

    private void registerProcessEvent(Connectable connectable, int invocations, long processingNanos) {
        try {
            StandardFlowFileEvent procEvent = new StandardFlowFileEvent();
            procEvent.setProcessingNanos(processingNanos);
            procEvent.setInvocations(invocations);
            this.repositoryContextFactory.getFlowFileEventRepository().updateRepository((FlowFileEvent)procEvent, connectable.getIdentifier());
        }
        catch (IOException e) {
            logger.error("Unable to update FlowFileEvent Repository for {}; statistics may be inaccurate. Reason for failure: {}", new Object[]{connectable.getRunnableComponent(), e.toString(), e});
        }
    }

    public static class Builder {
        private TransactionThresholdMeter transactionThresholdMeter;
        private AsynchronousCommitTracker tracker;
        private ExecutionProgress executionProgress;
        private Set<Connectable> rootConnectables;
        private RepositoryContextFactory repositoryContextFactory;
        private ProcessContextFactory processContextFactory;

        public StandardStatelessFlowCurrent build() {
            Objects.requireNonNull(this.transactionThresholdMeter, "Transaction Threshold Meter must be set");
            Objects.requireNonNull(this.tracker, "Commit Tracker must be set");
            Objects.requireNonNull(this.executionProgress, "Execution Progress must be set");
            Objects.requireNonNull(this.rootConnectables, "Root Conectables must be set");
            Objects.requireNonNull(this.repositoryContextFactory, "Repository Context Factory must be set");
            Objects.requireNonNull(this.processContextFactory, "Process Context Factory must be set");
            return new StandardStatelessFlowCurrent(this);
        }

        public Builder transactionThresholdMeter(TransactionThresholdMeter transactionThresholdMeter) {
            this.transactionThresholdMeter = transactionThresholdMeter;
            return this;
        }

        public Builder commitTracker(AsynchronousCommitTracker commitTracker) {
            this.tracker = commitTracker;
            return this;
        }

        public Builder executionProgress(ExecutionProgress executionProgress) {
            this.executionProgress = executionProgress;
            return this;
        }

        public Builder rootConnectables(Set<Connectable> rootConnectables) {
            this.rootConnectables = rootConnectables;
            return this;
        }

        public Builder repositoryContextFactory(RepositoryContextFactory repositoryContextFactory) {
            this.repositoryContextFactory = repositoryContextFactory;
            return this;
        }

        public Builder processContextFactory(ProcessContextFactory processContextFactory) {
            this.processContextFactory = processContextFactory;
            return this;
        }
    }

    private static enum NextConnectable {
        NEXT_READY,
        SOURCE_CONNECTABLE,
        NONE;

    }
}

