/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.filesystem;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class VirtualPath {
    private final Path path;

    public VirtualPath(String path) {
        String absolutePath = File.separator + this.normalizeSeparator(path);
        this.path = Paths.get(absolutePath, new String[0]).normalize();
    }

    private String normalizeSeparator(String path) {
        String pathWithoutStartingSeparator = this.removeStartingSeparator(path);
        String normalizedPath = pathWithoutStartingSeparator.replace(File.separatorChar, '/');
        normalizedPath = normalizedPath.replace('\\', '/');
        return normalizedPath;
    }

    private String removeStartingSeparator(String path) {
        int indexOfFirstNonSeparator;
        for (indexOfFirstNonSeparator = 0; indexOfFirstNonSeparator < path.length() && (path.charAt(indexOfFirstNonSeparator) == File.separatorChar || path.charAt(indexOfFirstNonSeparator) == '/'); ++indexOfFirstNonSeparator) {
        }
        return path.substring(indexOfFirstNonSeparator);
    }

    public String getFileName() {
        if (this.path.getFileName() == null) {
            return File.separator;
        }
        return this.path.getFileName().toString();
    }

    public VirtualPath getParent() {
        if (this.path.getParent() == null) {
            return null;
        }
        return new VirtualPath(this.path.getParent().toString());
    }

    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public VirtualPath resolve(String otherPath) {
        return new VirtualPath(this.path.resolve(otherPath).normalize().toString());
    }

    public String toString() {
        return this.path.toString();
    }

    public int getNameCount() {
        return this.path.getNameCount();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualPath)) {
            return false;
        }
        VirtualPath other = (VirtualPath)o;
        return this.path.equals(other.path);
    }
}

