/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.BatchUpdateException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.RollbackOnFailure;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"sql", "record", "jdbc", "put", "database", "update", "insert", "delete"})
@CapabilityDescription(value="The PutDatabaseRecord processor uses a specified RecordReader to input (possibly multiple) records from an incoming flow file. These records are translated to SQL statements and executed as a single transaction. If any errors occur, the flow file is routed to failure or retry, and if the records are transmitted successfully, the incoming flow file is routed to success.  The type of statement executed by the processor is specified via the Statement Type property, which accepts some hard-coded values such as INSERT, UPDATE, and DELETE, as well as 'Use statement.type Attribute', which causes the processor to get the statement type from a flow file attribute.  IMPORTANT: If the Statement Type is UPDATE, then the incoming records must not alter the value(s) of the primary keys (or user-specified Update Keys). If such records are encountered, the UPDATE statement issued to the database may do nothing (if no existing records with the new primary key values are found), or could inadvertently corrupt the existing data (by changing records for which the new values of the primary keys exist).")
@ReadsAttribute(attribute="statement.type", description="If 'Use statement.type Attribute' is selected for the Statement Type property, the value of this attribute will be used to determine the type of statement (INSERT, UPDATE, DELETE, SQL, etc.) to generate and execute.")
@WritesAttribute(attribute="putdatabaserecord.error", description="If an error occurs during processing, the flow file will be routed to failure or retry, and this attribute will be populated with the cause of the error.")
public class PutDatabaseRecord
extends AbstractProcessor {
    public static final String UPDATE_TYPE = "UPDATE";
    public static final String INSERT_TYPE = "INSERT";
    public static final String DELETE_TYPE = "DELETE";
    public static final String UPSERT_TYPE = "UPSERT";
    public static final String INSERT_IGNORE_TYPE = "INSERT_IGNORE";
    public static final String SQL_TYPE = "SQL";
    public static final String USE_ATTR_TYPE = "Use statement.type Attribute";
    public static final String USE_RECORD_PATH = "Use Record Path";
    static final String STATEMENT_TYPE_ATTRIBUTE = "statement.type";
    static final String PUT_DATABASE_RECORD_ERROR = "putdatabaserecord.error";
    static final AllowableValue IGNORE_UNMATCHED_FIELD = new AllowableValue("Ignore Unmatched Fields", "Ignore Unmatched Fields", "Any field in the document that cannot be mapped to a column in the database is ignored");
    static final AllowableValue FAIL_UNMATCHED_FIELD = new AllowableValue("Fail on Unmatched Fields", "Fail on Unmatched Fields", "If the document has any field that cannot be mapped to a column in the database, the FlowFile will be routed to the failure relationship");
    static final AllowableValue IGNORE_UNMATCHED_COLUMN = new AllowableValue("Ignore Unmatched Columns", "Ignore Unmatched Columns", "Any column in the database that does not have a field in the document will be assumed to not be required.  No notification will be logged");
    static final AllowableValue WARNING_UNMATCHED_COLUMN = new AllowableValue("Warn on Unmatched Columns", "Warn on Unmatched Columns", "Any column in the database that does not have a field in the document will be assumed to not be required.  A warning will be logged");
    static final AllowableValue FAIL_UNMATCHED_COLUMN = new AllowableValue("Fail on Unmatched Columns", "Fail on Unmatched Columns", "A flow will fail if any column in the database that does not have a field in the document.  An error will be logged");
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("A FlowFile is routed to this relationship if the database cannot be updated but attempting the operation again may succeed").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if the database cannot be updated and retrying the operation will also fail, such as an invalid query or an integrity constraint violation").build();
    protected static Set<Relationship> relationships;
    static final PropertyDescriptor RECORD_READER_FACTORY;
    static final PropertyDescriptor STATEMENT_TYPE;
    static final PropertyDescriptor STATEMENT_TYPE_RECORD_PATH;
    static final PropertyDescriptor DATA_RECORD_PATH;
    static final PropertyDescriptor DBCP_SERVICE;
    static final PropertyDescriptor CATALOG_NAME;
    static final PropertyDescriptor SCHEMA_NAME;
    static final PropertyDescriptor TABLE_NAME;
    static final AllowableValue BINARY_STRING_FORMAT_UTF8;
    static final AllowableValue BINARY_STRING_FORMAT_HEX_STRING;
    static final AllowableValue BINARY_STRING_FORMAT_BASE64;
    static final PropertyDescriptor BINARY_STRING_FORMAT;
    static final PropertyDescriptor TRANSLATE_FIELD_NAMES;
    static final PropertyDescriptor UNMATCHED_FIELD_BEHAVIOR;
    static final PropertyDescriptor UNMATCHED_COLUMN_BEHAVIOR;
    static final PropertyDescriptor UPDATE_KEYS;
    static final PropertyDescriptor FIELD_CONTAINING_SQL;
    static final PropertyDescriptor ALLOW_MULTIPLE_STATEMENTS;
    static final PropertyDescriptor QUOTE_IDENTIFIERS;
    static final PropertyDescriptor QUOTE_TABLE_IDENTIFIER;
    static final PropertyDescriptor QUERY_TIMEOUT;
    static final PropertyDescriptor TABLE_SCHEMA_CACHE_SIZE;
    static final PropertyDescriptor MAX_BATCH_SIZE;
    static final PropertyDescriptor AUTO_COMMIT;
    static final PropertyDescriptor DB_TYPE;
    protected static final Map<String, DatabaseAdapter> dbAdapters;
    protected static List<PropertyDescriptor> propDescriptors;
    private Cache<SchemaKey, TableSchema> schemaCache;
    private DatabaseAdapter databaseAdapter;
    private volatile Function<Record, String> recordPathOperationType;
    private volatile RecordPath dataRecordPath;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        DatabaseAdapter databaseAdapter = dbAdapters.get(validationContext.getProperty(DB_TYPE).getValue());
        String statementType = validationContext.getProperty(STATEMENT_TYPE).getValue();
        if (UPSERT_TYPE.equals(statementType) && !databaseAdapter.supportsUpsert() || INSERT_IGNORE_TYPE.equals(statementType) && !databaseAdapter.supportsInsertIgnore()) {
            validationResults.add(new ValidationResult.Builder().subject(STATEMENT_TYPE.getDisplayName()).valid(false).explanation(databaseAdapter.getName() + " does not support " + statementType).build());
        }
        Boolean autoCommit = validationContext.getProperty(AUTO_COMMIT).asBoolean();
        boolean rollbackOnFailure = validationContext.getProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE).asBoolean();
        if (autoCommit != null && autoCommit.booleanValue() && rollbackOnFailure) {
            validationResults.add(new ValidationResult.Builder().subject(RollbackOnFailure.ROLLBACK_ON_FAILURE.getDisplayName()).explanation(String.format("'%s' cannot be set to 'true' when '%s' is also set to 'true'. Transaction rollbacks for batch updates cannot rollback all the flow file's statements together when auto commit is set to 'true' because the database autocommits each batch separately.", RollbackOnFailure.ROLLBACK_ON_FAILURE.getDisplayName(), AUTO_COMMIT.getDisplayName())).build());
        }
        if (autoCommit != null && autoCommit.booleanValue() && !this.isMaxBatchSizeHardcodedToZero(validationContext)) {
            String explanation = String.format("'%s' must be hard-coded to zero when '%s' is set to 'true'. Batch size equal to zero executes all statements in a single transaction which allows rollback to revert all the flow file's statements together if an error occurs.", MAX_BATCH_SIZE.getDisplayName(), AUTO_COMMIT.getDisplayName());
            validationResults.add(new ValidationResult.Builder().subject(MAX_BATCH_SIZE.getDisplayName()).explanation(explanation).build());
        }
        return validationResults;
    }

    private boolean isMaxBatchSizeHardcodedToZero(ValidationContext validationContext) {
        try {
            return !validationContext.getProperty(MAX_BATCH_SIZE).isExpressionLanguagePresent() && 0 == validationContext.getProperty(MAX_BATCH_SIZE).asInteger();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.databaseAdapter = dbAdapters.get(context.getProperty(DB_TYPE).getValue());
        int tableSchemaCacheSize = context.getProperty(TABLE_SCHEMA_CACHE_SIZE).asInteger();
        this.schemaCache = Caffeine.newBuilder().maximumSize((long)tableSchemaCacheSize).build();
        String statementTypeRecordPathValue = context.getProperty(STATEMENT_TYPE_RECORD_PATH).getValue();
        if (statementTypeRecordPathValue == null) {
            this.recordPathOperationType = null;
        } else {
            RecordPath recordPath = RecordPath.compile((String)statementTypeRecordPathValue);
            this.recordPathOperationType = new RecordPathStatementType(recordPath);
        }
        String dataRecordPathValue = context.getProperty(DATA_RECORD_PATH).getValue();
        this.dataRecordPath = dataRecordPathValue == null ? null : RecordPath.compile((String)dataRecordPathValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = dbcpService.getConnection(flowFile.getAttributes());
            originalAutoCommit = connection.getAutoCommit();
            Boolean propertyAutoCommitValue = context.getProperty(AUTO_COMMIT).asBoolean();
            if (propertyAutoCommitValue != null && originalAutoCommit != propertyAutoCommitValue) {
                try {
                    connection.setAutoCommit(propertyAutoCommitValue);
                }
                catch (Exception ex) {
                    this.getLogger().debug("Failed to setAutoCommit({}) due to {}", new Object[]{propertyAutoCommitValue, ex.getClass().getName(), ex});
                }
            }
            this.putToDatabase(context, session, flowFile, connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            session.transfer(flowFile, REL_SUCCESS);
            session.getProvenanceReporter().send(flowFile, this.getJdbcUrl(connection));
        }
        catch (Exception e) {
            this.routeOnException(context, session, connection, e, flowFile);
        }
        finally {
            this.closeConnection(connection, originalAutoCommit);
        }
    }

    private void routeOnException(ProcessContext context, ProcessSession session, Connection connection, Exception e, FlowFile flowFile) {
        Relationship relationship;
        Throwable toAnalyze;
        Throwable throwable = toAnalyze = e instanceof BatchUpdateException || e instanceof ProcessException ? e.getCause() : e;
        if (toAnalyze instanceof SQLTransientException) {
            relationship = REL_RETRY;
            flowFile = session.penalize(flowFile);
        } else {
            relationship = REL_FAILURE;
        }
        boolean rollbackOnFailure = context.getProperty(RollbackOnFailure.ROLLBACK_ON_FAILURE).asBoolean();
        if (rollbackOnFailure) {
            this.getLogger().error("Failed to put Records to database for {}. Rolling back NiFi session and returning the flow file to its incoming queue.", new Object[]{flowFile, e});
            session.rollback();
            context.yield();
        } else {
            this.getLogger().error("Failed to put Records to database for {}. Routing to {}.", new Object[]{flowFile, relationship, e});
            flowFile = session.putAttribute(flowFile, PUT_DATABASE_RECORD_ERROR, e.getMessage() == null ? "Unknown" : e.getMessage());
            session.transfer(flowFile, relationship);
        }
        this.rollbackConnection(connection);
    }

    private void rollbackConnection(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                    this.getLogger().debug("Manually rolled back JDBC transaction.");
                }
            }
            catch (Exception rollbackException) {
                this.getLogger().error("Failed to rollback JDBC transaction", (Throwable)rollbackException);
            }
        }
    }

    private void closeConnection(Connection connection, boolean originalAutoCommit) {
        if (connection != null) {
            try {
                if (originalAutoCommit != connection.getAutoCommit()) {
                    connection.setAutoCommit(originalAutoCommit);
                }
            }
            catch (Exception autoCommitException) {
                this.getLogger().warn(String.format("Failed to set auto-commit back to %s on connection", originalAutoCommit), (Throwable)autoCommitException);
            }
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (Exception closeException) {
                this.getLogger().warn("Failed to close database connection", (Throwable)closeException);
            }
        }
    }

    private void executeSQL(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection connection, RecordReader recordReader) throws IllegalArgumentException, MalformedRecordException, IOException, SQLException {
        RecordSchema recordSchema = recordReader.getSchema();
        String sqlField = context.getProperty(FIELD_CONTAINING_SQL).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)sqlField)) {
            throw new IllegalArgumentException(String.format("SQL specified as Statement Type but no Field Containing SQL was found, FlowFile %s", flowFile));
        }
        boolean schemaHasSqlField = recordSchema.getFields().stream().anyMatch(field -> sqlField.equals(field.getFieldName()));
        if (!schemaHasSqlField) {
            throw new IllegalArgumentException(String.format("Record schema does not contain Field Containing SQL: %s, FlowFile %s", sqlField, flowFile));
        }
        try (Statement statement = connection.createStatement();){
            block19: {
                int timeoutMillis = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
                try {
                    statement.setQueryTimeout(timeoutMillis);
                }
                catch (SQLException se) {
                    if (timeoutMillis <= 0) break block19;
                    throw se;
                }
            }
            ComponentLog log = this.getLogger();
            int maxBatchSize = context.getProperty(MAX_BATCH_SIZE).evaluateAttributeExpressions(flowFile).asInteger();
            boolean useBatch = maxBatchSize != 1 && this.isSupportsBatchUpdates(connection);
            int currentBatchSize = 0;
            int batchIndex = 0;
            boolean isFirstRecord = true;
            Record nextRecord = recordReader.nextRecord();
            while (nextRecord != null) {
                String[] sqlStatements;
                Record currentRecord = nextRecord;
                String sql = currentRecord.getAsString(sqlField);
                nextRecord = recordReader.nextRecord();
                if (sql == null || StringUtils.isEmpty((CharSequence)sql)) {
                    throw new MalformedRecordException(String.format("Record had no (or null) value for Field Containing SQL: %s, FlowFile %s", sqlField, flowFile));
                }
                if (context.getProperty(ALLOW_MULTIPLE_STATEMENTS).asBoolean().booleanValue()) {
                    String regex = "(?<!\\\\);";
                    sqlStatements = sql.split("(?<!\\\\);");
                } else {
                    sqlStatements = new String[]{sql};
                }
                if (isFirstRecord) {
                    if (nextRecord == null && sqlStatements.length == 1) {
                        useBatch = false;
                    }
                    isFirstRecord = false;
                }
                for (String sqlStatement : sqlStatements) {
                    if (useBatch) {
                        ++currentBatchSize;
                        statement.addBatch(sqlStatement);
                        continue;
                    }
                    statement.execute(sqlStatement);
                }
                if (!useBatch || maxBatchSize <= 0 || currentBatchSize < maxBatchSize) continue;
                log.debug("Executing batch with last query {} because batch reached max size %s for {}; batch index: {}; batch size: {}", new Object[]{sql, maxBatchSize, flowFile, ++batchIndex, currentBatchSize});
                statement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
                currentBatchSize = 0;
            }
            if (useBatch && currentBatchSize > 0) {
                log.debug("Executing last batch because last statement reached for {}; batch index: {}; batch size: {}", new Object[]{flowFile, ++batchIndex, currentBatchSize});
                statement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDML(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection con, RecordReader recordReader, String explicitStatementType, DMLSettings settings) throws IllegalArgumentException, MalformedRecordException, IOException, SQLException {
        TableSchema tableSchema;
        ComponentLog log = this.getLogger();
        String catalog = context.getProperty(CATALOG_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String schemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String updateKeys = context.getProperty(UPDATE_KEYS).evaluateAttributeExpressions(flowFile).getValue();
        int maxBatchSize = context.getProperty(MAX_BATCH_SIZE).evaluateAttributeExpressions(flowFile).asInteger();
        int timeoutMillis = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        String binaryStringFormat = context.getProperty(BINARY_STRING_FORMAT).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException(String.format("Cannot process %s because Table Name is null or empty", flowFile));
        }
        SchemaKey schemaKey = new SchemaKey(catalog, schemaName, tableName);
        try {
            tableSchema = (TableSchema)this.schemaCache.get((Object)schemaKey, key -> {
                try {
                    TableSchema schema = TableSchema.from(con, catalog, schemaName, tableName, settings.translateFieldNames, updateKeys, log);
                    this.getLogger().debug("Fetched Table Schema {} for table name {}", new Object[]{schema, tableName});
                    return schema;
                }
                catch (SQLException e) {
                    throw new ProcessException((Throwable)e);
                }
            });
            if (tableSchema == null) {
                throw new IllegalArgumentException("No table schema specified!");
            }
        }
        catch (ProcessException pe) {
            if (pe.getCause() instanceof SQLException) {
                throw (SQLException)pe.getCause();
            }
            throw pe;
        }
        String fqTableName = this.generateTableName(settings, catalog, schemaName, tableName, tableSchema);
        HashMap<String, PreparedSqlAndColumns> preparedSql = new HashMap<String, PreparedSqlAndColumns>();
        int currentBatchSize = 0;
        int batchIndex = 0;
        Statement lastPreparedStatement = null;
        try {
            Record outerRecord;
            while ((outerRecord = recordReader.nextRecord()) != null) {
                String statementType = USE_RECORD_PATH.equalsIgnoreCase(explicitStatementType) ? this.recordPathOperationType.apply(outerRecord) : explicitStatementType;
                List<Record> dataRecords = this.getDataRecords(outerRecord);
                for (Record currentRecord : dataRecords) {
                    PreparedSqlAndColumns preparedSqlAndColumns = (PreparedSqlAndColumns)preparedSql.get(statementType);
                    if (preparedSqlAndColumns == null) {
                        PreparedStatement preparedStatement;
                        SqlAndIncludedColumns sqlHolder;
                        block48: {
                            RecordSchema recordSchema = currentRecord.getSchema();
                            if (INSERT_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateInsert(recordSchema, fqTableName, tableSchema, settings);
                            } else if (UPDATE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateUpdate(recordSchema, fqTableName, updateKeys, tableSchema, settings);
                            } else if (DELETE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateDelete(recordSchema, fqTableName, tableSchema, settings);
                            } else if (UPSERT_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateUpsert(recordSchema, fqTableName, updateKeys, tableSchema, settings);
                            } else if (INSERT_IGNORE_TYPE.equalsIgnoreCase(statementType)) {
                                sqlHolder = this.generateInsertIgnore(recordSchema, fqTableName, updateKeys, tableSchema, settings);
                            } else {
                                throw new IllegalArgumentException(String.format("Statement Type %s is not valid, FlowFile %s", statementType, flowFile));
                            }
                            log.debug("Generated SQL: {}", new Object[]{sqlHolder.getSql()});
                            preparedStatement = con.prepareStatement(sqlHolder.getSql());
                            try {
                                preparedStatement.setQueryTimeout(timeoutMillis);
                            }
                            catch (SQLException se) {
                                if (timeoutMillis <= 0) break block48;
                                throw se;
                            }
                        }
                        preparedSqlAndColumns = new PreparedSqlAndColumns(sqlHolder, preparedStatement);
                        preparedSql.put(statementType, preparedSqlAndColumns);
                    }
                    PreparedStatement ps = preparedSqlAndColumns.getPreparedStatement();
                    List<Integer> fieldIndexes = preparedSqlAndColumns.getSqlAndIncludedColumns().getFieldIndexes();
                    String sql = preparedSqlAndColumns.getSqlAndIncludedColumns().getSql();
                    if (ps != lastPreparedStatement && lastPreparedStatement != null) {
                        log.debug("Executing query {} because Statement Type changed between Records for {}; fieldIndexes: {}; batch index: {}; batch size: {}", new Object[]{sql, flowFile, fieldIndexes, ++batchIndex, currentBatchSize});
                        lastPreparedStatement.executeBatch();
                        session.adjustCounter("Batches Executed", 1L, false);
                        currentBatchSize = 0;
                    }
                    lastPreparedStatement = ps;
                    Object[] values = currentRecord.getValues();
                    List dataTypes = currentRecord.getSchema().getDataTypes();
                    RecordSchema recordSchema = currentRecord.getSchema();
                    Map<String, ColumnDescription> columns = tableSchema.getColumns();
                    int deleteIndex = 0;
                    for (int i = 0; i < fieldIndexes.size(); ++i) {
                        int sqlType;
                        int currentFieldIndex = fieldIndexes.get(i);
                        Object currentValue = values[currentFieldIndex];
                        DataType dataType = (DataType)dataTypes.get(currentFieldIndex);
                        int fieldSqlType = DataTypeUtils.getSQLTypeValue((DataType)dataType);
                        String fieldName = recordSchema.getField(currentFieldIndex).getFieldName();
                        String columnName = ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames);
                        ColumnDescription column = columns.get(columnName);
                        if (column == null) {
                            if (!settings.ignoreUnmappedFields) {
                                throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", columns.keySet()));
                            }
                            sqlType = fieldSqlType;
                        } else {
                            sqlType = column.getDataType();
                            if (sqlType == -150) {
                                sqlType = -156;
                            }
                        }
                        if (fieldSqlType != sqlType) {
                            try {
                                DataType targetDataType = DataTypeUtils.getDataTypeFromSQLTypeValue((int)sqlType);
                                if (targetDataType == null) {
                                    targetDataType = DataTypeUtils.getDataTypeFromSQLTypeValue((int)fieldSqlType);
                                }
                                if (targetDataType != null) {
                                    if (sqlType == 2004 || sqlType == -2 || sqlType == -3 || sqlType == -4) {
                                        if (currentValue instanceof Object[]) {
                                            Object[] src = (Object[])currentValue;
                                            if (src.length > 0 && !(src[0] instanceof Byte)) {
                                                throw new IllegalTypeConversionException("Cannot convert value " + currentValue + " to BLOB/BINARY/VARBINARY/LONGVARBINARY");
                                            }
                                            byte[] dest = new byte[src.length];
                                            for (int j = 0; j < src.length; ++j) {
                                                dest[j] = (Byte)src[j];
                                            }
                                            currentValue = dest;
                                        } else if (currentValue instanceof String) {
                                            String stringValue = (String)currentValue;
                                            currentValue = BINARY_STRING_FORMAT_BASE64.getValue().equals(binaryStringFormat) ? (Object)BaseEncoding.base64().decode((CharSequence)stringValue) : (BINARY_STRING_FORMAT_HEX_STRING.getValue().equals(binaryStringFormat) ? (Object)BaseEncoding.base16().decode((CharSequence)stringValue.toUpperCase()) : (Object)stringValue.getBytes(StandardCharsets.UTF_8));
                                        } else if (currentValue != null && !(currentValue instanceof byte[])) {
                                            throw new IllegalTypeConversionException("Cannot convert value " + currentValue + " to BLOB/BINARY/VARBINARY/LONGVARBINARY");
                                        }
                                    } else {
                                        currentValue = DataTypeUtils.convertType((Object)currentValue, (DataType)targetDataType, (String)fieldName);
                                    }
                                }
                            }
                            catch (IllegalTypeConversionException itce) {
                                sqlType = DataTypeUtils.getSQLTypeValue((DataType)dataType);
                            }
                        }
                        if (DELETE_TYPE.equalsIgnoreCase(statementType)) {
                            this.setParameter(ps, ++deleteIndex, currentValue, fieldSqlType, sqlType);
                            if (column == null || !column.isNullable()) continue;
                            this.setParameter(ps, ++deleteIndex, currentValue, fieldSqlType, sqlType);
                            continue;
                        }
                        if (UPSERT_TYPE.equalsIgnoreCase(statementType)) {
                            int timesToAddObjects = this.databaseAdapter.getTimesToAddColumnObjectsForUpsert();
                            for (int j = 0; j < timesToAddObjects; ++j) {
                                this.setParameter(ps, i + fieldIndexes.size() * j + 1, currentValue, fieldSqlType, sqlType);
                            }
                            continue;
                        }
                        this.setParameter(ps, i + 1, currentValue, fieldSqlType, sqlType);
                    }
                    ps.addBatch();
                    session.adjustCounter(statementType + " updates performed", 1L, false);
                    if (++currentBatchSize != maxBatchSize) continue;
                    log.debug("Executing query {} because batch reached max size for {}; fieldIndexes: {}; batch index: {}; batch size: {}", new Object[]{sql, flowFile, fieldIndexes, ++batchIndex, currentBatchSize});
                    session.adjustCounter("Batches Executed", 1L, false);
                    ps.executeBatch();
                    currentBatchSize = 0;
                }
            }
            if (currentBatchSize > 0) {
                lastPreparedStatement.executeBatch();
                session.adjustCounter("Batches Executed", 1L, false);
            }
        }
        finally {
            for (PreparedSqlAndColumns preparedSqlAndColumns : preparedSql.values()) {
                preparedSqlAndColumns.getPreparedStatement().close();
            }
        }
    }

    private void setParameter(PreparedStatement ps, int index, Object value, int fieldSqlType, int sqlType) throws IOException {
        block46: {
            if (sqlType == 2004) {
                if (fieldSqlType == 2003 || fieldSqlType == 12) {
                    if (!(value instanceof byte[])) {
                        if (value == null) {
                            try {
                                ps.setNull(index, 2004);
                                return;
                            }
                            catch (SQLException e) {
                                throw new IOException("Unable to setNull() on prepared statement", e);
                            }
                        }
                        throw new IOException("Expected BLOB to be of type byte[] but is instead " + value.getClass().getName());
                    }
                    byte[] byteArray = (byte[])value;
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);){
                        ps.setBlob(index, inputStream);
                        break block46;
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data " + value, e);
                    }
                }
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(value.toString().getBytes(StandardCharsets.UTF_8));){
                    ps.setBlob(index, inputStream);
                    break block46;
                }
                catch (IOException | SQLException e) {
                    throw new IOException("Unable to parse binary data " + value, e);
                }
            }
            if (sqlType == 2005) {
                if (value == null) {
                    try {
                        ps.setNull(index, 2005);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to setNull() on prepared statement", e);
                    }
                } else {
                    try {
                        Clob clob = ps.getConnection().createClob();
                        clob.setString(1L, value.toString());
                        ps.setClob(index, clob);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse data as CLOB/String " + value, e);
                    }
                }
            } else if (sqlType == -3 || sqlType == -4) {
                if (fieldSqlType == 2003 || fieldSqlType == 12) {
                    if (!(value instanceof byte[])) {
                        if (value == null) {
                            try {
                                ps.setNull(index, 2004);
                                return;
                            }
                            catch (SQLException e) {
                                throw new IOException("Unable to setNull() on prepared statement", e);
                            }
                        }
                        throw new IOException("Expected VARBINARY/LONGVARBINARY to be of type byte[] but is instead " + value.getClass().getName());
                    }
                    byte[] byteArray = (byte[])value;
                    try {
                        ps.setBytes(index, byteArray);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data with size" + byteArray.length, e);
                    }
                } else {
                    byte[] byteArray = new byte[]{};
                    try {
                        byteArray = value.toString().getBytes(StandardCharsets.UTF_8);
                        ps.setBytes(index, byteArray);
                    }
                    catch (SQLException e) {
                        throw new IOException("Unable to parse binary data with size" + byteArray.length, e);
                    }
                }
            } else {
                try {
                    if (fieldSqlType == 1111 && sqlType == 12) {
                        try {
                            ps.setObject(index, value, fieldSqlType);
                        }
                        catch (SQLException e) {
                            ps.setObject(index, value, sqlType);
                        }
                    } else {
                        ps.setObject(index, value, sqlType);
                    }
                }
                catch (SQLException e) {
                    throw new IOException("Unable to setObject() with value " + value + " at index " + index + " of type " + sqlType, e);
                }
            }
        }
    }

    private List<Record> getDataRecords(Record outerRecord) {
        if (this.dataRecordPath == null) {
            return Collections.singletonList(outerRecord);
        }
        RecordPathResult result = this.dataRecordPath.evaluate(outerRecord);
        List fieldValues = result.getSelectedFields().collect(Collectors.toList());
        if (fieldValues.isEmpty()) {
            throw new ProcessException("RecordPath " + this.dataRecordPath.getPath() + " evaluated against Record yielded no results.");
        }
        for (FieldValue fieldValue : fieldValues) {
            RecordFieldType fieldType = fieldValue.getField().getDataType().getFieldType();
            if (fieldType == RecordFieldType.RECORD) continue;
            throw new ProcessException("RecordPath " + this.dataRecordPath.getPath() + " evaluated against Record expected to return one or more Records but encountered field of type " + fieldType);
        }
        ArrayList<Record> dataRecords = new ArrayList<Record>(fieldValues.size());
        for (FieldValue fieldValue : fieldValues) {
            dataRecords.add((Record)fieldValue.getValue());
        }
        return dataRecords;
    }

    private String getJdbcUrl(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                return databaseMetaData.getURL();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not determine JDBC URL based on the Driver Connection.", (Throwable)e);
        }
        return "DBCPService";
    }

    private String getStatementType(ProcessContext context, FlowFile flowFile) {
        String statementTypeProperty;
        String statementType = statementTypeProperty = context.getProperty(STATEMENT_TYPE).getValue();
        if (USE_ATTR_TYPE.equals(statementTypeProperty)) {
            statementType = flowFile.getAttribute(STATEMENT_TYPE_ATTRIBUTE);
        }
        return this.validateStatementType(statementType, flowFile);
    }

    private String validateStatementType(String statementType, FlowFile flowFile) {
        if (statementType == null || statementType.trim().isEmpty()) {
            throw new ProcessException("No Statement Type specified for " + flowFile);
        }
        if (INSERT_TYPE.equalsIgnoreCase(statementType) || UPDATE_TYPE.equalsIgnoreCase(statementType) || DELETE_TYPE.equalsIgnoreCase(statementType) || UPSERT_TYPE.equalsIgnoreCase(statementType) || SQL_TYPE.equalsIgnoreCase(statementType) || USE_RECORD_PATH.equalsIgnoreCase(statementType) || INSERT_IGNORE_TYPE.equalsIgnoreCase(statementType)) {
            return statementType;
        }
        throw new ProcessException("Invalid Statement Type <" + statementType + "> for " + flowFile);
    }

    private void putToDatabase(ProcessContext context, ProcessSession session, FlowFile flowFile, Connection connection) throws Exception {
        String statementType = this.getStatementType(context, flowFile);
        try (InputStream in = session.read(flowFile);){
            RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER_FACTORY).asControllerService(RecordReaderFactory.class);
            RecordReader recordReader = recordReaderFactory.createRecordReader(flowFile, in, this.getLogger());
            if (SQL_TYPE.equalsIgnoreCase(statementType)) {
                this.executeSQL(context, session, flowFile, connection, recordReader);
            } else {
                DMLSettings settings = new DMLSettings(context);
                this.executeDML(context, session, flowFile, connection, recordReader, statementType, settings);
            }
        }
    }

    String generateTableName(DMLSettings settings, String catalog, String schemaName, String tableName, TableSchema tableSchema) {
        StringBuilder tableNameBuilder = new StringBuilder();
        if (catalog != null) {
            if (settings.quoteTableName) {
                tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(catalog).append(tableSchema.getQuotedIdentifierString());
            } else {
                tableNameBuilder.append(catalog);
            }
            tableNameBuilder.append(".");
        }
        if (schemaName != null) {
            if (settings.quoteTableName) {
                tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(schemaName).append(tableSchema.getQuotedIdentifierString());
            } else {
                tableNameBuilder.append(schemaName);
            }
            tableNameBuilder.append(".");
        }
        if (settings.quoteTableName) {
            tableNameBuilder.append(tableSchema.getQuotedIdentifierString()).append(tableName).append(tableSchema.getQuotedIdentifierString());
        } else {
            tableNameBuilder.append(tableName);
        }
        return tableNameBuilder.toString();
    }

    private Set<String> getNormalizedColumnNames(RecordSchema schema, boolean translateFieldNames) {
        HashSet<String> normalizedFieldNames = new HashSet<String>();
        if (schema != null) {
            schema.getFieldNames().forEach(fieldName -> normalizedFieldNames.add(ColumnDescription.normalizeColumnName(fieldName, translateFieldNames)));
        }
        return normalizedFieldNames;
    }

    SqlAndIncludedColumns generateInsert(RecordSchema recordSchema, String tableName, TableSchema tableSchema, DMLSettings settings) throws IllegalArgumentException, SQLException {
        this.checkValuesForRequiredColumns(recordSchema, tableSchema, settings);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO ");
        sqlBuilder.append(tableName);
        sqlBuilder.append(" (");
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (fieldsFound.getAndIncrement() > 0) {
                        sqlBuilder.append(", ");
                    }
                    if (settings.escapeColumnNames) {
                        sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                    } else {
                        sqlBuilder.append(desc.getColumnName());
                    }
                    includedColumns.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
            sqlBuilder.append(") VALUES (");
            sqlBuilder.append(StringUtils.repeat((String)"?", (String)",", (int)includedColumns.size()));
            sqlBuilder.append(")");
            if (fieldsFound.get() == 0) {
                throw new SQLDataException("None of the fields in the record map to the columns defined by the " + tableName + " table\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    SqlAndIncludedColumns generateUpsert(RecordSchema recordSchema, String tableName, String updateKeys, TableSchema tableSchema, DMLSettings settings) throws IllegalArgumentException, SQLException, MalformedRecordException {
        this.checkValuesForRequiredColumns(recordSchema, tableSchema, settings);
        Set<String> keyColumnNames = this.getUpdateKeyColumnNames(tableName, updateKeys, tableSchema);
        this.normalizeKeyColumnNamesAndCheckForValues(recordSchema, updateKeys, settings, keyColumnNames);
        ArrayList<String> usedColumnNames = new ArrayList<String>();
        ArrayList<Integer> usedColumnIndices = new ArrayList<Integer>();
        List fieldNames = recordSchema.getFieldNames();
        if (fieldNames != null) {
            int fieldCount = fieldNames.size();
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (settings.escapeColumnNames) {
                        usedColumnNames.add(tableSchema.getQuotedIdentifierString() + desc.getColumnName() + tableSchema.getQuotedIdentifierString());
                    } else {
                        usedColumnNames.add(desc.getColumnName());
                    }
                    usedColumnIndices.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        HashSet<String> literalKeyColumnNames = new HashSet<String>(keyColumnNames.size());
        for (String literalKeyColumnName : keyColumnNames) {
            if (settings.escapeColumnNames) {
                literalKeyColumnNames.add(tableSchema.getQuotedIdentifierString() + literalKeyColumnName + tableSchema.getQuotedIdentifierString());
                continue;
            }
            literalKeyColumnNames.add(literalKeyColumnName);
        }
        String sql = this.databaseAdapter.getUpsertStatement(tableName, usedColumnNames, literalKeyColumnNames);
        return new SqlAndIncludedColumns(sql, usedColumnIndices);
    }

    SqlAndIncludedColumns generateInsertIgnore(RecordSchema recordSchema, String tableName, String updateKeys, TableSchema tableSchema, DMLSettings settings) throws IllegalArgumentException, SQLException, MalformedRecordException {
        this.checkValuesForRequiredColumns(recordSchema, tableSchema, settings);
        Set<String> keyColumnNames = this.getUpdateKeyColumnNames(tableName, updateKeys, tableSchema);
        this.normalizeKeyColumnNamesAndCheckForValues(recordSchema, updateKeys, settings, keyColumnNames);
        ArrayList<String> usedColumnNames = new ArrayList<String>();
        ArrayList<Integer> usedColumnIndices = new ArrayList<Integer>();
        List fieldNames = recordSchema.getFieldNames();
        if (fieldNames != null) {
            int fieldCount = fieldNames.size();
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (settings.escapeColumnNames) {
                        usedColumnNames.add(tableSchema.getQuotedIdentifierString() + desc.getColumnName() + tableSchema.getQuotedIdentifierString());
                    } else {
                        usedColumnNames.add(desc.getColumnName());
                    }
                    usedColumnIndices.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        HashSet<String> literalKeyColumnNames = new HashSet<String>(keyColumnNames.size());
        for (String literalKeyColumnName : keyColumnNames) {
            if (settings.escapeColumnNames) {
                literalKeyColumnNames.add(tableSchema.getQuotedIdentifierString() + literalKeyColumnName + tableSchema.getQuotedIdentifierString());
                continue;
            }
            literalKeyColumnNames.add(literalKeyColumnName);
        }
        String sql = this.databaseAdapter.getInsertIgnoreStatement(tableName, usedColumnNames, literalKeyColumnNames);
        return new SqlAndIncludedColumns(sql, usedColumnIndices);
    }

    SqlAndIncludedColumns generateUpdate(RecordSchema recordSchema, String tableName, String updateKeys, TableSchema tableSchema, DMLSettings settings) throws IllegalArgumentException, MalformedRecordException, SQLException {
        Set<String> keyColumnNames = this.getUpdateKeyColumnNames(tableName, updateKeys, tableSchema);
        Set<String> normalizedKeyColumnNames = this.normalizeKeyColumnNamesAndCheckForValues(recordSchema, updateKeys, settings, keyColumnNames);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ");
        sqlBuilder.append(tableName);
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            sqlBuilder.append(" SET ");
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                String normalizedColName = ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames);
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null) {
                    if (!settings.ignoreUnmappedFields) {
                        throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                    }
                    this.getLogger().debug("Did not map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                    continue;
                }
                if (normalizedKeyColumnNames.contains(normalizedColName)) continue;
                if (fieldsFound.getAndIncrement() > 0) {
                    sqlBuilder.append(", ");
                }
                if (settings.escapeColumnNames) {
                    sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                } else {
                    sqlBuilder.append(desc.getColumnName());
                }
                sqlBuilder.append(" = ?");
                includedColumns.add(i);
            }
            AtomicInteger whereFieldCount = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                boolean firstUpdateKey = true;
                String normalizedColName = ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames);
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null || !normalizedKeyColumnNames.contains(normalizedColName)) continue;
                if (whereFieldCount.getAndIncrement() > 0) {
                    sqlBuilder.append(" AND ");
                } else if (firstUpdateKey) {
                    sqlBuilder.append(" WHERE ");
                    firstUpdateKey = false;
                }
                if (settings.escapeColumnNames) {
                    sqlBuilder.append(tableSchema.getQuotedIdentifierString()).append(desc.getColumnName()).append(tableSchema.getQuotedIdentifierString());
                } else {
                    sqlBuilder.append(desc.getColumnName());
                }
                sqlBuilder.append(" = ?");
                includedColumns.add(i);
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    SqlAndIncludedColumns generateDelete(RecordSchema recordSchema, String tableName, TableSchema tableSchema, DMLSettings settings) throws IllegalArgumentException, MalformedRecordException, SQLDataException {
        Set<String> normalizedFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames);
        for (String requiredColName : tableSchema.getRequiredColumnNames()) {
            String normalizedColName = ColumnDescription.normalizeColumnName(requiredColName, settings.translateFieldNames);
            if (normalizedFieldNames.contains(normalizedColName)) continue;
            String missingColMessage = "Record does not have a value for the Required column '" + requiredColName + "'";
            if (settings.failUnmappedColumns) {
                this.getLogger().error(missingColMessage);
                throw new MalformedRecordException(missingColMessage);
            }
            if (!settings.warningUnmappedColumns) continue;
            this.getLogger().warn(missingColMessage);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DELETE FROM ");
        sqlBuilder.append(tableName);
        List fieldNames = recordSchema.getFieldNames();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        if (fieldNames != null) {
            sqlBuilder.append(" WHERE ");
            int fieldCount = fieldNames.size();
            AtomicInteger fieldsFound = new AtomicInteger(0);
            for (int i = 0; i < fieldCount; ++i) {
                RecordField field = recordSchema.getField(i);
                String fieldName = field.getFieldName();
                ColumnDescription desc = tableSchema.getColumns().get(ColumnDescription.normalizeColumnName(fieldName, settings.translateFieldNames));
                if (desc == null && !settings.ignoreUnmappedFields) {
                    throw new SQLDataException("Cannot map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
                }
                if (desc != null) {
                    if (fieldsFound.getAndIncrement() > 0) {
                        sqlBuilder.append(" AND ");
                    }
                    Object columnName = settings.escapeColumnNames ? tableSchema.getQuotedIdentifierString() + desc.getColumnName() + tableSchema.getQuotedIdentifierString() : desc.getColumnName();
                    sqlBuilder.append("(");
                    sqlBuilder.append((String)columnName);
                    sqlBuilder.append(" = ?");
                    if (desc.isNullable()) {
                        sqlBuilder.append(" OR (");
                        sqlBuilder.append((String)columnName);
                        sqlBuilder.append(" is null AND ? is null))");
                    } else {
                        sqlBuilder.append(")");
                    }
                    includedColumns.add(i);
                    continue;
                }
                this.getLogger().debug("Did not map field '" + fieldName + "' to any column in the database\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
            if (fieldsFound.get() == 0) {
                throw new SQLDataException("None of the fields in the record map to the columns defined by the " + tableName + " table\n" + (settings.translateFieldNames ? "Normalized " : "") + "Columns: " + String.join((CharSequence)",", tableSchema.getColumns().keySet()));
            }
        }
        return new SqlAndIncludedColumns(sqlBuilder.toString(), includedColumns);
    }

    private void checkValuesForRequiredColumns(RecordSchema recordSchema, TableSchema tableSchema, DMLSettings settings) {
        Set<String> normalizedFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames);
        for (String requiredColName : tableSchema.getRequiredColumnNames()) {
            String normalizedColName = ColumnDescription.normalizeColumnName(requiredColName, settings.translateFieldNames);
            if (normalizedFieldNames.contains(normalizedColName)) continue;
            String missingColMessage = "Record does not have a value for the Required column '" + requiredColName + "'";
            if (settings.failUnmappedColumns) {
                this.getLogger().error(missingColMessage);
                throw new IllegalArgumentException(missingColMessage);
            }
            if (!settings.warningUnmappedColumns) continue;
            this.getLogger().warn(missingColMessage);
        }
    }

    private Set<String> getUpdateKeyColumnNames(String tableName, String updateKeys, TableSchema tableSchema) throws SQLIntegrityConstraintViolationException {
        Set<String> updateKeyColumnNames;
        if (updateKeys == null) {
            updateKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        } else {
            updateKeyColumnNames = new HashSet<String>();
            for (String updateKey : updateKeys.split(",")) {
                updateKeyColumnNames.add(updateKey.trim());
            }
        }
        if (updateKeyColumnNames.isEmpty()) {
            throw new SQLIntegrityConstraintViolationException("Table '" + tableName + "' not found or does not have a Primary Key and no Update Keys were specified");
        }
        return updateKeyColumnNames;
    }

    private Set<String> normalizeKeyColumnNamesAndCheckForValues(RecordSchema recordSchema, String updateKeys, DMLSettings settings, Set<String> updateKeyColumnNames) throws MalformedRecordException {
        Set<String> normalizedRecordFieldNames = this.getNormalizedColumnNames(recordSchema, settings.translateFieldNames);
        HashSet<String> normalizedKeyColumnNames = new HashSet<String>();
        for (String updateKeyColumnName : updateKeyColumnNames) {
            String normalizedKeyColumnName = ColumnDescription.normalizeColumnName(updateKeyColumnName, settings.translateFieldNames);
            if (!normalizedRecordFieldNames.contains(normalizedKeyColumnName)) {
                String missingColMessage = "Record does not have a value for the " + (updateKeys == null ? "Primary" : "Update") + "Key column '" + updateKeyColumnName + "'";
                if (settings.failUnmappedColumns) {
                    this.getLogger().error(missingColMessage);
                    throw new MalformedRecordException(missingColMessage);
                }
                if (settings.warningUnmappedColumns) {
                    this.getLogger().warn(missingColMessage);
                }
            }
            normalizedKeyColumnNames.add(normalizedKeyColumnName);
        }
        return normalizedKeyColumnNames;
    }

    private boolean isSupportsBatchUpdates(Connection connection) {
        try {
            return connection.getMetaData().supportsBatchUpdates();
        }
        catch (Exception ex) {
            this.getLogger().debug(String.format("Exception while testing if connection supportsBatchUpdates due to %s - %s", ex.getClass().getName(), ex.getMessage()));
            return false;
        }
    }

    static {
        RECORD_READER_FACTORY = new PropertyDescriptor.Builder().name("put-db-record-record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
        STATEMENT_TYPE = new PropertyDescriptor.Builder().name("put-db-record-statement-type").displayName("Statement Type").description("Specifies the type of SQL Statement to generate. Please refer to the database documentation for a description of the behavior of each operation. Please note that some Database Types may not support certain Statement Types. If 'Use statement.type Attribute' is chosen, then the value is taken from the statement.type attribute in the FlowFile. The 'Use statement.type Attribute' option is the only one that allows the 'SQL' statement type. If 'SQL' is specified, the value of the field specified by the 'Field Containing SQL' property is expected to be a valid SQL statement on the target database, and will be executed as-is.").required(true).allowableValues(new String[]{UPDATE_TYPE, INSERT_TYPE, UPSERT_TYPE, INSERT_IGNORE_TYPE, DELETE_TYPE, USE_ATTR_TYPE, USE_RECORD_PATH}).build();
        STATEMENT_TYPE_RECORD_PATH = new PropertyDescriptor.Builder().name("Statement Type Record Path").displayName("Statement Type Record Path").description("Specifies a RecordPath to evaluate against each Record in order to determine the Statement Type. The RecordPath should equate to either INSERT, UPDATE, UPSERT, or DELETE.").required(true).addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(STATEMENT_TYPE, USE_RECORD_PATH, new String[0]).build();
        DATA_RECORD_PATH = new PropertyDescriptor.Builder().name("Data Record Path").displayName("Data Record Path").description("If specified, this property denotes a RecordPath that will be evaluated against each incoming Record and the Record that results from evaluating the RecordPath will be sent to the database instead of sending the entire incoming Record. If not specified, the entire incoming Record will be published to the database.").required(false).addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
        DBCP_SERVICE = new PropertyDescriptor.Builder().name("put-db-record-dcbp-service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database for sending records.").required(true).identifiesControllerService(DBCPService.class).build();
        CATALOG_NAME = new PropertyDescriptor.Builder().name("put-db-record-catalog-name").displayName("Catalog Name").description("The name of the catalog that the statement should update. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the catalog name must match the database's catalog name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        SCHEMA_NAME = new PropertyDescriptor.Builder().name("put-db-record-schema-name").displayName("Schema Name").description("The name of the schema that the table belongs to. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the schema name must match the database's schema name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        TABLE_NAME = new PropertyDescriptor.Builder().name("put-db-record-table-name").displayName("Table Name").description("The name of the table that the statement should affect. Note that if the database is case-sensitive, the table name must match the database's table name exactly.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        BINARY_STRING_FORMAT_UTF8 = new AllowableValue("UTF-8", "UTF-8", "String values for binary columns contain the original value as text via UTF-8 character encoding");
        BINARY_STRING_FORMAT_HEX_STRING = new AllowableValue("Hexadecimal", "Hexadecimal", "String values for binary columns contain the original value in hexadecimal format");
        BINARY_STRING_FORMAT_BASE64 = new AllowableValue("Base64", "Base64", "String values for binary columns contain the original value in Base64 encoded format");
        BINARY_STRING_FORMAT = new PropertyDescriptor.Builder().name("put-db-record-binary-format").displayName("Binary String Format").description("The format to be applied when decoding string values to binary.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).allowableValues(new AllowableValue[]{BINARY_STRING_FORMAT_UTF8, BINARY_STRING_FORMAT_HEX_STRING, BINARY_STRING_FORMAT_BASE64}).defaultValue(BINARY_STRING_FORMAT_UTF8.getValue()).build();
        TRANSLATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("put-db-record-translate-field-names").displayName("Translate Field Names").description("If true, the Processor will attempt to translate field names into the appropriate column names for the table specified. If false, the field names must match the column names exactly, or the column will not be updated").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
        UNMATCHED_FIELD_BEHAVIOR = new PropertyDescriptor.Builder().name("put-db-record-unmatched-field-behavior").displayName("Unmatched Field Behavior").description("If an incoming record has a field that does not map to any of the database table's columns, this property specifies how to handle the situation").allowableValues(new AllowableValue[]{IGNORE_UNMATCHED_FIELD, FAIL_UNMATCHED_FIELD}).defaultValue(IGNORE_UNMATCHED_FIELD.getValue()).build();
        UNMATCHED_COLUMN_BEHAVIOR = new PropertyDescriptor.Builder().name("put-db-record-unmatched-column-behavior").displayName("Unmatched Column Behavior").description("If an incoming record does not have a field mapping for all of the database table's columns, this property specifies how to handle the situation").allowableValues(new AllowableValue[]{IGNORE_UNMATCHED_COLUMN, WARNING_UNMATCHED_COLUMN, FAIL_UNMATCHED_COLUMN}).defaultValue(FAIL_UNMATCHED_COLUMN.getValue()).build();
        UPDATE_KEYS = new PropertyDescriptor.Builder().name("put-db-record-update-keys").displayName("Update Keys").description("A comma-separated list of column names that uniquely identifies a row in the database for UPDATE statements. If the Statement Type is UPDATE and this property is not set, the table's Primary Keys are used. In this case, if no Primary Key exists, the conversion to SQL will fail if Unmatched Column Behaviour is set to FAIL. This property is ignored if the Statement Type is INSERT").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(STATEMENT_TYPE, UPDATE_TYPE, new String[]{UPSERT_TYPE, SQL_TYPE, USE_ATTR_TYPE, USE_RECORD_PATH}).build();
        FIELD_CONTAINING_SQL = new PropertyDescriptor.Builder().name("put-db-record-field-containing-sql").displayName("Field Containing SQL").description("If the Statement Type is 'SQL' (as set in the statement.type attribute), this field indicates which field in the record(s) contains the SQL statement to execute. The value of the field must be a single SQL statement. If the Statement Type is not 'SQL', this field is ignored.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(STATEMENT_TYPE, USE_ATTR_TYPE, new String[]{USE_RECORD_PATH}).build();
        ALLOW_MULTIPLE_STATEMENTS = new PropertyDescriptor.Builder().name("put-db-record-allow-multiple-statements").displayName("Allow Multiple SQL Statements").description("If the Statement Type is 'SQL' (as set in the statement.type attribute), this field indicates whether to split the field value by a semicolon and execute each statement separately. If any statement causes an error, the entire set of statements will be rolled back. If the Statement Type is not 'SQL', this field is ignored.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").dependsOn(STATEMENT_TYPE, USE_ATTR_TYPE, new String[]{USE_RECORD_PATH}).build();
        QUOTE_IDENTIFIERS = new PropertyDescriptor.Builder().name("put-db-record-quoted-identifiers").displayName("Quote Column Identifiers").description("Enabling this option will cause all column names to be quoted, allowing you to use reserved words as column names in your tables.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
        QUOTE_TABLE_IDENTIFIER = new PropertyDescriptor.Builder().name("put-db-record-quoted-table-identifiers").displayName("Quote Table Identifiers").description("Enabling this option will cause the table name to be quoted to support the use of special characters in the table name.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
        QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("put-db-record-query-timeout").displayName("Max Wait Time").description("The maximum amount of time allowed for a running SQL statement , zero means there is no limit. Max time less than 1 second will be equal to zero.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        TABLE_SCHEMA_CACHE_SIZE = new PropertyDescriptor.Builder().name("table-schema-cache-size").displayName("Table Schema Cache Size").description("Specifies how many Table Schemas should be cached").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("100").required(true).build();
        MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("put-db-record-max-batch-size").displayName("Maximum Batch Size").description("Specifies maximum number of sql statements to be included in each batch sent to the database. Zero means the batch size is not limited, and all statements are put into a single batch which can cause high memory usage issues for a very large number of statements.").defaultValue("1000").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        AUTO_COMMIT = new PropertyDescriptor.Builder().name("database-session-autocommit").displayName("Database Session AutoCommit").description("The autocommit mode to set on the database connection being used. If set to false, the operation(s) will be explicitly committed or rolled back (based on success or failure respectively). If set to true, the driver/database automatically handles the commit/rollback. Setting this property to 'No value' will leave the database connection's autocommit mode unmodified.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(false).build();
        dbAdapters = new HashMap<String, DatabaseAdapter>();
        ArrayList dbAdapterValues = new ArrayList();
        ServiceLoader<DatabaseAdapter> dbAdapterLoader = ServiceLoader.load(DatabaseAdapter.class);
        dbAdapterLoader.forEach(databaseAdapter -> {
            dbAdapters.put(databaseAdapter.getName(), (DatabaseAdapter)databaseAdapter);
            dbAdapterValues.add(new AllowableValue(databaseAdapter.getName(), databaseAdapter.getName(), databaseAdapter.getDescription()));
        });
        DB_TYPE = new PropertyDescriptor.Builder().name("db-type").displayName("Database Type").description("The type/flavor of database, used for generating database-specific code. In many cases the Generic type should suffice, but some databases (such as Oracle) require custom SQL clauses. ").allowableValues(dbAdapterValues.toArray(new AllowableValue[0])).defaultValue("Generic").required(false).build();
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        r.add(REL_FAILURE);
        r.add(REL_RETRY);
        relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(RECORD_READER_FACTORY);
        pds.add(DB_TYPE);
        pds.add(STATEMENT_TYPE);
        pds.add(STATEMENT_TYPE_RECORD_PATH);
        pds.add(DATA_RECORD_PATH);
        pds.add(DBCP_SERVICE);
        pds.add(CATALOG_NAME);
        pds.add(SCHEMA_NAME);
        pds.add(TABLE_NAME);
        pds.add(BINARY_STRING_FORMAT);
        pds.add(TRANSLATE_FIELD_NAMES);
        pds.add(UNMATCHED_FIELD_BEHAVIOR);
        pds.add(UNMATCHED_COLUMN_BEHAVIOR);
        pds.add(UPDATE_KEYS);
        pds.add(FIELD_CONTAINING_SQL);
        pds.add(ALLOW_MULTIPLE_STATEMENTS);
        pds.add(QUOTE_IDENTIFIERS);
        pds.add(QUOTE_TABLE_IDENTIFIER);
        pds.add(QUERY_TIMEOUT);
        pds.add(RollbackOnFailure.ROLLBACK_ON_FAILURE);
        pds.add(TABLE_SCHEMA_CACHE_SIZE);
        pds.add(MAX_BATCH_SIZE);
        pds.add(AUTO_COMMIT);
        propDescriptors = Collections.unmodifiableList(pds);
    }

    private static class RecordPathStatementType
    implements Function<Record, String> {
        private final RecordPath recordPath;

        public RecordPathStatementType(RecordPath recordPath) {
            this.recordPath = recordPath;
        }

        @Override
        public String apply(Record record) {
            String resultValue;
            RecordPathResult recordPathResult = this.recordPath.evaluate(record);
            List resultList = recordPathResult.getSelectedFields().distinct().collect(Collectors.toList());
            if (resultList.isEmpty()) {
                throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record but got no results");
            }
            if (resultList.size() > 1) {
                throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record and received multiple distinct results (" + resultList + ")");
            }
            switch (resultValue = String.valueOf(((FieldValue)resultList.get(0)).getValue()).toUpperCase()) {
                case "INSERT": 
                case "UPDATE": 
                case "DELETE": 
                case "UPSERT": {
                    return resultValue;
                }
            }
            throw new ProcessException("Evaluated RecordPath " + this.recordPath.getPath() + " against Record to determine Statement Type but found invalid value: " + resultValue);
        }
    }

    static class SchemaKey {
        private final String catalog;
        private final String schemaName;
        private final String tableName;

        public SchemaKey(String catalog, String schemaName, String tableName) {
            this.catalog = catalog;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        public int hashCode() {
            int result = this.catalog != null ? this.catalog.hashCode() : 0;
            result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            result = 31 * result + this.tableName.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaKey schemaKey = (SchemaKey)o;
            if (this.catalog != null ? !this.catalog.equals(schemaKey.catalog) : schemaKey.catalog != null) {
                return false;
            }
            if (this.schemaName != null ? !this.schemaName.equals(schemaKey.schemaName) : schemaKey.schemaName != null) {
                return false;
            }
            return this.tableName.equals(schemaKey.tableName);
        }
    }

    static class DMLSettings {
        private final boolean translateFieldNames;
        private final boolean ignoreUnmappedFields;
        private final boolean failUnmappedColumns;
        private final boolean warningUnmappedColumns;
        private final boolean escapeColumnNames;
        private final boolean quoteTableName;

        DMLSettings(ProcessContext context) {
            this.translateFieldNames = context.getProperty(TRANSLATE_FIELD_NAMES).asBoolean();
            this.ignoreUnmappedFields = IGNORE_UNMATCHED_FIELD.getValue().equalsIgnoreCase(context.getProperty(UNMATCHED_FIELD_BEHAVIOR).getValue());
            this.failUnmappedColumns = FAIL_UNMATCHED_COLUMN.getValue().equalsIgnoreCase(context.getProperty(UNMATCHED_COLUMN_BEHAVIOR).getValue());
            this.warningUnmappedColumns = WARNING_UNMATCHED_COLUMN.getValue().equalsIgnoreCase(context.getProperty(UNMATCHED_COLUMN_BEHAVIOR).getValue());
            this.escapeColumnNames = context.getProperty(QUOTE_IDENTIFIERS).asBoolean();
            this.quoteTableName = context.getProperty(QUOTE_TABLE_IDENTIFIER).asBoolean();
        }
    }

    static class PreparedSqlAndColumns {
        private final SqlAndIncludedColumns sqlAndIncludedColumns;
        private final PreparedStatement preparedStatement;

        public PreparedSqlAndColumns(SqlAndIncludedColumns sqlAndIncludedColumns, PreparedStatement preparedStatement) {
            this.sqlAndIncludedColumns = sqlAndIncludedColumns;
            this.preparedStatement = preparedStatement;
        }

        public SqlAndIncludedColumns getSqlAndIncludedColumns() {
            return this.sqlAndIncludedColumns;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }
    }

    static class SqlAndIncludedColumns {
        private final String sql;
        private final List<Integer> fieldIndexes;

        public SqlAndIncludedColumns(String sql, List<Integer> fieldIndexes) {
            this.sql = sql;
            this.fieldIndexes = fieldIndexes;
        }

        public String getSql() {
            return this.sql;
        }

        public List<Integer> getFieldIndexes() {
            return this.fieldIndexes;
        }
    }
}

