/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;
import org.apache.nifi.security.util.crypto.KeyedEncryptor;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyedEncryptorTest {
    private static final byte[] SECRET_KEY_BYTES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 1, 0};
    private static final SecretKey SECRET_KEY = new SecretKeySpec(SECRET_KEY_BYTES, "AES");
    private static final byte[] INITIALIZATION_VECTOR = new byte[]{7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final byte[] PLAINTEXT = new byte[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    private static final EncryptionMethod ENCRYPTION_METHOD = EncryptionMethod.AES_GCM;

    @Test
    public void testEncryptDecrypt() throws IOException {
        KeyedEncryptor encryptor = new KeyedEncryptor(ENCRYPTION_METHOD, SECRET_KEY);
        this.assertEncryptDecryptMatched(encryptor, encryptor);
    }

    @Test
    public void testEncryptDecryptWithInitializationVector() throws IOException {
        KeyedEncryptor encryptor = new KeyedEncryptor(ENCRYPTION_METHOD, SECRET_KEY, INITIALIZATION_VECTOR);
        KeyedEncryptor decryptor = new KeyedEncryptor(ENCRYPTION_METHOD, SECRET_KEY);
        this.assertEncryptDecryptMatched(encryptor, decryptor);
    }

    @Test
    public void testEncryptDecryptInitializationVectorRemoved() throws IOException {
        KeyedEncryptor encryptor = new KeyedEncryptor(ENCRYPTION_METHOD, SECRET_KEY);
        StreamCallback encryption = encryptor.getEncryptionCallback();
        StreamCallback decryption = encryptor.getDecryptionCallback();
        ByteArrayOutputStream encryptedOutputStream = new ByteArrayOutputStream();
        encryption.process((InputStream)new ByteArrayInputStream(PLAINTEXT), (OutputStream)encryptedOutputStream);
        byte[] encryptedBytes = encryptedOutputStream.toByteArray();
        byte[] encryptedBytesInitializationVectorRemoved = ArrayUtils.subarray((byte[])encryptedBytes, (int)INITIALIZATION_VECTOR.length, (int)encryptedBytes.length);
        ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedBytesInitializationVectorRemoved);
        ByteArrayOutputStream decryptedOutputStream = new ByteArrayOutputStream();
        Assertions.assertThrows(ProcessException.class, () -> decryption.process((InputStream)encryptedInputStream, (OutputStream)decryptedOutputStream));
    }

    @Test
    public void testEncryptDecryptInitializationVectorDelimiterRemoved() throws IOException {
        KeyedEncryptor encryptor = new KeyedEncryptor(ENCRYPTION_METHOD, SECRET_KEY);
        StreamCallback encryption = encryptor.getEncryptionCallback();
        StreamCallback decryption = encryptor.getDecryptionCallback();
        ByteArrayOutputStream encryptedOutputStream = new ByteArrayOutputStream();
        encryption.process((InputStream)new ByteArrayInputStream(PLAINTEXT), (OutputStream)encryptedOutputStream);
        byte[] encryptedBytes = encryptedOutputStream.toByteArray();
        int startIndex = INITIALIZATION_VECTOR.length + KeyedCipherProvider.IV_DELIMITER.length;
        byte[] encryptedBytesInitializationVectorRemoved = ArrayUtils.subarray((byte[])encryptedBytes, (int)startIndex, (int)encryptedBytes.length);
        ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedBytesInitializationVectorRemoved);
        ByteArrayOutputStream decryptedOutputStream = new ByteArrayOutputStream();
        Assertions.assertThrows(ProcessException.class, () -> decryption.process((InputStream)encryptedInputStream, (OutputStream)decryptedOutputStream));
    }

    private void assertEncryptDecryptMatched(KeyedEncryptor encryptor, KeyedEncryptor decryptor) throws IOException {
        StreamCallback encryption = encryptor.getEncryptionCallback();
        StreamCallback decryption = decryptor.getDecryptionCallback();
        ByteArrayOutputStream encryptedOutputStream = new ByteArrayOutputStream();
        encryption.process((InputStream)new ByteArrayInputStream(PLAINTEXT), (OutputStream)encryptedOutputStream);
        ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedOutputStream.toByteArray());
        ByteArrayOutputStream decryptedOutputStream = new ByteArrayOutputStream();
        decryption.process((InputStream)encryptedInputStream, (OutputStream)decryptedOutputStream);
        byte[] decrypted = decryptedOutputStream.toByteArray();
        Assertions.assertArrayEquals((byte[])PLAINTEXT, (byte[])decrypted);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

