/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPResponseEncoder;
import org.apache.nifi.processors.standard.relp.response.RELPChannelResponse;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RELPResponseEncoderTest {
    RELPResponseEncoderTest() {
    }

    @Test
    void testEncodeRELPResponse() throws IOException {
        byte[] relpResponse = new RELPChannelResponse(new RELPEncoder(Charset.defaultCharset()), RELPResponse.ok((long)321L)).toByteArray();
        ByteBufOutputStream eventBytes = new ByteBufOutputStream(Unpooled.buffer((int)relpResponse.length));
        eventBytes.write(relpResponse);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RELPResponseEncoder(Charset.defaultCharset())});
        assert (channel.writeOutbound(new Object[]{eventBytes}));
        ByteBufOutputStream result = (ByteBufOutputStream)channel.readOutbound();
        Assertions.assertEquals((Object)"321 rsp 6 200 OK\n", (Object)new String(result.buffer().array()));
    }
}

