/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ScanContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestScanContent {
    @Test
    public void testBlankLineInDictionaryTextEncoding() throws IOException {
        String dictionaryWithBlankLine = "Line1\n\nLine3";
        byte[] dictionaryBytes = "Line1\n\nLine3".getBytes(ScanContent.UTF8);
        Path dictionaryPath = Paths.get("target/dictionary", new String[0]);
        Files.write(dictionaryPath, dictionaryBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        TestRunner runner = TestRunners.newTestRunner((Processor)new ScanContent());
        runner.setThreadCount(1);
        runner.setProperty(ScanContent.DICTIONARY, dictionaryPath.toString());
        runner.setProperty(ScanContent.DICTIONARY_ENCODING, "text");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(ScanContent.REL_NO_MATCH, 1);
    }

    @Disabled(value="This test has a race condition/ordering problem")
    @Test
    public void testBinaryScan() throws IOException {
        String[] terms = new String[]{"hello", "good-bye"};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dictionaryOut = new DataOutputStream(baos);){
            for (String term : terms) {
                byte[] termBytes = term.getBytes("UTF-8");
                dictionaryOut.writeInt(termBytes.length);
                dictionaryOut.write(termBytes);
            }
            byte[] termBytes = baos.toByteArray();
            Path dictionaryPath = Paths.get("target/dictionary", new String[0]);
            Files.write(dictionaryPath, termBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            TestRunner runner = TestRunners.newTestRunner((Processor)new ScanContent());
            runner.setThreadCount(1);
            runner.setProperty(ScanContent.DICTIONARY, dictionaryPath.toString());
            runner.setProperty(ScanContent.DICTIONARY_ENCODING, "binary");
            runner.enqueue(Paths.get("src/test/resources/TestScanContent/helloWorld", new String[0]));
            runner.enqueue(Paths.get("src/test/resources/TestScanContent/wellthengood-bye", new String[0]));
            runner.enqueue(new byte[0]);
            while (!runner.isQueueEmpty()) {
                runner.run(3);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException term) {}
            }
            runner.assertTransferCount(ScanContent.REL_MATCH, 2);
            runner.assertTransferCount(ScanContent.REL_NO_MATCH, 1);
            List matched = runner.getFlowFilesForRelationship(ScanContent.REL_MATCH);
            List unmatched = runner.getFlowFilesForRelationship(ScanContent.REL_NO_MATCH);
            ((MockFlowFile)matched.get(0)).assertAttributeEquals("matching.term", "hello");
            ((MockFlowFile)matched.get(1)).assertAttributeEquals("matching.term", "good-bye");
            ((MockFlowFile)unmatched.get(0)).assertAttributeNotExists("matching.term");
        }
    }
}

