/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVReader;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.QueryRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.ArrayListRecordReader;
import org.apache.nifi.serialization.record.ArrayListRecordWriter;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryRecord {
    private static final String REL_NAME = "success";
    private static final String ISO_DATE = "2018-02-04";
    private static final String INSTANT_FORMATTED = String.format("%sT10:20:55Z", "2018-02-04");
    private static final Instant INSTANT = Instant.parse(INSTANT_FORMATTED);
    private static final Date INSTANT_DATE = Date.from(INSTANT);
    private static final long INSTANT_EPOCH_MILLIS = INSTANT.toEpochMilli();

    public TestRunner getRunner() {
        TestRunner runner = TestRunners.newTestRunner(QueryRecord.class);
        runner.setValidateExpressionUsage(false);
        return runner;
    }

    @Test
    public void testRecordPathFunctions() throws InitializationException {
        Record record = this.createHierarchicalRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT RPATH_STRING(person, '/name') AS name, RPATH_INT(person, '/age') AS age, RPATH(person, '/name') AS nameObj, RPATH(person, '/age') AS ageObj, RPATH(person, '/favoriteColors') AS colors, RPATH(person, '//name') AS names, RPATH_DATE(person, '/dob') AS dob, RPATH_LONG(person, '/dobTimestamp') AS dobTimestamp, RPATH_DATE(person, 'toDate(/joinTimestamp, \"yyyy-MM-dd\")') AS joinTime,  RPATH_DOUBLE(person, '/weight') AS weight FROM FLOWFILE");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List flowFilesOriginal = runner.getFlowFilesForRelationship(QueryRecord.REL_ORIGINAL);
        ((MockFlowFile)flowFilesOriginal.get(0)).assertAttributeEquals("QueryRecord.Route", QueryRecord.REL_ORIGINAL.getName());
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("nameObj"));
        Assertions.assertEquals((Object)30, (Object)output.getValue("age"));
        Assertions.assertEquals((Object)30, (Object)output.getValue("ageObj"));
        Assertions.assertArrayEquals((Object[])new String[]{"red", "green"}, (Object[])((Object[])output.getValue("colors")));
        Assertions.assertArrayEquals((Object[])new String[]{"John Doe", "Jane Doe"}, (Object[])((Object[])output.getValue("names")));
        LocalDate localDate = LocalDate.parse(ISO_DATE);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDate.atStartOfDay(), ZoneOffset.systemDefault());
        long epochMillis = zonedDateTime.toInstant().toEpochMilli();
        Assertions.assertEquals((Object)Long.toString(epochMillis), (Object)output.getAsString("joinTime"));
        Assertions.assertEquals((Double)180.8, (Double)output.getAsDouble("weight"));
    }

    @Test
    public void testRecordPathInAggregate() throws InitializationException {
        Record record = this.createHierarchicalRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        for (int i = 0; i < 100; ++i) {
            Record toAdd = this.createHierarchicalRecord();
            Record person = (Record)toAdd.getValue("person");
            person.setValue("name", (Object)("Person " + i));
            person.setValue("age", (Object)i);
            recordReader.addRecord(toAdd);
        }
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT RPATH_STRING(person, '/name') AS name FROM FLOWFILE WHERE RPATH_INT(person, '/age') > (   SELECT AVG( RPATH_INT(person, '/age') ) FROM FLOWFILE)");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)50, (int)written.size());
        int i = 50;
        for (Record writtenRecord : written) {
            String name = writtenRecord.getAsString("name");
            Assertions.assertEquals((Object)("Person " + i), (Object)name);
            ++i;
        }
    }

    @Test
    public void testRecordPathWithArray() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name    FROM FLOWFILE    WHERE RPATH(addresses, '/state[/label = ''home'']') <>          RPATH(addresses, '/state[/label = ''work'']')");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
    }

    @Test
    public void testCollectionFunctionsWithArray() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name, jobLevel    FROM FLOWFILE    WHERE CARDINALITY(addresses) > 1");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
        Assertions.assertEquals((Object)((Object)JobLevel.IC2), (Object)output.getValue("jobLevel"));
    }

    @Test
    public void testCollectionFunctionsWithoutCastFailure() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        Record record2 = this.createHierarchicalArrayRecord();
        record2.setValue("height", (Object)30);
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        recordReader.addRecord(record2);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name, sum(height) as height_total FROM FLOWFILE GROUP BY title, name");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
        Assertions.assertEquals((Object)new BigDecimal("90.500000000"), (Object)output.getValue("height_total"));
    }

    @Test
    public void testCollectionFunctionsWithCastChoice() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name, sum(CAST(height AS DOUBLE)) as height_total_double, sum(CAST(height AS REAL)) as height_total_float FROM FLOWFILE GROUP BY title, name");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Double height = 121.0;
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
        Assertions.assertEquals((Object)height, (Object)output.getValue("height_total_double"));
        Assertions.assertEquals((Object)Float.valueOf(((Number)height).floatValue()), (Object)output.getValue("height_total_float"));
    }

    @Test
    public void testCollectionFunctionsWithCastChoiceWithInts() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        record.setValue("height", (Object)30);
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name, sum(CAST(height AS INT)) as height_total_int, sum(CAST(height AS BIGINT)) as height_total_long FROM FLOWFILE GROUP BY title, name");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Integer height = 60;
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
        Assertions.assertEquals((Object)((Number)height).longValue(), (Object)output.getValue("height_total_long"));
        Assertions.assertEquals((Object)height, (Object)output.getValue("height_total_int"));
    }

    @Test
    public void testCollectionFunctionsWithWhereClause() throws InitializationException {
        Record sample = this.createTaggedRecord("1", "a", "b", "c");
        ArrayListRecordReader recordReader = new ArrayListRecordReader(sample.getSchema());
        recordReader.addRecord(this.createTaggedRecord("1", "a", "d", "g"));
        recordReader.addRecord(this.createTaggedRecord("2", "b", "e"));
        recordReader.addRecord(this.createTaggedRecord("3", "c", "f", "h"));
        ArrayListRecordWriter writer = new ArrayListRecordWriter(sample.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT id, tags FROM FLOWFILE CROSS JOIN UNNEST(FLOWFILE.tags) AS f(tag) WHERE tag IN ('a','b')");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)2, (int)written.size());
        Record output0 = (Record)written.get(0);
        Assertions.assertEquals((Object)"1", (Object)output0.getValue("id"));
        Assertions.assertArrayEquals((Object[])new Object[]{"a", "d", "g"}, (Object[])((Object[])output0.getValue("tags")));
        Record output1 = (Record)written.get(1);
        Assertions.assertEquals((Object)"2", (Object)output1.getValue("id"));
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "e"}, (Object[])((Object[])output1.getValue("tags")));
    }

    @Test
    public void testArrayColumnWithIndex() throws InitializationException {
        Record sample = this.createTaggedRecord("1", "a", "b", "c");
        ArrayListRecordReader recordReader = new ArrayListRecordReader(sample.getSchema());
        recordReader.addRecord(this.createTaggedRecord("1", "a", "d", "g"));
        recordReader.addRecord(this.createTaggedRecord("2", "b", "e"));
        recordReader.addRecord(this.createTaggedRecord("3", "c", "f", "h"));
        ArrayListRecordWriter writer = new ArrayListRecordWriter(sample.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT id, tags[1] as first, tags[2] as \"second\", tags[CARDINALITY(tags)] as last FROM FLOWFILE");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)3, (int)written.size());
        Record output0 = (Record)written.get(0);
        Assertions.assertEquals((Object)"1", (Object)output0.getValue("id"));
        Assertions.assertEquals((Object)"a", (Object)output0.getValue("first"));
        Assertions.assertEquals((Object)"d", (Object)output0.getValue("second"));
        Assertions.assertEquals((Object)"g", (Object)output0.getValue("last"));
        Record output1 = (Record)written.get(1);
        Assertions.assertEquals((Object)"2", (Object)output1.getValue("id"));
        Assertions.assertEquals((Object)"b", (Object)output1.getValue("first"));
        Assertions.assertEquals((Object)"e", (Object)output1.getValue("second"));
        Assertions.assertEquals((Object)"e", (Object)output1.getValue("last"));
        Record output2 = (Record)written.get(2);
        Assertions.assertEquals((Object)"3", (Object)output2.getValue("id"));
        Assertions.assertEquals((Object)"c", (Object)output2.getValue("first"));
        Assertions.assertEquals((Object)"f", (Object)output2.getValue("second"));
        Assertions.assertEquals((Object)"h", (Object)output2.getValue("last"));
    }

    @Test
    public void testCompareResultsOfTwoRecordPathsAgainstArray() throws InitializationException {
        Record[] addresses;
        Record record = this.createHierarchicalArrayRecord();
        for (Record address : addresses = (Record[])record.getValue("addresses")) {
            address.setValue("state", (Object)"NY");
        }
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name    FROM FLOWFILE    WHERE RPATH(addresses, '/state[/label = ''home'']') =          RPATH(addresses, '/state[/label = ''work'']')");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
    }

    @Test
    public void testRecordPathWithArrayAndOnlyOneElementMatchingRPath() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name    FROM FLOWFILE    WHERE RPATH(addresses, '/state[. = ''NY'']') = 'NY'");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
    }

    @Test
    public void testLikeWithRecordPath() throws InitializationException {
        Record record = this.createHierarchicalArrayRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT title, name    FROM FLOWFILE    WHERE RPATH_STRING(addresses, '/state[. = ''NY'']') LIKE 'N%'");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("name"));
        Assertions.assertEquals((Object)"Software Engineer", (Object)output.getValue("title"));
    }

    @Test
    public void testRecordPathWithMap() throws InitializationException {
        Record record = this.createHierarchicalRecord();
        ArrayListRecordReader recordReader = new ArrayListRecordReader(record.getSchema());
        recordReader.addRecord(record);
        ArrayListRecordWriter writer = new ArrayListRecordWriter(record.getSchema());
        TestRunner runner = this.getRunner();
        runner.addControllerService("reader", (ControllerService)recordReader);
        runner.enableControllerService((ControllerService)recordReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(REL_NAME, "SELECT RPATH(favoriteThings, '.[''sport'']') AS sport, RPATH_STRING(person, '/name') AS nameObj FROM FLOWFILE WHERE RPATH(favoriteThings, '.[''color'']') = 'green'");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
        List written = writer.getRecordsWritten();
        Assertions.assertEquals((int)1, (int)written.size());
        Record output = (Record)written.get(0);
        Assertions.assertEquals((Object)"basketball", (Object)output.getValue("sport"));
        Assertions.assertEquals((Object)"John Doe", (Object)output.getValue("nameObj"));
    }

    private Record createHierarchicalRecord() {
        ArrayList<RecordField> namedPersonFields = new ArrayList<RecordField>();
        namedPersonFields.add(new RecordField("name", RecordFieldType.STRING.getDataType()));
        SimpleRecordSchema namedPersonSchema = new SimpleRecordSchema(namedPersonFields);
        ArrayList<RecordField> personFields = new ArrayList<RecordField>();
        personFields.add(new RecordField("name", RecordFieldType.STRING.getDataType()));
        personFields.add(new RecordField("age", RecordFieldType.INT.getDataType()));
        personFields.add(new RecordField("favoriteColors", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType())));
        personFields.add(new RecordField("dob", RecordFieldType.DATE.getDataType()));
        personFields.add(new RecordField("dobTimestamp", RecordFieldType.LONG.getDataType()));
        personFields.add(new RecordField("joinTimestamp", RecordFieldType.STRING.getDataType()));
        personFields.add(new RecordField("weight", RecordFieldType.DOUBLE.getDataType()));
        personFields.add(new RecordField("height", RecordFieldType.CHOICE.getChoiceDataType(new DataType[]{RecordFieldType.LONG.getDataType(), RecordFieldType.INT.getDataType()})));
        personFields.add(new RecordField("mother", RecordFieldType.RECORD.getRecordDataType((RecordSchema)namedPersonSchema)));
        SimpleRecordSchema personSchema = new SimpleRecordSchema(personFields);
        ArrayList<RecordField> outerSchemaFields = new ArrayList<RecordField>();
        outerSchemaFields.add(new RecordField("person", RecordFieldType.RECORD.getRecordDataType((RecordSchema)personSchema)));
        outerSchemaFields.add(new RecordField("favoriteThings", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType())));
        SimpleRecordSchema recordSchema = new SimpleRecordSchema(outerSchemaFields);
        MapRecord mother = new MapRecord((RecordSchema)namedPersonSchema, Collections.singletonMap("name", "Jane Doe"));
        HashMap<String, String> favorites = new HashMap<String, String>();
        favorites.put("sport", "basketball");
        favorites.put("color", "green");
        favorites.put("roses", "raindrops");
        favorites.put("kittens", "whiskers");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "John Doe");
        map.put("age", 30);
        map.put("favoriteColors", new String[]{"red", "green"});
        map.put("dob", INSTANT_DATE);
        map.put("dobTimestamp", INSTANT_EPOCH_MILLIS);
        map.put("joinTimestamp", INSTANT_FORMATTED);
        map.put("weight", 180.8);
        map.put("height", 60.5);
        map.put("mother", mother);
        MapRecord person = new MapRecord((RecordSchema)personSchema, map);
        HashMap<String, Object> personValues = new HashMap<String, Object>();
        personValues.put("person", person);
        personValues.put("favoriteThings", favorites);
        return new MapRecord((RecordSchema)recordSchema, personValues);
    }

    private Record createTaggedRecord(String id, String ... tags) {
        ArrayList<RecordField> recordSchemaFields = new ArrayList<RecordField>();
        recordSchemaFields.add(new RecordField("id", RecordFieldType.STRING.getDataType()));
        recordSchemaFields.add(new RecordField("tags", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType())));
        SimpleRecordSchema recordSchema = new SimpleRecordSchema(recordSchemaFields);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("tags", Arrays.asList(tags));
        return new MapRecord((RecordSchema)recordSchema, map);
    }

    private Record createHierarchicalArrayRecord() {
        ArrayList<RecordField> addressFields = new ArrayList<RecordField>();
        addressFields.add(new RecordField("streetNumber", RecordFieldType.INT.getDataType()));
        addressFields.add(new RecordField("street", RecordFieldType.STRING.getDataType()));
        addressFields.add(new RecordField("apartment", RecordFieldType.INT.getDataType()));
        addressFields.add(new RecordField("city", RecordFieldType.STRING.getDataType()));
        addressFields.add(new RecordField("state", RecordFieldType.STRING.getDataType()));
        addressFields.add(new RecordField("country", RecordFieldType.STRING.getDataType()));
        addressFields.add(new RecordField("label", RecordFieldType.STRING.getDataType()));
        SimpleRecordSchema addressSchema = new SimpleRecordSchema(addressFields);
        ArrayList<RecordField> personFields = new ArrayList<RecordField>();
        personFields.add(new RecordField("name", RecordFieldType.STRING.getDataType()));
        personFields.add(new RecordField("age", RecordFieldType.INT.getDataType()));
        personFields.add(new RecordField("title", RecordFieldType.STRING.getDataType()));
        personFields.add(new RecordField("jobLevel", RecordFieldType.ENUM.getDataType()));
        personFields.add(new RecordField("height", RecordFieldType.CHOICE.getChoiceDataType(new DataType[]{RecordFieldType.DOUBLE.getDataType(), RecordFieldType.INT.getDataType()})));
        personFields.add(new RecordField("addresses", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.RECORD.getRecordDataType((RecordSchema)addressSchema))));
        SimpleRecordSchema personSchema = new SimpleRecordSchema(personFields);
        HashMap<String, Object> workMap = new HashMap<String, Object>();
        workMap.put("streetNumber", 4820);
        workMap.put("street", "My Street");
        workMap.put("apartment", null);
        workMap.put("city", "New York City");
        workMap.put("state", "NY");
        workMap.put("country", "USA");
        workMap.put("label", "work");
        MapRecord workAddress = new MapRecord((RecordSchema)addressSchema, workMap);
        HashMap<String, Object> homeMap = new HashMap<String, Object>();
        homeMap.put("streetNumber", 327);
        homeMap.put("street", "Small Street");
        homeMap.put("apartment", 302);
        homeMap.put("city", "Los Angeles");
        homeMap.put("state", "CA");
        homeMap.put("country", "USA");
        homeMap.put("label", "home");
        MapRecord homeAddress = new MapRecord((RecordSchema)addressSchema, homeMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "John Doe");
        map.put("age", 30);
        map.put("height", 60.5);
        map.put("title", "Software Engineer");
        map.put("jobLevel", (Object)JobLevel.IC2);
        map.put("addresses", new Record[]{homeAddress, workAddress});
        return new MapRecord((RecordSchema)personSchema, map);
    }

    @Test
    public void testStreamClosedWhenBadData() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.failAfter(0);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("age", RecordFieldType.INT);
        parser.addRecord(new Object[]{"Tom", 49});
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select name, age from FLOWFILE WHERE name <> ''");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(QueryRecord.REL_FAILURE, 1);
    }

    @Test
    public void testSimple() throws InitializationException {
        UUID tomId = UUID.randomUUID();
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("id", RecordFieldType.UUID);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("age", RecordFieldType.INT);
        parser.addRecord(new Object[]{tomId, "Tom", 49});
        MockRecordWriter writer = new MockRecordWriter("\"id\",\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select id, name, age from FLOWFILE WHERE name <> ''");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        boolean numIterations = true;
        for (int i = 0; i < 1; ++i) {
            runner.enqueue(new byte[0]);
        }
        runner.setThreadCount(4);
        runner.run(2);
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        out.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        out.assertContentEquals("\"id\",\"name\",\"points\"\n\"" + tomId + "\",\"Tom\",\"49\"\n");
    }

    @Test
    public void testNullable() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING, true);
        parser.addSchemaField("age", RecordFieldType.INT, true);
        parser.addRecord(new Object[]{"Tom", 49});
        parser.addRecord(new Object[]{"Alice", null});
        parser.addRecord(new Object[]{null, 36});
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select name, age from FLOWFILE");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        boolean numIterations = true;
        for (int i = 0; i < 1; ++i) {
            runner.enqueue(new byte[0]);
        }
        runner.setThreadCount(4);
        runner.run(2);
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        out.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        System.out.println(new String(out.toByteArray()));
        out.assertContentEquals("\"name\",\"points\"\n\"Tom\",\"49\"\n\"Alice\",\n,\"36\"\n");
    }

    @Test
    public void testParseFailure() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("age", RecordFieldType.INT);
        parser.addRecord(new Object[]{"Tom", 49});
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select name, age from FLOWFILE WHERE name <> ''");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        boolean numIterations = true;
        for (int i = 0; i < 1; ++i) {
            runner.enqueue(new byte[0]);
        }
        runner.setThreadCount(4);
        runner.run(2);
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        out.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        System.out.println(new String(out.toByteArray()));
        out.assertContentEquals("\"name\",\"points\"\n\"Tom\",\"49\"\n");
    }

    @Test
    public void testNoRecordsInput() throws InitializationException {
        TestRunner runner = this.getRunner();
        CSVReader csvReader = new CSVReader();
        runner.addControllerService("csv-reader", (ControllerService)csvReader);
        runner.setProperty((ControllerService)csvReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"age\"");
        runner.addControllerService("csv-reader", (ControllerService)csvReader);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)csvReader);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select name from FLOWFILE WHERE age > 23");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "csv-reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(QueryRecord.INCLUDE_ZERO_RECORD_FLOWFILES, "true");
        runner.enqueue("name,age\n");
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        out.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        System.out.println(new String(out.toByteArray()));
        out.assertContentEquals("\"name\",\"age\"\n");
    }

    @Test
    public void testTransformCalc() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("ID", RecordFieldType.INT);
        parser.addSchemaField("AMOUNT1", RecordFieldType.FLOAT);
        parser.addSchemaField("AMOUNT2", RecordFieldType.FLOAT);
        parser.addSchemaField("AMOUNT3", RecordFieldType.FLOAT);
        parser.addRecord(new Object[]{8, Float.valueOf(10.05f), Float.valueOf(15.45f), Float.valueOf(89.99f)});
        parser.addRecord(new Object[]{100, Float.valueOf(20.25f), Float.valueOf(25.25f), Float.valueOf(45.25f)});
        parser.addRecord(new Object[]{105, Float.valueOf(20.05f), Float.valueOf(25.05f), Float.valueOf(45.05f)});
        parser.addRecord(new Object[]{200, Float.valueOf(34.05f), Float.valueOf(25.05f), Float.valueOf(75.05f)});
        MockRecordWriter writer = new MockRecordWriter("\"NAME\",\"POINTS\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select ID, AMOUNT1+AMOUNT2+AMOUNT3 as TOTAL from FLOWFILE where ID=100");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue(new byte[0]);
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        out.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        out.assertContentEquals("\"NAME\",\"POINTS\"\n\"100\",\"90.75\"\n");
    }

    @Test
    public void testHandlingWithInvalidSchema() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("favorite_color", RecordFieldType.STRING);
        parser.addSchemaField("address", RecordFieldType.STRING);
        parser.addRecord(new Object[]{"Tom", "blue", null});
        parser.addRecord(new Object[]{"Jerry", "red", null});
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.enforceReadStreamsClosed(false);
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(QueryRecord.INCLUDE_ZERO_RECORD_FLOWFILES, "false");
        runner.setProperty("rel1", "select * from FLOWFILE where address IS NOT NULL");
        runner.setProperty("rel2", "select name, CAST(favorite_color AS DOUBLE) AS num from FLOWFILE");
        runner.setProperty("rel3", "select * from FLOWFILE where address IS NOT NULL");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(QueryRecord.REL_FAILURE, 1);
        List flowFiles = runner.getFlowFilesForRelationship(QueryRecord.REL_FAILURE);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", QueryRecord.REL_FAILURE.getName());
    }

    @Test
    public void testAggregateFunction() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("points", RecordFieldType.INT);
        parser.addRecord(new Object[]{"Tom", 1});
        parser.addRecord(new Object[]{"Jerry", 2});
        parser.addRecord(new Object[]{"Tom", 99});
        MockRecordWriter writer = new MockRecordWriter("\"name\",\"points\"");
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select name, sum(points) as points from FLOWFILE GROUP BY name");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile flowFileOut = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        flowFileOut.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        flowFileOut.assertContentEquals("\"name\",\"points\"\n\"Tom\",\"100\"\n\"Jerry\",\"2\"\n");
    }

    @Test
    public void testNullValueInSingleField() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("points", RecordFieldType.INT);
        parser.addRecord(new Object[]{"Tom", 1});
        parser.addRecord(new Object[]{"Jerry", null});
        parser.addRecord(new Object[]{"Tom", null});
        parser.addRecord(new Object[]{"Jerry", 3});
        MockRecordWriter writer = new MockRecordWriter(null, false);
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select points from FLOWFILE");
        runner.setProperty("count", "select count(*) as c from flowfile where points is null");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        runner.assertTransferCount("count", 1);
        MockFlowFile flowFileOut = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        flowFileOut.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        flowFileOut.assertContentEquals("1\n\n\n3\n");
        MockFlowFile countFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship("count").get(0);
        countFlowFile.assertAttributeEquals("QueryRecord.Route", "count");
        countFlowFile.assertContentEquals("2\n");
    }

    @Test
    public void testColumnNames() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("points", RecordFieldType.INT);
        parser.addSchemaField("greeting", RecordFieldType.STRING);
        parser.addRecord(new Object[]{"Tom", 1, "Hello"});
        parser.addRecord(new Object[]{"Jerry", 2, "Hi"});
        parser.addRecord(new Object[]{"Tom", 99, "Howdy"});
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add("name");
        colNames.add("points");
        colNames.add("greeting");
        colNames.add("FAV_GREETING");
        ResultSetValidatingRecordWriter writer = new ResultSetValidatingRecordWriter(colNames);
        TestRunner runner = this.getRunner();
        runner.addControllerService("parser", (ControllerService)parser);
        runner.enableControllerService((ControllerService)parser);
        runner.addControllerService("writer", (ControllerService)writer);
        runner.enableControllerService((ControllerService)writer);
        runner.setProperty(REL_NAME, "select *, greeting AS FAV_GREETING from FLOWFILE");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "parser");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        List flowFiles = runner.getFlowFilesForRelationship(REL_NAME);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("QueryRecord.Route", REL_NAME);
    }

    @Test
    public void testReturnsNoResultWithArrayColumn() throws InitializationException {
        TestRunner runner = this.getRunner();
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.setProperty(REL_NAME, "SELECT * from FLOWFILE WHERE status = 'failure'");
        runner.setProperty(QueryRecord.RECORD_READER_FACTORY, "reader");
        runner.setProperty(QueryRecord.RECORD_WRITER_FACTORY, "writer");
        runner.setProperty(QueryRecord.INCLUDE_ZERO_RECORD_FLOWFILES, "true");
        runner.enqueue("{\"status\": \"starting\",\"myArray\": [{\"foo\": \"foo\"}]}");
        runner.run();
        runner.assertTransferCount(REL_NAME, 1);
        MockFlowFile flowFileOut = (MockFlowFile)runner.getFlowFilesForRelationship(REL_NAME).get(0);
        flowFileOut.assertAttributeEquals("QueryRecord.Route", REL_NAME);
        flowFileOut.assertContentEquals("[]");
    }

    public static enum JobLevel {
        IC1,
        IC2,
        IC3;

    }

    private static class ResultSetValidatingRecordWriter
    extends AbstractControllerService
    implements RecordSetWriterFactory {
        private final List<String> columnNames;

        public ResultSetValidatingRecordWriter(List<String> colNames) {
            this.columnNames = new ArrayList<String>(colNames);
        }

        public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) {
            List recordFields = this.columnNames.stream().map(name -> new RecordField(name, RecordFieldType.STRING.getDataType())).collect(Collectors.toList());
            return new SimpleRecordSchema(recordFields);
        }

        public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, final OutputStream out, Map<String, String> variables) {
            return new RecordSetWriter(){

                public void flush() throws IOException {
                    out.flush();
                }

                public WriteResult write(RecordSet rs) throws IOException {
                    Record record;
                    int colCount = rs.getSchema().getFieldCount();
                    Assertions.assertEquals((int)columnNames.size(), (int)colCount);
                    ArrayList<String> colNames = new ArrayList<String>(colCount);
                    for (int i = 0; i < colCount; ++i) {
                        colNames.add(rs.getSchema().getField(i).getFieldName());
                    }
                    Assertions.assertEquals(columnNames, colNames);
                    while ((record = rs.next()) != null) {
                        System.out.println(record);
                    }
                    return WriteResult.of((int)0, Collections.emptyMap());
                }

                public String getMimeType() {
                    return "text/plain";
                }

                public WriteResult write(Record record) {
                    return null;
                }

                public void close() throws IOException {
                    out.close();
                }

                public void beginRecordSet() {
                }

                public WriteResult finishRecordSet() {
                    return WriteResult.EMPTY;
                }
            };
        }
    }
}

