/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.PutEmail;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestPutEmail {
    PutEmailExtension processor;
    TestRunner runner;

    @BeforeEach
    public void setup() {
        this.processor = new PutEmailExtension();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
    }

    @Test
    public void testExceptionWhenSending() {
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "host-doesnt-exist123");
        this.runner.setProperty(PutEmail.FROM, "test@apache.org");
        this.runner.setProperty(PutEmail.TO, "test@apache.org");
        this.runner.setProperty(PutEmail.MESSAGE, "Message Body");
        this.processor.setException(new MessagingException("Forced failure from send()"));
        HashMap attributes = new HashMap();
        this.runner.enqueue("Some Text".getBytes(), attributes);
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_FAILURE);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected an attempt to send a single message");
    }

    @Test
    public void testOutgoingMessage() throws Exception {
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "smtp-host");
        this.runner.setProperty(PutEmail.HEADER_XMAILER, "TestingNiFi");
        this.runner.setProperty(PutEmail.FROM, "test@apache.org");
        this.runner.setProperty(PutEmail.MESSAGE, "Message Body");
        this.runner.setProperty(PutEmail.TO, "recipient@apache.org");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, StandardCharsets.UTF_8.name());
        this.runner.enqueue("Some Text".getBytes());
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        Assertions.assertEquals((Object)"test@apache.org", (Object)message.getFrom()[0].toString());
        Assertions.assertEquals((Object)"TestingNiFi", (Object)message.getHeader("X-Mailer")[0], (String)"X-Mailer Header");
        Assertions.assertEquals((Object)"Message Body", (Object)this.getMessageText(message, StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"recipient@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.TO)[0].toString());
        Assertions.assertNull((Object)message.getRecipients(MimeMessage.RecipientType.BCC));
        Assertions.assertNull((Object)message.getRecipients(MimeMessage.RecipientType.CC));
    }

    @Test
    public void testOAuth() throws Exception {
        String oauthServiceID = "oauth-access-token-provider";
        String access_token = "access_token_123";
        OAuth2AccessTokenProvider oauthService = (OAuth2AccessTokenProvider)Mockito.mock(OAuth2AccessTokenProvider.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)oauthService.getIdentifier()).thenReturn((Object)oauthServiceID);
        Mockito.when((Object)oauthService.getAccessDetails().getAccessToken()).thenReturn((Object)access_token);
        this.runner.addControllerService(oauthServiceID, (ControllerService)oauthService);
        this.runner.enableControllerService((ControllerService)oauthService);
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "unimportant");
        this.runner.setProperty(PutEmail.FROM, "unimportant");
        this.runner.setProperty(PutEmail.TO, "unimportant");
        this.runner.setProperty(PutEmail.MESSAGE, "unimportant");
        this.runner.setProperty(PutEmail.AUTHORIZATION_MODE, PutEmail.OAUTH_AUTHORIZATION_MODE);
        this.runner.setProperty(PutEmail.OAUTH2_ACCESS_TOKEN_PROVIDER, oauthServiceID);
        this.runner.enqueue("Unimportant flowfile content".getBytes());
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        Assertions.assertEquals((Object)"XOAUTH2", (Object)message.getSession().getProperty("mail.smtp.auth.mechanisms"));
        Assertions.assertEquals((Object)"access_token_123", (Object)message.getSession().getProperty("mail.smtp.password"));
    }

    @Test
    public void testOutgoingMessageWithOptionalProperties() throws Exception {
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "smtp-host");
        this.runner.setProperty(PutEmail.HEADER_XMAILER, "TestingN\u00edFiNonASCII");
        this.runner.setProperty(PutEmail.FROM, "${from}");
        this.runner.setProperty(PutEmail.MESSAGE, "${message}");
        this.runner.setProperty(PutEmail.TO, "${to}");
        this.runner.setProperty(PutEmail.BCC, "${bcc}");
        this.runner.setProperty(PutEmail.CC, "${cc}");
        this.runner.setProperty(PutEmail.ATTRIBUTE_NAME_REGEX, "Precedence.*");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, StandardCharsets.UTF_8.name());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("from", "test@apache.org <NiFi>");
        attributes.put("message", "the message body");
        attributes.put("to", "to@apache.org");
        attributes.put("bcc", "bcc@apache.org");
        attributes.put("cc", "cc@apache.org");
        attributes.put("Precedence", "bulk");
        attributes.put("PrecedenceEncodeDecodeTest", "b\u00falk");
        this.runner.enqueue("Some Text".getBytes(), attributes);
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        Assertions.assertEquals((Object)"\"test@apache.org\" <NiFi>", (Object)message.getFrom()[0].toString());
        Assertions.assertEquals((Object)"TestingN\u00edFiNonASCII", (Object)MimeUtility.decodeText((String)message.getHeader("X-Mailer")[0]), (String)"X-Mailer Header");
        Assertions.assertEquals((Object)"the message body", (Object)this.getMessageText(message, StandardCharsets.UTF_8));
        Assertions.assertEquals((int)1, (int)message.getRecipients(MimeMessage.RecipientType.TO).length);
        Assertions.assertEquals((Object)"to@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.TO)[0].toString());
        Assertions.assertEquals((int)1, (int)message.getRecipients(MimeMessage.RecipientType.BCC).length);
        Assertions.assertEquals((Object)"bcc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.BCC)[0].toString());
        Assertions.assertEquals((int)1, (int)message.getRecipients(MimeMessage.RecipientType.CC).length);
        Assertions.assertEquals((Object)"cc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.CC)[0].toString());
        Assertions.assertEquals((Object)"bulk", (Object)MimeUtility.decodeText((String)message.getHeader("Precedence")[0]));
        Assertions.assertEquals((Object)"b\u00falk", (Object)MimeUtility.decodeText((String)message.getHeader("PrecedenceEncodeDecodeTest")[0]));
    }

    @Test
    public void testInvalidAddress() {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.FROM, "test@apache.org <invalid");
        this.runner.setProperty(PutEmail.MESSAGE, "Message Body");
        this.runner.enqueue("Some Text".getBytes());
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_FAILURE);
        Assertions.assertEquals((int)0, (int)this.processor.getMessages().size(), (String)"Expected no messages to be sent");
    }

    @Test
    public void testEmptyFrom() {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.FROM, "${MISSING_PROPERTY}");
        this.runner.setProperty(PutEmail.MESSAGE, "Message Body");
        this.runner.enqueue("Some Text".getBytes());
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_FAILURE);
        Assertions.assertEquals((int)0, (int)this.processor.getMessages().size(), (String)"Expected no messages to be sent");
        Assertions.assertFalse((boolean)this.runner.getLogger().getErrorMessages().isEmpty());
    }

    @Test
    public void testOutgoingMessageAttachment() throws Exception {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.MESSAGE, "Message Body");
        this.runner.setProperty(PutEmail.ATTACH_FILE, "true");
        this.runner.setProperty(PutEmail.CONTENT_TYPE, "text/html");
        this.runner.setProperty(PutEmail.TO, "recipient@apache.org");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, StandardCharsets.UTF_8.name());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), "test\ud55c\u7684\u307b\u0443\u0301.pdf");
        this.runner.enqueue("Some text".getBytes(), attributes);
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        Assertions.assertEquals((Object)"test@apache.org", (Object)message.getFrom()[0].toString());
        Assertions.assertEquals((Object)"TestingNiFi", (Object)message.getHeader("X-Mailer")[0], (String)"X-Mailer Header");
        Assertions.assertEquals((Object)"recipient@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.TO)[0].toString());
        Assertions.assertInstanceOf(MimeMultipart.class, (Object)message.getContent());
        MimeMultipart multipart = (MimeMultipart)message.getContent();
        Assertions.assertEquals((Object)"Message Body", (Object)this.getMessageText(message, StandardCharsets.UTF_8));
        BodyPart attachPart = multipart.getBodyPart(1);
        InputStream attachIs = attachPart.getDataHandler().getInputStream();
        String text = IOUtils.toString((InputStream)attachIs, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"test\ud55c\u7684\u307b\u0443\u0301.pdf", (Object)MimeUtility.decodeText((String)attachPart.getFileName()));
        Assertions.assertEquals((Object)"Some text", (Object)text);
        Assertions.assertNull((Object)message.getRecipients(MimeMessage.RecipientType.BCC));
        Assertions.assertNull((Object)message.getRecipients(MimeMessage.RecipientType.CC));
    }

    @Test
    public void testOutgoingMessageWithFlowfileContent() throws Exception {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.MESSAGE, "${body}");
        this.runner.setProperty(PutEmail.CC, "recipientcc@apache.org,anothercc@apache.org");
        this.runner.setProperty(PutEmail.BCC, "recipientbcc@apache.org,anotherbcc@apache.org");
        this.runner.setProperty(PutEmail.CONTENT_AS_MESSAGE, "${sendContent}");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, StandardCharsets.UTF_8.name());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("sendContent", "true");
        attributes.put("body", "Message Body");
        this.runner.enqueue("Some Text".getBytes(), attributes);
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        Assertions.assertEquals((Object)"test@apache.org", (Object)message.getFrom()[0].toString());
        Assertions.assertEquals((Object)"from@apache.org", (Object)message.getFrom()[1].toString());
        Assertions.assertEquals((Object)"TestingNiFi", (Object)message.getHeader("X-Mailer")[0], (String)"X-Mailer Header");
        Assertions.assertEquals((Object)"Some Text", (Object)this.getMessageText(message, StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"recipient@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.TO)[0].toString());
        Assertions.assertEquals((Object)"another@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.TO)[1].toString());
        Assertions.assertEquals((Object)"recipientcc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.CC)[0].toString());
        Assertions.assertEquals((Object)"anothercc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.CC)[1].toString());
        Assertions.assertEquals((Object)"recipientbcc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.BCC)[0].toString());
        Assertions.assertEquals((Object)"anotherbcc@apache.org", (Object)message.getRecipients(MimeMessage.RecipientType.BCC)[1].toString());
    }

    @Test
    public void testValidDynamicMailProperties() {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.MESSAGE, "${body}");
        this.runner.setProperty(PutEmail.CONTENT_AS_MESSAGE, "${sendContent}");
        this.runner.setProperty("mail.smtp.timeout", "sample dynamic smtp property");
        this.runner.setProperty("mail.smtps.timeout", "sample dynamic smtps property");
        this.runner.assertValid();
    }

    @Test
    public void testInvalidDynamicMailPropertyName() {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.MESSAGE, "${body}");
        this.runner.setProperty(PutEmail.CONTENT_AS_MESSAGE, "${sendContent}");
        this.runner.setProperty("mail.", "sample_value");
    }

    @Test
    public void testOverwritingDynamicMailProperty() {
        this.setRequiredProperties(this.runner);
        this.runner.setProperty(PutEmail.MESSAGE, "${body}");
        this.runner.setProperty(PutEmail.CONTENT_AS_MESSAGE, "${sendContent}");
        this.runner.setProperty("mail.smtp.user", "test-user-value");
        this.runner.assertNotValid();
    }

    @Test
    public void testUnrecognizedCharset() {
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "smtp-host");
        this.runner.setProperty(PutEmail.HEADER_XMAILER, "TestingNiFi");
        this.runner.setProperty(PutEmail.FROM, "test@apache.org");
        this.runner.setProperty(PutEmail.MESSAGE, "test message");
        this.runner.setProperty(PutEmail.TO, "recipient@apache.org");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, "NOT A CHARACTER SET");
        this.runner.assertNotValid();
    }

    @Test
    public void testPutEmailWithMismatchedCharset() throws Exception {
        String rawString = "Softw\u00c4r\u00eb \u00cbngin\u00eb\u00ebr \u00d6n NiFi";
        byte[] rawBytes = "Softw\u00c4r\u00eb \u00cbngin\u00eb\u00ebr \u00d6n NiFi".getBytes(StandardCharsets.US_ASCII);
        byte[] rawBytesUTF8 = "Softw\u00c4r\u00eb \u00cbngin\u00eb\u00ebr \u00d6n NiFi".getBytes(StandardCharsets.UTF_8);
        Assertions.assertNotEquals((Object)rawBytes, (Object)rawBytesUTF8);
        this.runner.setProperty(PutEmail.SMTP_HOSTNAME, "smtp-host");
        this.runner.setProperty(PutEmail.HEADER_XMAILER, "TestingNiFi");
        this.runner.setProperty(PutEmail.FROM, "test@apache.org");
        this.runner.setProperty(PutEmail.MESSAGE, new String(rawBytesUTF8, StandardCharsets.US_ASCII));
        this.runner.setProperty(PutEmail.TO, "recipient@apache.org");
        this.runner.setProperty(PutEmail.INPUT_CHARACTER_SET, StandardCharsets.UTF_8.name());
        this.runner.enqueue("Some Text".getBytes());
        this.runner.run();
        this.runner.assertQueueEmpty();
        this.runner.assertAllFlowFilesTransferred(PutEmail.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)this.processor.getMessages().size(), (String)"Expected a single message to be sent");
        Message message = this.processor.getMessages().get(0);
        String retrievedMessageText = this.getMessageText(message, StandardCharsets.UTF_8);
        Assertions.assertNotEquals((Object)"Softw\u00c4r\u00eb \u00cbngin\u00eb\u00ebr \u00d6n NiFi", (Object)retrievedMessageText);
    }

    private void setRequiredProperties(TestRunner runner) {
        runner.setProperty(PutEmail.SMTP_HOSTNAME, "smtp-host");
        runner.setProperty(PutEmail.HEADER_XMAILER, "TestingNiFi");
        runner.setProperty(PutEmail.FROM, "test@apache.org,from@apache.org");
        runner.setProperty(PutEmail.TO, "recipient@apache.org,another@apache.org");
    }

    private String getMessageText(Message message, Charset charset) throws Exception {
        if (message.getContent() instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)message.getContent();
            BodyPart part = multipart.getBodyPart(0);
            InputStream is = part.getDataHandler().getInputStream();
            String encoding = Charset.forName("US-ASCII").equals(charset) ? "7bit" : "base64";
            byte[] decodedTextBytes = "base64".equals(encoding) ? Base64.decodeBase64((byte[])IOUtils.toByteArray((InputStream)is)) : IOUtils.toByteArray((InputStream)is);
            String decodedText = StringUtils.newString((byte[])decodedTextBytes, (String)charset.name());
            return decodedText;
        }
        return (String)message.getContent();
    }

    private static final class PutEmailExtension
    extends PutEmail {
        private MessagingException e;
        private final ArrayList<Message> messages = new ArrayList();

        private PutEmailExtension() {
        }

        protected void send(Message msg) throws MessagingException {
            this.messages.add(msg);
            if (this.e != null) {
                throw this.e;
            }
        }

        void setException(MessagingException e) {
            this.e = e;
        }

        List<Message> getMessages() {
            return this.messages;
        }
    }
}

