/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.PackageFlowFile;
import org.apache.nifi.util.FlowFileUnpackagerV3;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPackageFlowFile {
    private static final String SAMPLE_CONTENT = "Hello, World!";
    private static final String SAMPLE_ATTR_FILENAME = "test.txt";
    private static final String SAMPLE_ATTR_MIME_TYPE = "text/plain";
    private static final String EXTRA_ATTR_KEY = "myAttribute";
    private static final String EXTRA_ATTR_VALUE = "my value";

    @Test
    public void testOne() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new PackageFlowFile());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), SAMPLE_ATTR_FILENAME);
        attributes.put(CoreAttributes.MIME_TYPE.key(), SAMPLE_ATTR_MIME_TYPE);
        attributes.put(EXTRA_ATTR_KEY, EXTRA_ATTR_VALUE);
        runner.enqueue(SAMPLE_CONTENT, attributes);
        runner.run();
        runner.assertTransferCount(PackageFlowFile.REL_SUCCESS, 1);
        runner.assertTransferCount(PackageFlowFile.REL_ORIGINAL, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(PackageFlowFile.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)StandardFlowFileMediaType.VERSION_3.getMediaType(), (Object)outputFlowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        FlowFileUnpackagerV3 unpackager = new FlowFileUnpackagerV3();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(outputFlowFile.toByteArray());
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Map unpackedAttributes = unpackager.unpackageFlowFile((InputStream)bais, (OutputStream)baos);
            Assertions.assertEquals((int)5, (int)unpackedAttributes.size());
            Assertions.assertNotNull(unpackedAttributes.get(CoreAttributes.UUID.key()));
            Assertions.assertNotNull(unpackedAttributes.get(CoreAttributes.PATH.key()));
            Assertions.assertEquals((Object)SAMPLE_ATTR_FILENAME, unpackedAttributes.get(CoreAttributes.FILENAME.key()));
            Assertions.assertEquals((Object)SAMPLE_ATTR_MIME_TYPE, unpackedAttributes.get(CoreAttributes.MIME_TYPE.key()));
            Assertions.assertEquals((Object)EXTRA_ATTR_VALUE, unpackedAttributes.get(EXTRA_ATTR_KEY));
            Assertions.assertArrayEquals((byte[])SAMPLE_CONTENT.getBytes(), (byte[])baos.toByteArray());
        }
    }

    @Test
    public void testMany() throws IOException {
        int FILE_COUNT = 10;
        TestRunner runner = TestRunners.newTestRunner((Processor)new PackageFlowFile());
        runner.setProperty(PackageFlowFile.BATCH_SIZE, Integer.toString(FILE_COUNT));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), SAMPLE_ATTR_MIME_TYPE);
        for (int i = 0; i < FILE_COUNT; ++i) {
            attributes.put(CoreAttributes.FILENAME.key(), i + SAMPLE_ATTR_FILENAME);
            runner.enqueue(SAMPLE_CONTENT, attributes);
        }
        runner.run();
        runner.assertTransferCount(PackageFlowFile.REL_SUCCESS, 1);
        runner.assertTransferCount(PackageFlowFile.REL_ORIGINAL, FILE_COUNT);
        MockFlowFile outputFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(PackageFlowFile.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)StandardFlowFileMediaType.VERSION_3.getMediaType(), (Object)outputFlowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        FlowFileUnpackagerV3 unpackager = new FlowFileUnpackagerV3();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(outputFlowFile.toByteArray());
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (int i = 0; i < FILE_COUNT; ++i) {
                Map unpackedAttributes = unpackager.unpackageFlowFile((InputStream)bais, (OutputStream)baos);
                Assertions.assertEquals((int)4, (int)unpackedAttributes.size());
                Assertions.assertNotNull(unpackedAttributes.get(CoreAttributes.UUID.key()));
                Assertions.assertNotNull(unpackedAttributes.get(CoreAttributes.PATH.key()));
                Assertions.assertEquals((Object)(i + SAMPLE_ATTR_FILENAME), unpackedAttributes.get(CoreAttributes.FILENAME.key()));
                Assertions.assertEquals((Object)SAMPLE_ATTR_MIME_TYPE, unpackedAttributes.get(CoreAttributes.MIME_TYPE.key()));
                Assertions.assertArrayEquals((byte[])SAMPLE_CONTENT.getBytes(), (byte[])baos.toByteArray());
                baos.reset();
            }
        }
    }

    @Test
    public void testBatchSize() throws IOException {
        int FILE_COUNT = 10;
        int BATCH_SIZE = 2;
        TestRunner runner = TestRunners.newTestRunner((Processor)new PackageFlowFile());
        runner.setProperty(PackageFlowFile.BATCH_SIZE, Integer.toString(BATCH_SIZE));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), SAMPLE_ATTR_MIME_TYPE);
        for (int i = 0; i < FILE_COUNT; ++i) {
            attributes.put(CoreAttributes.FILENAME.key(), i + SAMPLE_ATTR_FILENAME);
            runner.enqueue(SAMPLE_CONTENT, attributes);
        }
        runner.run();
        runner.assertTransferCount(PackageFlowFile.REL_SUCCESS, 1);
        runner.assertTransferCount(PackageFlowFile.REL_ORIGINAL, BATCH_SIZE);
        runner.assertQueueNotEmpty();
    }
}

