/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.event.transport.EventSender;
import org.apache.nifi.event.transport.configuration.ShutdownQuietPeriod;
import org.apache.nifi.event.transport.configuration.ShutdownTimeout;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.ByteArrayNettyEventSenderFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.ListenerProperties;
import org.apache.nifi.processors.standard.ListenTCP;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.web.util.ssl.SslContextUtils;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestListenTCP {
    private static final String CLIENT_CERTIFICATE_SUBJECT_DN_ATTRIBUTE = "client.certificate.subject.dn";
    private static final String CLIENT_CERTIFICATE_ISSUER_DN_ATTRIBUTE = "client.certificate.issuer.dn";
    private static final String SSL_CONTEXT_IDENTIFIER = SSLContextService.class.getName();
    private static final String LOCALHOST = "localhost";
    private static final Duration SENDER_TIMEOUT = Duration.ofSeconds(10L);
    private static SSLContext keyStoreSslContext;
    private static SSLContext trustStoreSslContext;
    private TestRunner runner;

    @BeforeAll
    public static void configureServices() throws TlsException {
        keyStoreSslContext = SslContextUtils.createKeyStoreSslContext();
        trustStoreSslContext = SslContextUtils.createTrustStoreSslContext();
    }

    @BeforeEach
    public void setup() {
        this.runner = TestRunners.newTestRunner(ListenTCP.class);
    }

    @Test
    public void testCustomValidate() throws Exception {
        this.runner.setProperty(ListenerProperties.PORT, "1");
        this.runner.assertValid();
        this.enableSslContextService(keyStoreSslContext);
        this.runner.setProperty(ListenTCP.CLIENT_AUTH, "");
        this.runner.assertNotValid();
        this.runner.setProperty(ListenTCP.CLIENT_AUTH, ClientAuth.REQUIRED.name());
        this.runner.assertValid();
    }

    @Test
    public void testRun() throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("This is message 1\n");
        messages.add("This is message 2\n");
        messages.add("This is message 3\n");
        messages.add("This is message 4\n");
        messages.add("This is message 5\n");
        this.run(messages, messages.size(), null);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenTCP.REL_SUCCESS);
        for (int i = 0; i < mockFlowFiles.size(); ++i) {
            ((MockFlowFile)mockFlowFiles.get(i)).assertContentEquals("This is message " + (i + 1));
        }
    }

    @Test
    public void testRunBatching() throws Exception {
        this.runner.setProperty(ListenerProperties.MAX_BATCH_SIZE, "3");
        this.runner.setProperty(ListenTCP.POOL_RECV_BUFFERS, "False");
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("This is message 1\n");
        messages.add("This is message 2\n");
        messages.add("This is message 3\n");
        messages.add("This is message 4\n");
        messages.add("This is message 5\n");
        this.run(messages, 2, null);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenTCP.REL_SUCCESS);
        MockFlowFile mockFlowFile1 = (MockFlowFile)mockFlowFiles.get(0);
        mockFlowFile1.assertContentEquals("This is message 1\nThis is message 2\nThis is message 3");
        MockFlowFile mockFlowFile2 = (MockFlowFile)mockFlowFiles.get(1);
        mockFlowFile2.assertContentEquals("This is message 4\nThis is message 5");
    }

    @Test
    public void testRunClientAuthRequired() throws Exception {
        String expectedDistinguishedName = "CN=localhost";
        this.runner.setProperty(ListenTCP.CLIENT_AUTH, ClientAuth.REQUIRED.name());
        this.enableSslContextService(keyStoreSslContext);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("This is message 1\n");
        messages.add("This is message 2\n");
        messages.add("This is message 3\n");
        messages.add("This is message 4\n");
        messages.add("This is message 5\n");
        this.run(messages, messages.size(), keyStoreSslContext);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenTCP.REL_SUCCESS);
        for (int i = 0; i < mockFlowFiles.size(); ++i) {
            ((MockFlowFile)mockFlowFiles.get(i)).assertContentEquals("This is message " + (i + 1));
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeExists(CLIENT_CERTIFICATE_SUBJECT_DN_ATTRIBUTE);
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeExists(CLIENT_CERTIFICATE_ISSUER_DN_ATTRIBUTE);
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeEquals(CLIENT_CERTIFICATE_SUBJECT_DN_ATTRIBUTE, "CN=localhost");
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeEquals(CLIENT_CERTIFICATE_ISSUER_DN_ATTRIBUTE, "CN=localhost");
        }
    }

    @Test
    public void testRunClientAuthNone() throws Exception {
        this.runner.setProperty(ListenTCP.CLIENT_AUTH, ClientAuth.NONE.name());
        this.enableSslContextService(keyStoreSslContext);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("This is message 1\n");
        messages.add("This is message 2\n");
        messages.add("This is message 3\n");
        messages.add("This is message 4\n");
        messages.add("This is message 5\n");
        this.run(messages, messages.size(), trustStoreSslContext);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenTCP.REL_SUCCESS);
        for (int i = 0; i < mockFlowFiles.size(); ++i) {
            ((MockFlowFile)mockFlowFiles.get(i)).assertContentEquals("This is message " + (i + 1));
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeNotExists(CLIENT_CERTIFICATE_SUBJECT_DN_ATTRIBUTE);
            ((MockFlowFile)mockFlowFiles.get(i)).assertAttributeNotExists(CLIENT_CERTIFICATE_ISSUER_DN_ATTRIBUTE);
        }
    }

    private void run(List<String> messages, int flowFiles, SSLContext sslContext) throws Exception {
        this.runner.setProperty(ListenerProperties.PORT, "0");
        String message = StringUtils.join(messages, null);
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        this.runner.run(1, false, true);
        int port = ((ListenTCP)this.runner.getProcessor()).getListeningPort();
        this.sendMessages(port, bytes, sslContext);
        this.runner.run(flowFiles, false, false);
    }

    private void enableSslContextService(SSLContext sslContext) throws InitializationException {
        RestrictedSSLContextService sslContextService = (RestrictedSSLContextService)Mockito.mock(RestrictedSSLContextService.class);
        Mockito.when((Object)sslContextService.getIdentifier()).thenReturn((Object)SSL_CONTEXT_IDENTIFIER);
        Mockito.when((Object)sslContextService.createContext()).thenReturn((Object)sslContext);
        this.runner.addControllerService(SSL_CONTEXT_IDENTIFIER, (ControllerService)sslContextService);
        this.runner.enableControllerService((ControllerService)sslContextService);
        this.runner.setProperty(ListenTCP.SSL_CONTEXT_SERVICE, SSL_CONTEXT_IDENTIFIER);
    }

    private void sendMessages(int port, byte[] messages, SSLContext sslContext) throws Exception {
        ByteArrayNettyEventSenderFactory eventSenderFactory = new ByteArrayNettyEventSenderFactory((ComponentLog)this.runner.getLogger(), LOCALHOST, port, TransportProtocol.TCP);
        eventSenderFactory.setShutdownQuietPeriod(ShutdownQuietPeriod.QUICK.getDuration());
        eventSenderFactory.setShutdownTimeout(ShutdownTimeout.QUICK.getDuration());
        if (sslContext != null) {
            eventSenderFactory.setSslContext(sslContext);
        }
        eventSenderFactory.setTimeout(SENDER_TIMEOUT);
        try (EventSender eventSender = eventSenderFactory.getEventSender();){
            eventSender.sendEvent((Object)messages);
        }
    }
}

