/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.DeleteSFTP;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.processors.standard.util.SSHTestServer;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestDeleteSFTP {
    private static final int BATCH_SIZE = 2;
    private final TestRunner runner = TestRunners.newTestRunner(DeleteSFTP.class);
    private final SSHTestServer sshTestServer = new SSHTestServer();
    private Path sshServerRootPath;

    TestDeleteSFTP() {
    }

    @BeforeEach
    void setRunner() throws IOException {
        this.sshTestServer.startServer();
        this.sshServerRootPath = Paths.get(this.sshTestServer.getVirtualFileSystemPath(), new String[0]).toAbsolutePath();
        this.runner.setProperty(SFTPTransfer.HOSTNAME, this.sshTestServer.getHost());
        this.runner.setProperty(SFTPTransfer.PORT, Integer.toString(this.sshTestServer.getSSHPort()));
        this.runner.setProperty(SFTPTransfer.USERNAME, this.sshTestServer.getUsername());
        this.runner.setProperty(SFTPTransfer.PASSWORD, this.sshTestServer.getPassword());
        this.runner.setProperty(SFTPTransfer.BATCH_SIZE, Integer.toString(2));
    }

    @AfterEach
    void clearDirectory() throws IOException {
        this.sshTestServer.stopServer();
        FileUtils.deleteQuietly((File)this.sshServerRootPath.toFile());
    }

    @Test
    void deletesExistingFile() throws IOException {
        Path fileToDelete = this.createFile("rel/path", "test.txt");
        MockFlowFile enqueuedFlowFile = this.enqueue(fileToDelete);
        TestDeleteSFTP.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteSFTP.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteSFTP.REL_SUCCESS, 1);
        this.runner.assertAllFlowFiles(DeleteSFTP.REL_SUCCESS, flowFileInRelationship -> Assertions.assertEquals((Object)enqueuedFlowFile, (Object)flowFileInRelationship));
        this.runner.assertProvenanceEvent(ProvenanceEventType.REMOTE_INVOCATION);
    }

    @Test
    void sendsFlowFileToNotFoundWhenFileDoesNotExist() throws IOException {
        Path directoryPath = Files.createDirectories(this.sshServerRootPath.resolve("rel/path"), new FileAttribute[0]);
        String filename = "not-exist.txt";
        Path fileToDelete = directoryPath.resolve("not-exist.txt");
        this.enqueue(fileToDelete);
        TestDeleteSFTP.assertNotExists(fileToDelete);
        this.runner.run();
        TestDeleteSFTP.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteSFTP.REL_NOT_FOUND);
    }

    @Test
    void sendsFlowFileToNotFoundWhenDirectoryDoesNotExist() {
        Path directoryPath = this.sshServerRootPath.resolve("rel/path");
        String filename = "not-exist.txt";
        Path fileToDelete = directoryPath.resolve("not-exist.txt");
        this.enqueue(fileToDelete);
        TestDeleteSFTP.assertNotExists(fileToDelete);
        this.runner.run();
        TestDeleteSFTP.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteSFTP.REL_NOT_FOUND);
    }

    @Test
    void sendsFlowFileToFailureWhenTargetIsADirectory() throws IOException {
        Path fileToDelete = Files.createDirectories(this.sshServerRootPath.resolve("a/directory"), new FileAttribute[0]);
        this.enqueue(fileToDelete);
        TestDeleteSFTP.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteSFTP.assertExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteSFTP.REL_FAILURE);
        this.runner.assertPenalizeCount(1);
    }

    @Test
    void sendsFlowFileToFailureWhenFileIsNotADirectChildOfTheDirectory() throws IOException {
        Path directoryPath = Files.createDirectories(this.sshServerRootPath.resolve("rel/path"), new FileAttribute[0]);
        String filename = "../sibling.txt";
        this.enqueue(directoryPath.toString(), "../sibling.txt");
        Path fileToDelete = Files.write(directoryPath.resolve("../sibling.txt"), "sibling content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        TestDeleteSFTP.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteSFTP.assertExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteSFTP.REL_FAILURE, 1);
        this.runner.assertPenalizeCount(1);
    }

    @Test
    void deletesUpToBatchSizeFilesWithASingleConnection() throws IOException {
        for (int fileNumber = 1; fileNumber <= 4; ++fileNumber) {
            Path fileToDelete = this.createFile("a/directory", String.format("file-%d", fileNumber));
            this.enqueue(fileToDelete);
            TestDeleteSFTP.assertExists(fileToDelete);
        }
        this.runner.run();
        this.runner.assertTransferCount(DeleteSFTP.REL_SUCCESS, 2);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertTransferCount(DeleteSFTP.REL_SUCCESS, 2);
        this.runner.assertQueueEmpty();
    }

    private Path createFile(String directoryPath, String filename) throws IOException {
        Path directory = Files.createDirectories(this.sshServerRootPath.resolve(directoryPath), new FileAttribute[0]);
        return Files.write(directory.resolve(filename), "some text".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private MockFlowFile enqueue(Path path) {
        Path relativePath = this.sshServerRootPath.relativize(path);
        return this.enqueue(String.format("/%s", relativePath.getParent()), relativePath.getFileName().toString());
    }

    private MockFlowFile enqueue(String directoryPath, String filename) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.PATH.key(), directoryPath);
        attributes.put(CoreAttributes.FILENAME.key(), filename);
        return this.runner.enqueue("data", attributes);
    }

    private static void assertNotExists(Path filePath) {
        Assertions.assertTrue((boolean)Files.notExists(filePath, new LinkOption[0]), () -> "File " + filePath + "still exists");
    }

    private static void assertExists(Path filePath) {
        Assertions.assertTrue((boolean)Files.exists(filePath, new LinkOption[0]), () -> "File " + filePath + "does not exist");
    }
}

