/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processors.standard.DeduplicateRecord;
import org.apache.nifi.processors.standard.MockCacheService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDeduplicateRecord {
    private TestRunner runner;
    private MockRecordParser reader;
    private MockRecordWriter writer;
    public static final String FIRST_KEY = String.join((CharSequence)String.valueOf('~'), Arrays.asList("John", "Q", "Smith"));
    public static final String SECOND_KEY = String.join((CharSequence)String.valueOf('~'), Arrays.asList("Jack", "Z", "Brown"));
    public static final String FIRST_KEY_HASHED = DigestUtils.sha256Hex((String)FIRST_KEY);
    public static final String SECOND_KEY_HASHED = DigestUtils.sha256Hex((String)SECOND_KEY);

    @BeforeEach
    public void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(DeduplicateRecord.class);
        this.reader = new MockRecordParser();
        this.writer = new MockRecordWriter("header", false);
        this.runner.addControllerService("reader", (ControllerService)this.reader);
        this.runner.enableControllerService((ControllerService)this.reader);
        this.runner.addControllerService("writer", (ControllerService)this.writer);
        this.runner.enableControllerService((ControllerService)this.writer);
        this.runner.setProperty(DeduplicateRecord.RECORD_READER, "reader");
        this.runner.setProperty(DeduplicateRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(DeduplicateRecord.RECORD_HASHING_ALGORITHM, DeduplicateRecord.SHA256_ALGORITHM_VALUE);
        this.reader.addSchemaField("firstName", RecordFieldType.STRING);
        this.reader.addSchemaField("middleName", RecordFieldType.STRING);
        this.reader.addSchemaField("lastName", RecordFieldType.STRING);
        this.runner.setProperty(DeduplicateRecord.INCLUDE_ZERO_RECORD_FLOWFILES, "true");
        this.runner.assertValid();
    }

    void commonEnqueue() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hash.value", "1000");
        this.runner.enqueue(new byte[0], props);
    }

    @Test
    public void testInvalidRecordPathCausesValidationError() {
        this.runner.setProperty(DeduplicateRecord.FILTER_TYPE, DeduplicateRecord.HASH_SET_VALUE);
        this.runner.setProperty("middle_name", "//////middleName");
        this.runner.assertNotValid();
    }

    @Test
    public void testDetectDuplicatesHashSet() {
        this.commonEnqueue();
        this.runner.setProperty(DeduplicateRecord.FILTER_TYPE, DeduplicateRecord.HASH_SET_VALUE);
        this.runner.setProperty("middle_name", "/middleName");
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 2, 1);
    }

    @Test
    public void testDetectDuplicatesBloomFilter() {
        this.commonEnqueue();
        this.runner.setProperty(DeduplicateRecord.FILTER_TYPE, DeduplicateRecord.BLOOM_FILTER_VALUE);
        this.runner.setProperty(DeduplicateRecord.BLOOM_FILTER_FPP, "0.10");
        this.runner.setProperty("middle_name", "/middleName");
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 2, 1);
    }

    @Test
    public void testNoDuplicatesHashSet() {
        this.commonEnqueue();
        this.runner.setProperty(DeduplicateRecord.FILTER_TYPE, DeduplicateRecord.HASH_SET_VALUE);
        this.runner.setProperty("middle_name", "/middleName");
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 0);
    }

    @Test
    public void testNoDuplicatesBloomFilter() {
        this.commonEnqueue();
        this.runner.setProperty(DeduplicateRecord.FILTER_TYPE, DeduplicateRecord.BLOOM_FILTER_VALUE);
        this.runner.setProperty(DeduplicateRecord.BLOOM_FILTER_FPP, "0.10");
        this.runner.setProperty("middle_name", "/middleName");
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 0);
    }

    @Test
    public void testAllDuplicates() {
        this.commonEnqueue();
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 1, 2);
    }

    @Test
    public void testAllUnique() {
        this.commonEnqueue();
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 0);
    }

    @Test
    public void testCacheValueFromRecordPath() {
        this.commonEnqueue();
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 2, 1);
    }

    @Test
    public void testMultipleFileDeduplicationRequiresDMC() {
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.assertNotValid();
    }

    @Test
    public void testDeduplicateWithDMCNoPutIdentifier() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        dmc.put(FIRST_KEY_HASHED, true, null, null);
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 1);
    }

    @Test
    public void testDeduplicateWithDMCPutIdentifier() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.PUT_CACHE_IDENTIFIER, "true");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        dmc.put(FIRST_KEY_HASHED, true, null, null);
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 2, 2);
    }

    @Test
    public void testDeduplicateWithDMCAndOneRecordPath() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.PUT_CACHE_IDENTIFIER, "true");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.setProperty("first_name", "/firstName");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 1);
    }

    @Test
    public void testDeduplicateWithDMCAndMultipleRecordPaths() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.PUT_CACHE_IDENTIFIER, "true");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.setProperty("first_name", "/firstName");
        this.runner.setProperty("middle_name", "/middleName");
        this.runner.setProperty("invalid_property", "/missingProperty");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 1);
    }

    @Test
    public void testDeduplicateWithDMCAndNullField() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.PUT_CACHE_IDENTIFIER, "true");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.setProperty("middle_name", "/middleName");
        this.runner.setProperty("last_name", "/lastName");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        this.reader.addRecord(new Object[]{"Jack", "Z", null});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "R", "Brown"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 3, 0);
    }

    @Test
    public void testDeduplicateNoHashing() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.setProperty(DeduplicateRecord.RECORD_HASHING_ALGORITHM, DeduplicateRecord.NONE_ALGORITHM_VALUE);
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        dmc.put(FIRST_KEY, true, null, null);
        dmc.put(SECOND_KEY, true, null, null);
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        this.runner.enqueue("");
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 1, 3);
    }

    @Test
    public void testDeduplicateWithDMCAndCacheIdentifier() throws Exception {
        MockCacheService dmc = new MockCacheService();
        this.runner.addControllerService("dmc", (ControllerService)dmc);
        this.runner.setProperty(DeduplicateRecord.DISTRIBUTED_MAP_CACHE, "dmc");
        this.runner.setProperty(DeduplicateRecord.DEDUPLICATION_STRATEGY, DeduplicateRecord.OPTION_MULTIPLE_FILES.getValue());
        this.runner.setProperty(DeduplicateRecord.CACHE_IDENTIFIER, "${user.name}-${record.hash.value}");
        this.runner.setProperty(DeduplicateRecord.PUT_CACHE_IDENTIFIER, "true");
        this.runner.enableControllerService((ControllerService)dmc);
        this.runner.assertValid();
        dmc.put(String.format("john.smith-%s", FIRST_KEY_HASHED), true, null, null);
        dmc.put(String.format("john.smith-%s", SECOND_KEY_HASHED), true, null, null);
        this.reader.addRecord(new Object[]{"John", "Q", "Smith"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jack", "Z", "Brown"});
        this.reader.addRecord(new Object[]{"Jane", "X", "Doe"});
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("user.name", "john.smith");
        this.runner.enqueue("", attrs);
        this.runner.run();
        this.doCountTests(0, 1, 1, 1, 1, 3);
    }

    void doCountTests(int failure, int original, int duplicates, int notDuplicates, int notDupeCount, int dupeCount) {
        List nonDuplicateFlowFile;
        this.runner.assertTransferCount(DeduplicateRecord.REL_FAILURE, failure);
        this.runner.assertTransferCount(DeduplicateRecord.REL_ORIGINAL, original);
        this.runner.assertTransferCount(DeduplicateRecord.REL_DUPLICATE, duplicates);
        this.runner.assertTransferCount(DeduplicateRecord.REL_NON_DUPLICATE, notDuplicates);
        List duplicateFlowFile = this.runner.getFlowFilesForRelationship(DeduplicateRecord.REL_DUPLICATE);
        if (duplicateFlowFile != null) {
            Assertions.assertEquals((Object)String.valueOf(dupeCount), (Object)((MockFlowFile)duplicateFlowFile.get(0)).getAttribute("record.count"));
        }
        if ((nonDuplicateFlowFile = this.runner.getFlowFilesForRelationship(DeduplicateRecord.REL_NON_DUPLICATE)) != null) {
            Assertions.assertEquals((Object)String.valueOf(notDupeCount), (Object)((MockFlowFile)nonDuplicateFlowFile.get(0)).getAttribute("record.count"));
        }
    }
}

