/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.AttributesToJSON;
import org.apache.nifi.util.LogMessage;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestAttributesToJSON {
    private static final String TEST_ATTRIBUTE_KEY = "TestAttribute";
    private static final String TEST_ATTRIBUTE_VALUE = "TestValue";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testInvalidUserSuppliedAttributeList() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        Assertions.assertThrows(AssertionError.class, () -> testRunner.run());
    }

    @Test
    public void testInvalidIncludeCoreAttributesProperty() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "val1,val2");
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "maybe");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        Assertions.assertThrows(AssertionError.class, () -> testRunner.run());
    }

    @Test
    public void testNullValueForEmptyAttribute() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        String NON_PRESENT_ATTRIBUTE_KEY = "NonExistingAttributeKey";
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "NonExistingAttributeKey");
        testRunner.setProperty(AttributesToJSON.NULL_VALUE_FOR_EMPTY_STRING, "true");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertNull(val.get("NonExistingAttributeKey"));
    }

    @Test
    public void testEmptyStringValueForEmptyAttribute() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        String NON_PRESENT_ATTRIBUTE_KEY = "NonExistingAttributeKey";
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "NonExistingAttributeKey");
        testRunner.setProperty(AttributesToJSON.NULL_VALUE_FOR_EMPTY_STRING, "false");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertEquals(val.get("NonExistingAttributeKey"), (Object)"");
    }

    @Test
    public void testInvalidJSONValueInAttribute() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, "'badjson'");
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
    }

    @Test
    public void testAttributes_emptyListUserSpecifiedAttributes() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertTrue((boolean)((String)val.get(TEST_ATTRIBUTE_KEY)).equals(TEST_ATTRIBUTE_VALUE));
    }

    @Test
    public void testContent_emptyListUserSpecifiedAttributes() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "false");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeNotExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertContentEquals("{}");
    }

    @Test
    public void testAttribute_singleUserDefinedAttribute() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, TEST_ATTRIBUTE_KEY);
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertTrue((boolean)((String)val.get(TEST_ATTRIBUTE_KEY)).equals(TEST_ATTRIBUTE_VALUE));
        Assertions.assertTrue((val.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttribute_singleUserDefinedAttributeWithWhiteSpace() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, " TestAttribute ");
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertTrue((boolean)((String)val.get(TEST_ATTRIBUTE_KEY)).equals(TEST_ATTRIBUTE_VALUE));
        Assertions.assertTrue((val.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttribute_singleNonExistingUserDefinedAttribute() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "NonExistingAttribute");
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertTrue((boolean)((String)val.get("NonExistingAttribute")).equals(""));
        Assertions.assertTrue((val.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttribute_noIncludeCoreAttributesUserDefined() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, " TestAttribute , " + CoreAttributes.PATH.key() + " ");
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "false");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        ff = session.putAttribute(ff, CoreAttributes.PATH.key(), TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertEquals((Object)TEST_ATTRIBUTE_VALUE, val.get(TEST_ATTRIBUTE_KEY));
        Assertions.assertEquals((Object)TEST_ATTRIBUTE_VALUE, val.get(CoreAttributes.PATH.key()));
        Assertions.assertEquals((int)2, (int)val.size());
    }

    @Test
    public void testAttribute_noIncludeCoreAttributesRegex() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_REGEX, CoreAttributes.PATH.key() + ".*");
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "false");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        ff = session.putAttribute(ff, CoreAttributes.PATH.key(), TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, HashMap.class);
        Assertions.assertEquals((Object)TEST_ATTRIBUTE_VALUE, val.get(CoreAttributes.PATH.key()));
        Assertions.assertEquals((int)1, (int)val.size());
    }

    @Test
    public void testAttribute_noIncludeCoreAttributesContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, TEST_ATTRIBUTE_VALUE);
        ff = session.putAttribute(ff, CoreAttributes.PATH.key(), TEST_ATTRIBUTE_VALUE);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        Map val = (Map)MAPPER.readValue(((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).toByteArray(), HashMap.class);
        Assertions.assertEquals((Object)TEST_ATTRIBUTE_VALUE, val.get(TEST_ATTRIBUTE_KEY));
        Assertions.assertEquals((int)1, (int)val.size());
    }

    @Test
    public void testAttribute_includeCoreAttributesContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "true");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertEquals((Object)"application/json", (Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        Map val = (Map)MAPPER.readValue(flowFile.toByteArray(), HashMap.class);
        Assertions.assertEquals((int)3, (int)val.size());
        Set coreAttributes = Arrays.stream(CoreAttributes.values()).map(CoreAttributes::key).collect(Collectors.toSet());
        val.keySet().forEach(k -> Assertions.assertTrue((boolean)coreAttributes.contains(k)));
    }

    @Test
    public void testAttribute_includeCoreAttributesAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.INCLUDE_CORE_ATTRIBUTES, "true");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        Map val = (Map)MAPPER.readValue(flowFile.getAttribute("JSONAttributes"), HashMap.class);
        Assertions.assertEquals((int)3, (int)val.size());
        Set coreAttributes = Arrays.stream(CoreAttributes.values()).map(CoreAttributes::key).collect(Collectors.toSet());
        val.keySet().forEach(k -> Assertions.assertTrue((boolean)coreAttributes.contains(k)));
    }

    @Test
    public void testAttributesRegex() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setVariable("regex", "delimited\\.header\\.column\\.[0-9]+");
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_REGEX, "${regex}");
        testRunner.setProperty(AttributesToJSON.ATTRIBUTES_LIST, "test, test1");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("delimited.header.column.1", "Registry");
        attributes.put("delimited.header.column.2", "Assignment");
        attributes.put("delimited.header.column.3", "Organization Name");
        attributes.put("delimited.header.column.4", "Organization Address");
        attributes.put("delimited.footer.column.1", "not included");
        attributes.put("test", "test");
        attributes.put("test1", "test1");
        testRunner.enqueue("".getBytes(), attributes);
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0);
        Map val = (Map)MAPPER.readValue(flowFile.getAttribute("JSONAttributes"), HashMap.class);
        Assertions.assertTrue((boolean)val.keySet().contains("delimited.header.column.1"));
        Assertions.assertTrue((boolean)val.keySet().contains("delimited.header.column.2"));
        Assertions.assertTrue((boolean)val.keySet().contains("delimited.header.column.3"));
        Assertions.assertTrue((boolean)val.keySet().contains("delimited.header.column.4"));
        Assertions.assertTrue((!val.keySet().contains("delimited.footer.column.1") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)val.keySet().contains("test"));
        Assertions.assertTrue((boolean)val.keySet().contains("test1"));
    }

    @ParameterizedTest
    @MethodSource(value={"getNestedJson"})
    public void testAttributeWithNestedJsonOutputAsJsonInContent(String nestedJson, Class<?> expectedClass) throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        testRunner.setProperty(AttributesToJSON.JSON_HANDLING_STRATEGY, AttributesToJSON.JsonHandlingStrategy.NESTED.getValue());
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, nestedJson);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertEquals((Object)"application/json", (Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        Map val = (Map)MAPPER.readValue(flowFile.toByteArray(), Map.class);
        Assertions.assertInstanceOf(expectedClass, val.get(TEST_ATTRIBUTE_KEY));
    }

    private static Stream<Arguments> getNestedJson() throws IOException {
        return Stream.of(Arguments.of((Object[])new Object[]{new String(Files.readAllBytes(Paths.get("src/test/resources/TestJson/json-sample.json", new String[0]))), List.class}), Arguments.of((Object[])new Object[]{new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/input.json", new String[0]))), Map.class}));
    }

    @ParameterizedTest
    @MethodSource(value={"getNestedJson"})
    public void testAttributeWithNestedJsonOutputAsJsonInAttribute(String nestedJson, Class<?> expectedClass) throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(AttributesToJSON.JSON_HANDLING_STRATEGY, AttributesToJSON.JsonHandlingStrategy.NESTED.getValue());
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, nestedJson);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, Map.class);
        Assertions.assertInstanceOf(expectedClass, val.get(TEST_ATTRIBUTE_KEY));
    }

    @ParameterizedTest
    @ValueSource(strings={"[THIS IS NOT JSON]", "{THIS IS NOT JSON}"})
    public void testAttributesWithLookALikeJson(String lookAlikeJson) {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        testRunner.setProperty(AttributesToJSON.JSON_HANDLING_STRATEGY, AttributesToJSON.JsonHandlingStrategy.NESTED.getValue());
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, lookAlikeJson);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 1);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 0);
        MockComponentLog logger = testRunner.getLogger();
        Assertions.assertTrue((boolean)((LogMessage)logger.getErrorMessages().get(0)).getMsg().contains("expecting"));
    }

    @ParameterizedTest
    @MethodSource(value={"getNestedJson"})
    public void testAttributeWithNestedJsonOutputAsStringInAttribute(String nestedJson) throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-attribute");
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, nestedJson);
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).assertAttributeExists("JSONAttributes");
        String json = ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0)).getAttribute("JSONAttributes");
        Map val = (Map)MAPPER.readValue(json, Map.class);
        Assertions.assertInstanceOf(String.class, val.get(TEST_ATTRIBUTE_KEY));
    }

    @Test
    public void testAttributeWithJsonBetweenLeadingAndTrailingSpaces() throws JsonProcessingException {
        String jsonBetweenLeadingAndTrailingSpaces = "\n{\n    \"fruit\": \"Apple\",\n    \"size\": \"Large\",\n    \"color\": \"Red\"\n}\n";
        Assertions.assertDoesNotThrow(() -> (Map)MAPPER.readValue("\n{\n    \"fruit\": \"Apple\",\n    \"size\": \"Large\",\n    \"color\": \"Red\"\n}\n", Map.class));
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToJSON());
        testRunner.setProperty(AttributesToJSON.DESTINATION, "flowfile-content");
        testRunner.setProperty(AttributesToJSON.JSON_HANDLING_STRATEGY, AttributesToJSON.JsonHandlingStrategy.NESTED.getValue());
        ProcessSession session = testRunner.getProcessSessionFactory().createSession();
        FlowFile ff = session.create();
        ff = session.putAttribute(ff, TEST_ATTRIBUTE_KEY, "\n{\n    \"fruit\": \"Apple\",\n    \"size\": \"Large\",\n    \"color\": \"Red\"\n}\n");
        testRunner.enqueue(new FlowFile[]{ff});
        testRunner.run();
        testRunner.assertTransferCount(AttributesToJSON.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToJSON.REL_SUCCESS, 1);
        MockFlowFile result = (MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToJSON.REL_SUCCESS).get(0);
        Map attributes = (Map)MAPPER.readValue(result.getContent(), Map.class);
        Assertions.assertInstanceOf(Map.class, attributes.get(TEST_ATTRIBUTE_KEY));
    }
}

