/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.AttributesToCSV;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAttributesToCSV {
    private static final String OUTPUT_NEW_ATTRIBUTE = "flowfile-attribute";
    private static final String OUTPUT_OVERWRITE_CONTENT = "flowfile-content";
    private static final String OUTPUT_ATTRIBUTE_NAME = "CSVData";
    private static final String OUTPUT_SEPARATOR = ",";
    private static final String OUTPUT_MIME_TYPE = "text/csv";
    private static final String SPLIT_REGEX = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final String newline = System.getProperty("line.separator");

    @Test
    public void testAttrListNoCoreNullOffNewAttrToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        String NON_PRESENT_ATTRIBUTE_KEY = "beach-type";
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-type");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "");
    }

    @Test
    public void testAttrListNoCoreNullOffNewAttrToContent() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        String NON_PRESENT_ATTRIBUTE_KEY = "beach-type";
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-type");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "");
    }

    @Test
    public void testAttrListNoCoreNullOffTwoNewAttrToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        String NON_PRESENT_ATTRIBUTE_KEY = "beach-type,beach-length";
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-type,beach-length");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, OUTPUT_SEPARATOR);
    }

    @Test
    public void testAttrListNoCoreNullTwoNewAttrToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "true");
        String NON_PRESENT_ATTRIBUTE_KEY = "beach-type,beach-length";
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-type,beach-length");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "null,null");
    }

    @Test
    public void testNoAttrListNoCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "");
    }

    @Test
    public void testNoAttrListNoCoreNullToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "true");
        testRunner.enqueue(new byte[0]);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "");
    }

    @Test
    public void testNoAttrListCoreNullOffToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_OVERWRITE_CONTENT);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertEquals((Object)OUTPUT_MIME_TYPE, (Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        byte[] contentData = testRunner.getContentAsByteArray(flowFile);
        String contentDataString = new String(contentData, "UTF-8");
        HashSet<String> contentValues = new HashSet<String>(this.getStrings(contentDataString));
        Assertions.assertEquals((int)6, (int)contentValues.size());
        Assertions.assertTrue((boolean)contentValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)contentValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)contentValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)contentValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)contentValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)contentValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testNoAttrListCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> csvAttributeValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)csvAttributeValues.size());
        Assertions.assertTrue((boolean)csvAttributeValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)csvAttributeValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)csvAttributeValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)csvAttributeValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)csvAttributeValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)csvAttributeValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testNoAttrListNoCoreNullOffToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_OVERWRITE_CONTENT);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertEquals((Object)OUTPUT_MIME_TYPE, (Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        byte[] contentData = testRunner.getContentAsByteArray(flowFile);
        String contentDataString = new String(contentData, "UTF-8");
        HashSet<String> contentValues = new HashSet<String>(this.getStrings(contentDataString));
        Assertions.assertEquals((int)3, (int)contentValues.size());
        Assertions.assertTrue((boolean)contentValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)contentValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)contentValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
    }

    @Test
    public void testAttrListNoCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-name,beach-location,beach-endorsement");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVAttribute!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)3, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
    }

    @Test
    public void testAttrListCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-name,beach-location,beach-endorsement");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testAttrListNoCoreNullOffOverrideCoreByAttrListToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "beach-name,beach-location,beach-endorsement,uuid");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)4, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("filename")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("path")) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testAttrListFromExpCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "${myAttribs}");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
                this.put("myAttribs", "beach-name,beach-location,beach-endorsement");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
        flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testAttrListWithCommasInNameFromExpCoreNullOffToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "${myAttribs}");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrsCommaInName = new HashMap<String, String>(){
            {
                this.put("beach,name", "Malibu Beach");
                this.put("beach,location", "California, US");
                this.put("beach,endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
                this.put("myAttribs", "\"beach,name\",\"beach,location\",\"beach,endorsement\"");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrsCommaInName);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
        flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)6, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("filename")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("path")));
        Assertions.assertTrue((boolean)CSVDataValues.contains(flowFile.getAttribute("uuid")));
    }

    @Test
    public void testAttrListFromExpNoCoreNullOffOverrideCoreByAttrListToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "${myAttribs}");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
                this.put("myAttribs", "beach-name,beach-location,beach-endorsement");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)3, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("filename")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("path")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("uuid")) ? 1 : 0) != 0);
    }

    @Test
    public void testAttributesRegex() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "${myRegEx}");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
                this.put("myRegEx", "beach-.*");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)3, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("filename")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("path")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("uuid")) ? 1 : 0) != 0);
    }

    @Test
    public void testAttributesRegexAndList() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "${myRegEx}");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_LIST, "moreInfo1,moreInfo2");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        HashMap<String, String> attrs = new HashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("beach-endorsement", "This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
                this.put("myRegEx", "beach-.*");
                this.put("moreInfo1", "A+ Rating");
                this.put("moreInfo2", "Avg Temp: 61f");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        List flowFilesForRelationship = testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)flowFilesForRelationship.get(0);
        Assertions.assertNull((Object)flowFile.getAttribute(CoreAttributes.MIME_TYPE.key()));
        String attributeData = flowFile.getAttribute(OUTPUT_ATTRIBUTE_NAME);
        HashSet<String> CSVDataValues = new HashSet<String>(this.getStrings(attributeData));
        Assertions.assertEquals((int)5, (int)CSVDataValues.size());
        Assertions.assertTrue((boolean)CSVDataValues.contains("Malibu Beach"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"California, US\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("\"This is our family's favorite beach. We highly recommend it. \n\nThanks, Jim\""));
        Assertions.assertTrue((boolean)CSVDataValues.contains("A+ Rating"));
        Assertions.assertTrue((boolean)CSVDataValues.contains("Avg Temp: 61f"));
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("filename")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("path")) ? 1 : 0) != 0);
        Assertions.assertTrue((!CSVDataValues.contains(flowFile.getAttribute("uuid")) ? 1 : 0) != 0);
    }

    @Test
    public void testSchemaToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        testRunner.setProperty(AttributesToCSV.INCLUDE_SCHEMA, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "beach-.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeExists("CSVSchema");
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "Malibu Beach,\"California, US\"");
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0)).assertAttributeEquals("CSVSchema", "beach-name,beach-location");
    }

    @Test
    public void testSchemaToContent() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_OVERWRITE_CONTENT);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "false");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        testRunner.setProperty(AttributesToCSV.INCLUDE_SCHEMA, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "beach-.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0);
        flowFile.assertAttributeNotExists(OUTPUT_ATTRIBUTE_NAME);
        flowFile.assertAttributeNotExists("CSVSchema");
        byte[] contentData = testRunner.getContentAsByteArray(flowFile);
        String contentDataString = new String(contentData, "UTF-8");
        Assertions.assertEquals((Object)contentDataString.split(newline)[0], (Object)"beach-name,beach-location");
        Assertions.assertEquals((Object)contentDataString.split(newline)[1], (Object)"Malibu Beach,\"California, US\"");
    }

    @Test
    public void testSchemaWithCoreAttribuesToAttribute() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_NEW_ATTRIBUTE);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        testRunner.setProperty(AttributesToCSV.INCLUDE_SCHEMA, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "beach-.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0);
        flowFile.assertAttributeExists(OUTPUT_ATTRIBUTE_NAME);
        flowFile.assertAttributeExists("CSVSchema");
        String path = flowFile.getAttribute("path");
        String filename = flowFile.getAttribute("filename");
        String uuid = flowFile.getAttribute("uuid");
        flowFile.assertAttributeEquals(OUTPUT_ATTRIBUTE_NAME, "Malibu Beach,\"California, US\"," + path + OUTPUT_SEPARATOR + filename + OUTPUT_SEPARATOR + uuid);
        flowFile.assertAttributeEquals("CSVSchema", "beach-name,beach-location,path,filename,uuid");
    }

    @Test
    public void testSchemaWithCoreAttribuesToContent() throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new AttributesToCSV());
        testRunner.setProperty(AttributesToCSV.DESTINATION, OUTPUT_OVERWRITE_CONTENT);
        testRunner.setProperty(AttributesToCSV.INCLUDE_CORE_ATTRIBUTES, "true");
        testRunner.setProperty(AttributesToCSV.NULL_VALUE_FOR_EMPTY_STRING, "false");
        testRunner.setProperty(AttributesToCSV.INCLUDE_SCHEMA, "true");
        testRunner.setProperty(AttributesToCSV.ATTRIBUTES_REGEX, "beach-.*");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(){
            {
                this.put("beach-name", "Malibu Beach");
                this.put("beach-location", "California, US");
                this.put("attribute-should-be-eliminated", "This should not be in CSVData!");
            }
        };
        testRunner.enqueue(new byte[0], (Map)attrs);
        testRunner.run();
        testRunner.assertTransferCount(AttributesToCSV.REL_SUCCESS, 1);
        testRunner.assertTransferCount(AttributesToCSV.REL_FAILURE, 0);
        MockFlowFile flowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(AttributesToCSV.REL_SUCCESS).get(0);
        flowFile.assertAttributeNotExists(OUTPUT_ATTRIBUTE_NAME);
        flowFile.assertAttributeNotExists("CSVSchema");
        String path = flowFile.getAttribute("path");
        String filename = flowFile.getAttribute("filename");
        String uuid = flowFile.getAttribute("uuid");
        byte[] contentData = testRunner.getContentAsByteArray(flowFile);
        String contentDataString = new String(contentData, "UTF-8");
        Assertions.assertEquals((Object)contentDataString.split(newline)[0], (Object)"beach-name,beach-location,path,filename,uuid");
        Assertions.assertEquals((Object)contentDataString.split(newline)[1], (Object)("Malibu Beach,\"California, US\"," + path + OUTPUT_SEPARATOR + filename + OUTPUT_SEPARATOR + uuid));
    }

    private List<String> getStrings(String sdata) {
        return Arrays.asList(Pattern.compile(SPLIT_REGEX).split(sdata));
    }
}

