/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.SplitXml;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SplitXmlTest {
    private TestRunner runner;

    @BeforeEach
    void setupRunner() {
        this.runner = TestRunners.newTestRunner((Processor)new SplitXml());
    }

    @Test
    void testShouldHandleXXEInTemplate() throws IOException {
        String xxeTemplateFilepath = "src/test/resources/xxe_template.xml";
        this.assertExternalEntitiesFailure("src/test/resources/xxe_template.xml");
    }

    @Test
    void testShouldHandleRemoteCallXXE() throws IOException {
        String xxeTemplateFilepath = "src/test/resources/xxe_from_report.xml";
        this.assertExternalEntitiesFailure("src/test/resources/xxe_from_report.xml");
    }

    private void assertExternalEntitiesFailure(String filePath) throws IOException {
        this.runner.setProperty(SplitXml.SPLIT_DEPTH, "3");
        this.runner.enqueue(Paths.get(filePath, new String[0]));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(SplitXml.REL_FAILURE);
    }
}

