/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processors.standard.HandleHttpRequest;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class HandleHttpRequestTest {
    private static final String CONTEXT_MAP_ID = HttpContextMap.class.getSimpleName();
    private static final String MINIMUM_THREADS = "8";
    @Mock
    HttpContextMap httpContextMap;
    TestRunner runner;

    HandleHttpRequestTest() {
    }

    @BeforeEach
    void setRunner() throws InitializationException {
        this.runner = TestRunners.newTestRunner(HandleHttpRequest.class);
        Mockito.when((Object)this.httpContextMap.getIdentifier()).thenReturn((Object)CONTEXT_MAP_ID);
        this.runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)this.httpContextMap);
        this.runner.enableControllerService((ControllerService)this.httpContextMap);
    }

    @AfterEach
    void shutdown() {
        this.runner.shutdown();
    }

    @Test
    void testSetRequiredProperties() {
        this.runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        this.runner.assertValid();
    }

    @Test
    void testRun() {
        this.runner.setProperty(HandleHttpRequest.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        this.runner.setProperty(HandleHttpRequest.MAXIMUM_THREADS, MINIMUM_THREADS);
        this.runner.setProperty(HandleHttpRequest.PORT, "0");
        this.runner.run();
        this.runner.assertTransferCount(HandleHttpRequest.REL_SUCCESS, 0);
    }
}

