/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.nifi.avro.AvroReader;
import org.apache.nifi.avro.AvroReaderWithEmbeddedSchema;
import org.apache.nifi.avro.AvroRecordSetWriter;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVReader;
import org.apache.nifi.csv.CSVRecordSetWriter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.xml.XMLReader;
import org.apache.nifi.xml.XMLRecordSetWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractConversionIT {
    protected RecordReaderFactory reader;
    protected Consumer<TestRunner> inputHandler;
    protected Consumer<TestRunner> readerConfigurer;
    protected RecordSetWriterFactory writer;
    protected Consumer<MockFlowFile> resultHandler;
    protected Consumer<TestRunner> writerConfigurer;

    @BeforeEach
    public void setUp() throws Exception {
        this.reader = null;
        this.inputHandler = null;
        this.readerConfigurer = null;
        this.writer = null;
        this.resultHandler = null;
        this.writerConfigurer = null;
    }

    @Test
    public void testCsvToJson() throws Exception {
        this.fromCsv(this.csvPostfix());
        this.toJson(this.jsonPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testCsvToAvro() throws Exception {
        this.fromCsv(this.csvPostfix());
        this.toAvro(this.avroPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testCsvToAvroToCsv() throws Exception {
        this.fromCsv(this.csvPostfix());
        AvroRecordSetWriter writer2 = new AvroRecordSetWriter();
        AvroReader reader2 = new AvroReader();
        this.toCsv(this.csvPostfix());
        this.testChain((RecordSetWriterFactory)writer2, (RecordReaderFactory)reader2);
    }

    @Test
    public void testCsvToXml() throws Exception {
        this.fromCsv(this.csvPostfix());
        this.toXml(this.xmlPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testJsonToCsv() throws Exception {
        this.fromJson(this.jsonPostfix());
        this.toCsv(this.csvPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testJsonToAvro() throws Exception {
        this.fromJson(this.jsonPostfix());
        this.toAvro(this.avroPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testJsonToAvroToJson() throws Exception {
        this.fromJson(this.jsonPostfix());
        AvroRecordSetWriter writer2 = new AvroRecordSetWriter();
        AvroReader reader2 = new AvroReader();
        this.toJson(this.jsonPostfix());
        this.testChain((RecordSetWriterFactory)writer2, (RecordReaderFactory)reader2);
    }

    @Test
    public void testAvroToCsv() throws Exception {
        this.fromAvro(this.avroPostfix());
        this.toCsv(this.csvPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testAvroToJson() throws Exception {
        this.fromAvro(this.avroPostfix());
        this.toJson(this.jsonPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testAvroToXml() throws Exception {
        this.fromAvro(this.avroPostfix());
        this.toXml(this.xmlPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testXmlToCsv() throws Exception {
        this.fromXml(this.xmlPostfix());
        this.toCsv(this.csvPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testXmlToJson() throws Exception {
        this.fromXml(this.xmlPostfix());
        this.toJson(this.jsonPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testXmlToAvro() throws Exception {
        this.fromXml(this.xmlPostfix());
        this.toAvro(this.avroPostfix());
        this.testConversion(this.reader, this.readerConfigurer, this.writer, this.writerConfigurer, this.inputHandler, this.resultHandler);
    }

    @Test
    public void testXmlToAvroToXml() throws Exception {
        this.fromXml(this.xmlPostfix());
        AvroRecordSetWriter writer2 = new AvroRecordSetWriter();
        AvroReader reader2 = new AvroReader();
        this.toXml(this.xmlPostfix());
        this.testChain((RecordSetWriterFactory)writer2, (RecordReaderFactory)reader2);
    }

    protected abstract String csvPostfix();

    protected abstract String jsonPostfix();

    protected abstract String avroPostfix();

    protected abstract String xmlPostfix();

    protected void commonReaderConfiguration(TestRunner testRunner) {
    }

    protected void commonWriterConfiguration(TestRunner testRunner) {
    }

    protected void fromCsv(String postfix) {
        this.reader = new CSVReader();
        this.inputHandler = this.stringInputHandler(this.getContent(postfix));
        this.readerConfigurer = testRunner -> this.commonReaderConfiguration((TestRunner)testRunner);
    }

    protected void fromJson(String postfix) {
        this.reader = new JsonTreeReader();
        this.inputHandler = this.stringInputHandler(this.getContent(postfix));
        this.readerConfigurer = testRunner -> this.commonReaderConfiguration((TestRunner)testRunner);
    }

    protected void fromXml(String postfix) {
        this.reader = new XMLReader();
        this.inputHandler = this.stringInputHandler(this.getContent(postfix));
        this.readerConfigurer = testRunner -> {
            this.commonReaderConfiguration((TestRunner)testRunner);
            testRunner.setProperty((ControllerService)this.reader, XMLReader.RECORD_FORMAT, XMLReader.RECORD_ARRAY);
        };
    }

    protected void fromAvro(String postfix) {
        this.reader = new AvroReader();
        this.inputHandler = this.byteInputHandler(this.getByteContent(postfix));
        this.readerConfigurer = testRunner -> this.commonReaderConfiguration((TestRunner)testRunner);
    }

    protected void toCsv(String postfix) {
        this.writer = new CSVRecordSetWriter();
        this.resultHandler = this.stringOutputHandler(this.getContent(postfix));
        this.writerConfigurer = testRunner -> this.commonWriterConfiguration((TestRunner)testRunner);
    }

    protected void toJson(String postfix) {
        this.writer = new JsonRecordSetWriter();
        this.resultHandler = this.stringOutputHandler(this.getContent(postfix));
        this.writerConfigurer = testRunner -> {
            this.commonWriterConfiguration((TestRunner)testRunner);
            testRunner.setProperty((ControllerService)this.writer, "Pretty Print JSON", "true");
        };
    }

    protected void toXml(String postfix) {
        this.writer = new XMLRecordSetWriter();
        this.resultHandler = this.stringOutputHandler(this.getContent(postfix));
        this.writerConfigurer = testRunner -> {
            this.commonWriterConfiguration((TestRunner)testRunner);
            testRunner.setProperty((ControllerService)this.writer, "pretty_print_xml", "true");
            testRunner.setProperty((ControllerService)this.writer, "root_tag_name", "root");
            testRunner.setProperty((ControllerService)this.writer, "record_tag_name", "nifiRecord");
        };
    }

    protected void toAvro(String postfix) {
        this.writer = new AvroRecordSetWriter();
        this.resultHandler = mockFlowFile -> {
            try {
                List<Map<String, Object>> expected = this.getRecords(this.getByteContent(postfix));
                List<Map<String, Object>> actual = this.getRecords(mockFlowFile.toByteArray());
                Assertions.assertEquals(expected, actual);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.writerConfigurer = testRunner -> this.commonWriterConfiguration((TestRunner)testRunner);
    }

    protected Consumer<TestRunner> stringInputHandler(String input) {
        return testRunner -> testRunner.enqueue(input);
    }

    protected Consumer<TestRunner> byteInputHandler(byte[] input) {
        return testRunner -> testRunner.enqueue(input);
    }

    protected Consumer<MockFlowFile> stringOutputHandler(String expected) {
        return mockFlowFile -> mockFlowFile.assertContentEquals(expected);
    }

    protected String getContent(String postfix) {
        return new String(this.getByteContent(postfix));
    }

    protected byte[] getByteContent(String postfix) {
        try {
            return Files.readAllBytes(Paths.get("src/test/resources/TestConversions/data.int_float_string." + postfix, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Map<String, Object>> getRecords(byte[] avroData) throws IOException, MalformedRecordException {
        try (AvroReaderWithEmbeddedSchema reader = new AvroReaderWithEmbeddedSchema((InputStream)new ByteArrayInputStream(avroData));){
            List<Map<String, Object>> list = this.getRecords((RecordReader)reader);
            return list;
        }
    }

    protected List<Map<String, Object>> getRecords(RecordReader reader) throws IOException, MalformedRecordException {
        Record record;
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        while ((record = reader.nextRecord()) != null) {
            records.add(record.toMap());
        }
        return records;
    }

    protected void testChain(RecordSetWriterFactory writer2, RecordReaderFactory reader2) throws InitializationException {
        this.testConversion(this.reader, this.readerConfigurer, writer2, null, this.inputHandler, mockFlowFile -> {
            try {
                this.testConversion(reader2, null, this.writer, this.writerConfigurer, testRunner -> testRunner.enqueue(new FlowFile[]{mockFlowFile}), this.resultHandler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected <R extends RecordReaderFactory, W extends RecordSetWriterFactory> void testConversion(R reader, Consumer<TestRunner> readerConfigurer, W writer, Consumer<TestRunner> writerConfigurer, Consumer<TestRunner> inputHandler, Consumer<MockFlowFile> resultHandler) throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(ConvertRecord.class);
        String readerId = UUID.randomUUID().toString();
        String writerId = UUID.randomUUID().toString();
        runner.addControllerService(readerId, reader);
        runner.addControllerService(writerId, writer);
        Optional.ofNullable(readerConfigurer).ifPresent(_configurer -> _configurer.accept(runner));
        Optional.ofNullable(writerConfigurer).ifPresent(_configurer -> _configurer.accept(runner));
        runner.enableControllerService(reader);
        runner.enableControllerService(writer);
        runner.setProperty(ConvertRecord.RECORD_READER, readerId);
        runner.setProperty(ConvertRecord.RECORD_WRITER, writerId);
        inputHandler.accept(runner);
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertRecord.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertRecord.REL_SUCCESS).get(0);
        resultHandler.accept(flowFile);
    }
}

