/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPGPPasswordBasedEncryptor
implements EncryptContent.Encryptor {
    private static final Logger logger = LoggerFactory.getLogger(OpenPGPPasswordBasedEncryptor.class);
    private String algorithm;
    private String provider;
    private char[] password;
    private String filename;
    private Integer cipher;

    public OpenPGPPasswordBasedEncryptor(String algorithm, Integer cipher, String provider, char[] passphrase, String filename) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.password = passphrase;
        this.filename = filename;
        this.cipher = cipher;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws Exception {
        return new OpenPGPEncryptCallback(this.algorithm, this.cipher, this.provider, this.password, this.filename);
    }

    @Override
    public StreamCallback getDecryptionCallback() throws Exception {
        return new OpenPGPDecryptCallback(this.provider, this.password);
    }

    @Override
    public void updateAttributes(Map<String, String> attributes) throws ProcessException {
    }

    private static class OpenPGPEncryptCallback
    implements StreamCallback {
        private String algorithm;
        private String provider;
        private char[] password;
        private String filename;
        private Integer cipher;

        OpenPGPEncryptCallback(String algorithm, Integer cipher, String provider, char[] password, String filename) {
            this.algorithm = algorithm;
            this.provider = provider;
            this.password = password;
            this.filename = filename;
            this.cipher = cipher;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try {
                JcePBEKeyEncryptionMethodGenerator encryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(this.password).setProvider(this.provider);
                org.apache.nifi.processors.standard.util.PGPUtil.encrypt(in, out, this.algorithm, this.provider, this.cipher, this.filename, (PGPKeyEncryptionMethodGenerator)encryptionMethodGenerator);
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }

    private static class OpenPGPDecryptCallback
    implements StreamCallback {
        private String provider;
        private char[] password;

        OpenPGPDecryptCallback(String provider, char[] password) {
            this.provider = provider;
            this.password = password;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            InputStream pgpin = PGPUtil.getDecoderStream((InputStream)in);
            JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(pgpin);
            Object obj = pgpFactory.nextObject();
            if (!(obj instanceof PGPEncryptedDataList) && !((obj = pgpFactory.nextObject()) instanceof PGPEncryptedDataList)) {
                throw new ProcessException("Invalid OpenPGP data");
            }
            PGPEncryptedDataList encList = (PGPEncryptedDataList)obj;
            if (!((obj = encList.get(0)) instanceof PGPPBEEncryptedData)) {
                throw new ProcessException("Invalid OpenPGP data");
            }
            PGPPBEEncryptedData encryptedData = (PGPPBEEncryptedData)obj;
            try {
                int len;
                PGPDigestCalculatorProvider digestCalculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider(this.provider).build();
                PBEDataDecryptorFactory decryptorFactory = new JcePBEDataDecryptorFactoryBuilder(digestCalculatorProvider).setProvider(this.provider).build(this.password);
                InputStream clear = encryptedData.getDataStream(decryptorFactory);
                JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(clear);
                obj = pgpObjectFactory.nextObject();
                if (obj instanceof PGPCompressedData) {
                    PGPCompressedData compressedData = (PGPCompressedData)obj;
                    pgpObjectFactory = new JcaPGPObjectFactory(compressedData.getDataStream());
                    obj = pgpObjectFactory.nextObject();
                }
                PGPLiteralData literalData = (PGPLiteralData)obj;
                InputStream plainIn = literalData.getInputStream();
                byte[] buffer = new byte[4096];
                while ((len = plainIn.read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
                if (encryptedData.isIntegrityProtected()) {
                    if (!encryptedData.verify()) {
                        throw new PGPException("Integrity check failed");
                    }
                } else {
                    logger.warn("No message integrity check");
                }
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }
}

