/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.standard.db.impl.PhoenixDatabaseAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestPhoenixDatabaseAdapter {
    private PhoenixDatabaseAdapter testSubject;

    TestPhoenixDatabaseAdapter() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testSubject = new PhoenixDatabaseAdapter();
    }

    @Test
    void testSupportsUpsert() {
        Assertions.assertTrue((boolean)this.testSubject.supportsUpsert(), (String)(this.testSubject.getClass().getSimpleName() + " should support upsert"));
    }

    @Test
    void testGetUpsertStatementWithNullTableName() {
        this.testGetUpsertStatement(null, Arrays.asList("notEmpty"), Arrays.asList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    void testGetUpsertStatementWithBlankTableName() {
        this.testGetUpsertStatement("", Arrays.asList("notEmpty"), Arrays.asList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    void testGetUpsertStatementWithNullColumnNames() {
        this.testGetUpsertStatement("notEmpty", null, Arrays.asList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    void testGetUpsertStatementWithEmptyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Collections.emptyList(), Arrays.asList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    void testGetUpsertStatementWithNullKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Arrays.asList("notEmpty"), null, new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    void testGetUpsertStatementWithEmptyKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Arrays.asList("notEmpty"), Collections.emptyList(), new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    void testGetUpsertStatement() {
        String tableName = "table";
        List<String> columnNames = Arrays.asList("column1", "column2", "column3", "column4");
        List<String> uniqueKeyColumnNames = Arrays.asList("column2", "column4");
        String expected = "UPSERT INTO table(column1, column2, column3, column4) VALUES (?, ?, ?, ?)";
        this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, expected);
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, IllegalArgumentException expected) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, (String)null));
        Assertions.assertEquals((Object)expected.getMessage(), (Object)e.getMessage());
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, String expected) {
        String actual = this.testSubject.getUpsertStatement(tableName, columnNames, uniqueKeyColumnNames);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetUpsertStatementQuoted() {
        String tableName = "\"table\"";
        List<String> columnNames = Arrays.asList("column1", "\"column2\"", "column3", "column4");
        List<String> uniqueKeyColumnNames = Arrays.asList("\"column2\"", "column4");
        String expected = "UPSERT INTO \"table\"(column1, \"column2\", column3, column4) VALUES (?, ?, ?, ?)";
        this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, expected);
    }
}

