/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.apache.nifi.event.transport.EventSender;
import org.apache.nifi.event.transport.configuration.LineEnding;
import org.apache.nifi.event.transport.configuration.ShutdownQuietPeriod;
import org.apache.nifi.event.transport.configuration.ShutdownTimeout;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.StringNettyEventSenderFactory;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ListenSyslog;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestListenSyslog {
    private static final String PRIORITY = "34";
    private static final String TIMESTAMP = "Jan 31 23:59:59";
    private static final String HOST = "localhost.localdomain";
    private static final String BODY = String.class.getName();
    private static final String VALID_MESSAGE = String.format("<%s>%s %s %s", "34", "Jan 31 23:59:59", "localhost.localdomain", BODY);
    private static final String MIME_TYPE = "text/plain";
    private static final boolean STOP_ON_FINISH_DISABLED = false;
    private static final boolean STOP_ON_FINISH_ENABLED = true;
    private static final boolean INITIALIZE_DISABLED = false;
    private static final String LOCALHOST_ADDRESS = "127.0.0.1";
    private static final Duration SENDER_TIMEOUT = Duration.ofSeconds(15L);
    private static final Charset CHARSET = StandardCharsets.US_ASCII;
    private TestRunner runner;
    private ListenSyslog processor;

    @BeforeEach
    public void setRunner() {
        this.processor = new ListenSyslog();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.setProperty(ListenSyslog.CHARSET, CHARSET.name());
    }

    @AfterEach
    public void closeEventSender() {
        this.processor.shutdownEventServer();
    }

    @Test
    public void testRunTcp() throws Exception {
        TransportProtocol protocol = TransportProtocol.TCP;
        this.runner.setProperty(ListenSyslog.PROTOCOL, protocol.toString());
        this.runner.setProperty(ListenSyslog.PORT, "0");
        this.runner.setProperty(ListenSyslog.SOCKET_KEEP_ALIVE, Boolean.FALSE.toString());
        this.assertSendSuccess(protocol);
    }

    @Test
    public void testRunTcpBatchParseDisabled() throws Exception {
        TransportProtocol protocol = TransportProtocol.TCP;
        this.runner.setProperty(ListenSyslog.PROTOCOL, protocol.toString());
        this.runner.setProperty(ListenSyslog.PORT, "0");
        this.runner.setProperty(ListenSyslog.SOCKET_KEEP_ALIVE, Boolean.FALSE.toString());
        this.runner.setProperty(ListenSyslog.PARSE_MESSAGES, Boolean.FALSE.toString());
        this.runner.setProperty(ListenSyslog.MAX_BATCH_SIZE, "2");
        this.runner.run(1, false);
        int port = ((ListenSyslog)this.runner.getProcessor()).getListeningPort();
        String batchedWithEmptyMessages = String.format("%s\n\n%s\n", VALID_MESSAGE, VALID_MESSAGE);
        this.sendMessages(protocol, port, LineEnding.NONE, batchedWithEmptyMessages);
        this.runner.run(1, false, false);
        this.runner.assertTransferCount(ListenSyslog.REL_INVALID, 0);
        List successFlowFiles = this.runner.getFlowFilesForRelationship(ListenSyslog.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFlowFiles.size(), (String)"Success FlowFiles not matched");
        MockFlowFile flowFile = (MockFlowFile)successFlowFiles.iterator().next();
        String batchedMessages = String.format("%s\n%s", VALID_MESSAGE, VALID_MESSAGE);
        flowFile.assertContentEquals(batchedMessages);
    }

    @Test
    public void testRunUdp() throws Exception {
        TransportProtocol protocol = TransportProtocol.UDP;
        this.runner.setProperty(ListenSyslog.PROTOCOL, protocol.toString());
        this.runner.setProperty(ListenSyslog.PORT, "0");
        this.assertSendSuccess(protocol);
    }

    @Test
    public void testRunUdpBatch() throws Exception {
        TransportProtocol protocol = TransportProtocol.UDP;
        this.runner.setProperty(ListenSyslog.PROTOCOL, protocol.toString());
        this.runner.setProperty(ListenSyslog.PORT, "0");
        String[] messages = new String[]{VALID_MESSAGE, VALID_MESSAGE};
        this.runner.setProperty(ListenSyslog.MAX_BATCH_SIZE, Integer.toString(messages.length));
        this.runner.setProperty(ListenSyslog.PARSE_MESSAGES, Boolean.FALSE.toString());
        this.runner.run(1, false);
        int listeningPort = ((ListenSyslog)this.runner.getProcessor()).getListeningPort();
        this.sendMessages(protocol, listeningPort, LineEnding.NONE, messages);
        this.runner.run(1, true, false);
        List successFlowFiles = this.runner.getFlowFilesForRelationship(ListenSyslog.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFlowFiles.size(), (String)"Success FlowFiles not matched");
        Long receivedCounter = this.runner.getCounterValue("Messages Received");
        Assertions.assertEquals((Long)Long.valueOf(messages.length), (Long)receivedCounter, (String)"Received Counter not matched");
        Long successCounter = this.runner.getCounterValue("FlowFiles Transferred to Success");
        Assertions.assertEquals((Long)1L, (Long)successCounter, (String)"Success Counter not matched");
    }

    @Test
    public void testRunUdpInvalid() throws Exception {
        TransportProtocol protocol = TransportProtocol.UDP;
        this.runner.setProperty(ListenSyslog.PROTOCOL, protocol.toString());
        this.runner.setProperty(ListenSyslog.PORT, "0");
        this.runner.run(1, false);
        int listeningPort = ((ListenSyslog)this.runner.getProcessor()).getListeningPort();
        this.sendMessages(protocol, listeningPort, LineEnding.NONE, TIMESTAMP);
        this.runner.run(1, true, false);
        List invalidFlowFiles = this.runner.getFlowFilesForRelationship(ListenSyslog.REL_INVALID);
        Assertions.assertEquals((int)1, (int)invalidFlowFiles.size(), (String)"Invalid FlowFiles not matched");
        MockFlowFile flowFile = (MockFlowFile)invalidFlowFiles.iterator().next();
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_SENDER.key(), LOCALHOST_ADDRESS);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_PROTOCOL.key(), protocol.toString());
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_PORT.key(), Integer.toString(listeningPort));
        String content = flowFile.getContent();
        Assertions.assertEquals((Object)TIMESTAMP, (Object)content, (String)"FlowFile content not matched");
    }

    private void assertSendSuccess(TransportProtocol protocol) throws Exception {
        this.runner.run(1, false);
        int port = ((ListenSyslog)this.runner.getProcessor()).getListeningPort();
        this.sendMessages(protocol, port, LineEnding.UNIX, VALID_MESSAGE);
        this.runner.run(1, true, false);
        List invalidFlowFiles = this.runner.getFlowFilesForRelationship(ListenSyslog.REL_INVALID);
        Assertions.assertTrue((boolean)invalidFlowFiles.isEmpty(), (String)"Invalid FlowFiles found");
        List successFlowFiles = this.runner.getFlowFilesForRelationship(ListenSyslog.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFlowFiles.size(), (String)"Success FlowFiles not matched");
        MockFlowFile flowFile = (MockFlowFile)successFlowFiles.iterator().next();
        flowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), MIME_TYPE);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_SENDER.key(), LOCALHOST_ADDRESS);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_PROTOCOL.key(), protocol.toString());
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_PORT.key(), Integer.toString(port));
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_HOSTNAME.key(), HOST);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_BODY.key(), BODY);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_PRIORITY.key(), PRIORITY);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_TIMESTAMP.key(), TIMESTAMP);
        flowFile.assertAttributeEquals(SyslogAttributes.SYSLOG_VALID.key(), Boolean.TRUE.toString());
        flowFile.assertAttributeExists(SyslogAttributes.SYSLOG_FACILITY.key());
        flowFile.assertAttributeExists(SyslogAttributes.SYSLOG_SEVERITY.key());
        Long receivedCounter = this.runner.getCounterValue("Messages Received");
        Assertions.assertEquals((Long)1L, (Long)receivedCounter, (String)"Received Counter not matched");
        Long successCounter = this.runner.getCounterValue("FlowFiles Transferred to Success");
        Assertions.assertEquals((Long)1L, (Long)successCounter, (String)"Success Counter not matched");
        List events = this.runner.getProvenanceEvents();
        Assertions.assertFalse((boolean)events.isEmpty(), (String)"Provenance Events not found");
        ProvenanceEventRecord eventRecord = (ProvenanceEventRecord)events.iterator().next();
        Assertions.assertEquals((Object)ProvenanceEventType.RECEIVE, (Object)eventRecord.getEventType());
        String transitUri = String.format("%s://%s:%d", protocol.toString().toLowerCase(), LOCALHOST_ADDRESS, port);
        Assertions.assertEquals((Object)transitUri, (Object)eventRecord.getTransitUri(), (String)"Provenance Transit URI not matched");
    }

    private void sendMessages(TransportProtocol protocol, int port, LineEnding lineEnding, String ... messages) throws Exception {
        StringNettyEventSenderFactory eventSenderFactory = new StringNettyEventSenderFactory((ComponentLog)this.runner.getLogger(), LOCALHOST_ADDRESS, port, protocol, CHARSET, lineEnding);
        eventSenderFactory.setShutdownQuietPeriod(ShutdownQuietPeriod.QUICK.getDuration());
        eventSenderFactory.setShutdownTimeout(ShutdownTimeout.QUICK.getDuration());
        eventSenderFactory.setTimeout(SENDER_TIMEOUT);
        try (EventSender eventSender = eventSenderFactory.getEventSender();){
            for (String message : messages) {
                eventSender.sendEvent((Object)message);
            }
        }
    }
}

