/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.ExecuteProcess;
import org.apache.nifi.processors.standard.util.ArgumentUtils;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class TestExecuteProcess {
    @Test
    public void testSplitArgs() {
        List nullArgs = ArgumentUtils.splitArgs(null, (char)' ');
        Assertions.assertNotNull((Object)nullArgs);
        Assertions.assertTrue((boolean)nullArgs.isEmpty());
        List zeroArgs = ArgumentUtils.splitArgs((String)"  ", (char)' ');
        Assertions.assertNotNull((Object)zeroArgs);
        Assertions.assertEquals((int)3, (int)zeroArgs.size());
        Object[] expectedArray = new String[]{"", "", ""};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])zeroArgs.toArray(new String[0]));
        List singleArg = ArgumentUtils.splitArgs((String)"    hello   ", (char)';');
        Assertions.assertEquals((int)1, (int)singleArg.size());
        Assertions.assertEquals((Object)"    hello   ", singleArg.get(0));
        List twoArg = ArgumentUtils.splitArgs((String)"   hello ;   good-bye   ", (char)';');
        Assertions.assertEquals((int)2, (int)twoArg.size());
        Assertions.assertEquals((Object)"   hello ", twoArg.get(0));
        Assertions.assertEquals((Object)"   good-bye   ", twoArg.get(1));
        List oneUnnecessarilyQuotedArg = ArgumentUtils.splitArgs((String)"  \"hello\" ", (char)';');
        Assertions.assertEquals((int)1, (int)oneUnnecessarilyQuotedArg.size());
        Assertions.assertEquals((Object)"  hello ", oneUnnecessarilyQuotedArg.get(0));
        List twoQuotedArg = ArgumentUtils.splitArgs((String)"\"   hello\" \"good   bye\"", (char)' ');
        Assertions.assertEquals((int)2, (int)twoQuotedArg.size());
        Assertions.assertEquals((Object)"   hello", twoQuotedArg.get(0));
        Assertions.assertEquals((Object)"good   bye", twoQuotedArg.get(1));
        List twoArgOneQuotedPerDelimiterArg = ArgumentUtils.splitArgs((String)"one;two;three\";\"and\";\"half\"", (char)';');
        Assertions.assertEquals((int)3, (int)twoArgOneQuotedPerDelimiterArg.size());
        Assertions.assertEquals((Object)"one", twoArgOneQuotedPerDelimiterArg.get(0));
        Assertions.assertEquals((Object)"two", twoArgOneQuotedPerDelimiterArg.get(1));
        Assertions.assertEquals((Object)"three;and;half", twoArgOneQuotedPerDelimiterArg.get(2));
        List twoArgOneWholeQuotedArgOneEmptyArg = ArgumentUtils.splitArgs((String)"one;two;\"three;and;half\";", (char)';');
        Assertions.assertEquals((int)4, (int)twoArgOneWholeQuotedArgOneEmptyArg.size());
        Assertions.assertEquals((Object)"one", twoArgOneWholeQuotedArgOneEmptyArg.get(0));
        Assertions.assertEquals((Object)"two", twoArgOneWholeQuotedArgOneEmptyArg.get(1));
        Assertions.assertEquals((Object)"three;and;half", twoArgOneWholeQuotedArgOneEmptyArg.get(2));
        Assertions.assertEquals((Object)"", twoArgOneWholeQuotedArgOneEmptyArg.get(3));
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testEcho() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "echo");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, "test-args");
        runner.setProperty(ExecuteProcess.BATCH_DURATION, "500 millis");
        runner.setProperty(ExecuteProcess.MIME_TYPE, "application/json");
        runner.run();
        List flowFiles = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        for (MockFlowFile flowFile : flowFiles) {
            System.out.println(flowFile);
            System.out.println(new String(flowFile.toByteArray()));
            flowFile.assertAttributeNotExists(CoreAttributes.MIME_TYPE.key());
        }
    }

    @Test
    public void validateProcessInterruptOnStop() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setVariable("command", "ping");
        runner.setProperty(ExecuteProcess.COMMAND, "${command}");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, "nifi.apache.org");
        runner.setProperty(ExecuteProcess.BATCH_DURATION, "500 millis");
        runner.run();
        Thread.sleep(500L);
        ExecuteProcess processor = (ExecuteProcess)runner.getProcessor();
        Field executorF = ExecuteProcess.class.getDeclaredField("executor");
        executorF.setAccessible(true);
        ExecutorService executor = (ExecutorService)executorF.get(processor);
        Assertions.assertTrue((boolean)executor.isShutdown());
        Assertions.assertTrue((boolean)executor.isTerminated());
        Field processF = ExecuteProcess.class.getDeclaredField("externalProcess");
        processF.setAccessible(true);
        Process process = (Process)processF.get(processor);
        Assertions.assertFalse((boolean)process.isAlive());
        List flowFiles = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        if (!flowFiles.isEmpty()) {
            Assertions.assertEquals((Object)"ping", (Object)((MockFlowFile)flowFiles.get(0)).getAttribute("command"));
        }
    }

    public void testBigBinaryInputData() {
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.nifi", "TRACE");
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.nifi.processors.standard", "DEBUG");
        String workingDirName = "/var/test";
        String testFile = "eclipse-java-luna-SR2-win32.zip";
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "cmd");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, " /c type " + testFile);
        runner.setProperty(ExecuteProcess.WORKING_DIR, workingDirName);
        File inFile = new File(workingDirName, testFile);
        System.out.println(inFile.getAbsolutePath());
        runner.run();
        List flowFiles = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        long totalFlowFilesSize = 0L;
        for (MockFlowFile flowFile : flowFiles) {
            System.out.println(flowFile);
            totalFlowFilesSize += flowFile.getSize();
        }
        Assertions.assertEquals((long)inFile.length(), (long)totalFlowFilesSize);
    }

    @Test
    public void testBigInputSplit() {
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.nifi", "TRACE");
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.nifi.processors.standard", "DEBUG");
        String workingDirName = "/var/test";
        String testFile = "Novo_dicion\u00e1rio_da_l\u00edngua_portuguesa_by_C\u00e2ndido_de_Figueiredo.txt";
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "cmd");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, " /c type " + testFile);
        runner.setProperty(ExecuteProcess.WORKING_DIR, workingDirName);
        runner.setProperty(ExecuteProcess.BATCH_DURATION, "150 millis");
        File inFile = new File(workingDirName, testFile);
        System.out.println(inFile.getAbsolutePath());
        ProcessContext processContext = runner.getProcessContext();
        ExecuteProcess processor = (ExecuteProcess)runner.getProcessor();
        processor.updateScheduledTrue();
        processor.setupExecutor(processContext);
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        List flowFiles = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        long totalFlowFilesSize = 0L;
        for (MockFlowFile flowFile : flowFiles) {
            totalFlowFilesSize += flowFile.getSize();
        }
        Assertions.assertEquals((long)inFile.length(), (long)totalFlowFilesSize);
    }

    @Test
    public void testNotRedirectErrorStream() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "cd");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, "does-not-exist");
        ProcessContext processContext = runner.getProcessContext();
        ExecuteProcess processor = (ExecuteProcess)runner.getProcessor();
        processor.updateScheduledTrue();
        processor.setupExecutor(processContext);
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        if (this.isCommandFailed(runner)) {
            return;
        }
        boolean expectedWarningMessages = true;
        int maxRetry = 5;
        for (int i = 0; i < 5 && runner.getLogger().getWarnMessages().size() < 1; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List warnMessages = runner.getLogger().getWarnMessages();
        String errorMsg = "If redirect error stream is false, the output should be logged as a warning so that user can notice on bulletin.";
        Assertions.assertEquals((int)1, (int)warnMessages.size(), (String)"If redirect error stream is false, the output should be logged as a warning so that user can notice on bulletin.");
        List succeeded = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        Assertions.assertEquals((int)0, (int)succeeded.size());
    }

    @Test
    public void testRedirectErrorStream() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "cd");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, "does-not-exist");
        runner.setProperty(ExecuteProcess.REDIRECT_ERROR_STREAM, "true");
        ProcessContext processContext = runner.getProcessContext();
        ExecuteProcess processor = (ExecuteProcess)runner.getProcessor();
        processor.updateScheduledTrue();
        processor.setupExecutor(processContext);
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        if (this.isCommandFailed(runner)) {
            return;
        }
        List warnMessages = runner.getLogger().getWarnMessages();
        Assertions.assertEquals((int)0, (int)warnMessages.size(), (String)"If redirect error stream is true the output should be sent as a content of flow-file.");
        List succeeded = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)succeeded.size());
    }

    @Test
    public void testRedirectErrorStreamWithExpressions() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "ls");
        runner.setProperty(ExecuteProcess.COMMAND_ARGUMENTS, "${literal('does-not-exist'):toUpper()}");
        runner.setProperty(ExecuteProcess.REDIRECT_ERROR_STREAM, "true");
        ProcessContext processContext = runner.getProcessContext();
        ExecuteProcess processor = (ExecuteProcess)runner.getProcessor();
        processor.updateScheduledTrue();
        processor.setupExecutor(processContext);
        processor.onTrigger(processContext, runner.getProcessSessionFactory());
        if (this.isCommandFailed(runner)) {
            return;
        }
        List warnMessages = runner.getLogger().getWarnMessages();
        Assertions.assertEquals((int)0, (int)warnMessages.size(), (String)"If redirect error stream is true the output should be sent as a content of flow-file.");
        List succeeded = runner.getFlowFilesForRelationship(ExecuteProcess.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)succeeded.size());
        Assertions.assertTrue((boolean)new String(((MockFlowFile)succeeded.get(0)).toByteArray()).contains("DOES-NOT-EXIST"));
        Assertions.assertEquals((Object)((MockFlowFile)succeeded.get(0)).getAttribute("command"), (Object)"ls");
        Assertions.assertEquals((Object)((MockFlowFile)succeeded.get(0)).getAttribute("command.arguments"), (Object)"DOES-NOT-EXIST");
    }

    private boolean isCommandFailed(TestRunner runner) {
        List errorMessages = runner.getLogger().getErrorMessages();
        return errorMessages.size() > 0 && errorMessages.stream().anyMatch(m -> m.getMsg().contains("Failed to create process"));
    }

    @Test
    public void testProcessorNotScheduled() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteProcess.class);
        runner.setProperty(ExecuteProcess.COMMAND, "ls");
        runner.run(0);
    }
}

