/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.CryptographicHashContent;
import org.apache.nifi.security.util.crypto.HashAlgorithm;
import org.apache.nifi.security.util.crypto.HashService;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CryptographicHashContentTest {
    private TestRunner runner;

    @BeforeAll
    static void setUpOnce() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @BeforeEach
    void setupRunner() {
        this.runner = TestRunners.newTestRunner((Processor)new CryptographicHashContent());
    }

    @Test
    void testShouldCalculateHashOfPresentContent() throws IOException {
        String longContent = StringUtils.repeat((String)"apachenifi ", (int)8192);
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String expectedContentHash = HashService.hashValueStreaming((HashAlgorithm)algorithm, (InputStream)new ByteArrayInputStream(longContent.getBytes()));
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashContent.HASH_ALGORITHM, algorithm.getName());
            this.runner.enqueue(longContent.getBytes(StandardCharsets.UTF_8), Collections.singletonMap("size", String.valueOf(longContent.length())));
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashContent.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashContent.REL_SUCCESS, 1);
            List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashContent.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            String hashAttribute = String.format("content_%s", algorithm.getName());
            flowFile.assertAttributeExists(hashAttribute);
            flowFile.assertAttributeEquals(hashAttribute, expectedContentHash);
        }
    }

    @Test
    void testShouldCalculateHashOfEmptyContent() throws IOException {
        String emptyContent = "";
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String expectedContentHash = HashService.hashValueStreaming((HashAlgorithm)algorithm, (InputStream)new ByteArrayInputStream("".getBytes()));
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashContent.HASH_ALGORITHM, algorithm.getName());
            this.runner.enqueue("".getBytes(StandardCharsets.UTF_8), Collections.singletonMap("size", "0"));
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashContent.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashContent.REL_SUCCESS, 1);
            List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashContent.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            String hashAttribute = String.format("content_%s", algorithm.getName());
            flowFile.assertAttributeExists(hashAttribute);
            String hashedContent = flowFile.getAttribute(hashAttribute);
            Assertions.assertEquals((Object)expectedContentHash, (Object)hashedContent);
        }
    }

    @Test
    void testShouldCalculateHashOfContentWithIncorrectSizeAttribute() throws IOException {
        String nonEmptyContent = "apachenifi";
        TestRunner runner = TestRunners.newTestRunner((Processor)new CryptographicHashContent());
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String expectedContentHash = HashService.hashValueStreaming((HashAlgorithm)algorithm, (InputStream)new ByteArrayInputStream("apachenifi".getBytes()));
            runner.clearProperties();
            runner.clearProvenanceEvents();
            runner.clearTransferState();
            runner.setProperty(CryptographicHashContent.HASH_ALGORITHM, algorithm.getName());
            runner.enqueue("apachenifi".getBytes(StandardCharsets.UTF_8), Collections.singletonMap("size", "0"));
            runner.run(1);
            runner.assertTransferCount(CryptographicHashContent.REL_FAILURE, 0);
            runner.assertTransferCount(CryptographicHashContent.REL_SUCCESS, 1);
            List successfulFlowfiles = runner.getFlowFilesForRelationship(CryptographicHashContent.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            String hashAttribute = String.format("content_%s", algorithm.getName());
            flowFile.assertAttributeExists(hashAttribute);
            flowFile.assertAttributeEquals(hashAttribute, expectedContentHash);
        }
    }

    @Test
    void testShouldOverwriteExistingAttribute() {
        String nonEmptyContent = "apachenifi";
        String oldHashAttributeValue = "OLD VALUE";
        HashAlgorithm algorithm = HashAlgorithm.SHA256;
        String expectedContentHash = HashService.hashValue((HashAlgorithm)algorithm, (String)"apachenifi");
        this.runner.setProperty(CryptographicHashContent.HASH_ALGORITHM, algorithm.getName());
        Map<String, String> oldAttributes = Collections.singletonMap(String.format("content_%s", algorithm.getName()), "OLD VALUE");
        this.runner.enqueue("apachenifi".getBytes(StandardCharsets.UTF_8), oldAttributes);
        this.runner.run(1);
        this.runner.assertTransferCount(CryptographicHashContent.REL_FAILURE, 0);
        this.runner.assertTransferCount(CryptographicHashContent.REL_SUCCESS, 1);
        List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashContent.REL_SUCCESS);
        MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
        String hashAttribute = String.format("content_%s", algorithm.getName());
        flowFile.assertAttributeExists(hashAttribute);
        String hashedContent = flowFile.getAttribute(hashAttribute);
        Assertions.assertNotEquals((Object)"OLD VALUE", (Object)hashedContent);
        Assertions.assertEquals((Object)expectedContentHash, (Object)hashedContent);
    }

    @Test
    void testShouldRouteToFailureOnEmptyContent() {
        String emptyContent = "";
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashContent.FAIL_WHEN_EMPTY, "true");
            this.runner.setProperty(CryptographicHashContent.HASH_ALGORITHM, algorithm.getName());
            this.runner.enqueue("".getBytes(StandardCharsets.UTF_8));
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashContent.REL_FAILURE, 1);
            this.runner.assertTransferCount(CryptographicHashContent.REL_SUCCESS, 0);
            List failedFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashContent.REL_FAILURE);
            MockFlowFile flowFile = (MockFlowFile)failedFlowfiles.get(0);
            String hashAttribute = String.format("content_%s", algorithm.getName());
            flowFile.assertAttributeNotExists(hashAttribute);
        }
    }
}

