/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.CryptographicHashAttribute;
import org.apache.nifi.security.util.crypto.HashAlgorithm;
import org.apache.nifi.security.util.crypto.HashService;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CryptographicHashAttributeTest {
    private TestRunner runner;

    @BeforeAll
    static void setUpOnce() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @BeforeEach
    void setupRunner() {
        this.runner = TestRunners.newTestRunner((Processor)new CryptographicHashAttribute());
    }

    @Test
    void testShouldCalculateHashOfPresentAttribute() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "alopresto");
        attributes.put("date", ZonedDateTime.now().format(DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss.SSS Z")));
        Set attributeKeys = attributes.keySet();
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String expectedUsernameHash = HashService.hashValue((HashAlgorithm)algorithm, (String)((String)attributes.get("username")));
            String expectedDateHash = HashService.hashValue((HashAlgorithm)algorithm, (String)((String)attributes.get("date")));
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            for (String attr : attributeKeys) {
                this.runner.setProperty(attr, String.format("%s_%s", attr, algorithm.getName()));
            }
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 1);
            List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            flowFile.assertAttributeEquals(String.format("username_%s", algorithm.getName()), expectedUsernameHash);
            flowFile.assertAttributeEquals(String.format("date_%s", algorithm.getName()), expectedDateHash);
        }
    }

    @Test
    void testShouldCalculateHashOfMissingAttribute() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "");
        attributes.put("date", null);
        Set attributeKeys = attributes.keySet();
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String expectedUsernameHash = HashService.hashValue((HashAlgorithm)algorithm, (String)((String)attributes.get("username")));
            String expectedDateHash = null;
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            for (String attr : attributeKeys) {
                this.runner.setProperty(attr, String.format("%s_%s", attr, algorithm.getName()));
            }
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 1);
            List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            flowFile.assertAttributeEquals(String.format("username_%s", algorithm.getName()), expectedUsernameHash);
            flowFile.assertAttributeEquals(String.format("date_%s", algorithm.getName()), expectedDateHash);
        }
    }

    @Test
    void testShouldRouteToFailureOnProhibitedMissingAttribute() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "");
        attributes.put("date", null);
        Set attributeKeys = attributes.keySet();
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            this.runner.setProperty(CryptographicHashAttribute.PARTIAL_ATTR_ROUTE_POLICY, CryptographicHashAttribute.PartialAttributePolicy.PROHIBIT.name());
            for (String attr : attributeKeys) {
                this.runner.setProperty(attr, String.format("%s_%s", attr, algorithm.getName()));
            }
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 0);
            List failedFlowFiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_FAILURE);
            MockFlowFile flowFile = (MockFlowFile)failedFlowFiles.get(0);
            for (String missingAttribute : attributeKeys) {
                flowFile.assertAttributeNotExists(String.format("%s_%s", missingAttribute, algorithm.getName()));
            }
        }
    }

    @Test
    void testShouldRouteToFailureOnEmptyAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "");
        attributes.put("date", null);
        Set attributeKeys = attributes.keySet();
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            this.runner.setProperty(CryptographicHashAttribute.FAIL_WHEN_EMPTY, "true");
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 0);
            List failedFlowFiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_FAILURE);
            MockFlowFile flowFile = (MockFlowFile)failedFlowFiles.get(0);
            for (String missingAttribute : attributeKeys) {
                flowFile.assertAttributeNotExists(String.format("%s_%s", missingAttribute, algorithm.getName()));
            }
        }
    }

    @Test
    void testShouldRouteToSuccessOnAllowPartial() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "");
        Set attributeKeys = attributes.keySet();
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            this.runner.setProperty(CryptographicHashAttribute.PARTIAL_ATTR_ROUTE_POLICY, CryptographicHashAttribute.PartialAttributePolicy.ALLOW.name());
            for (String attr : attributeKeys) {
                this.runner.setProperty(attr, String.format("%s_%s", attr, algorithm.getName()));
            }
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 1);
            List successfulFlowFiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowFiles.get(0);
            for (String attribute : attributeKeys) {
                flowFile.assertAttributeExists(String.format("%s_%s", attribute, algorithm.getName()));
            }
        }
    }

    @Test
    void testShouldCalculateHashWithVariousCharacterEncodings() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("test_attribute", "apachenifi");
        Set attributeKeys = attributes.keySet();
        HashAlgorithm algorithm = HashAlgorithm.MD5;
        List<Charset> charsets = Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16LE, StandardCharsets.UTF_16BE);
        HashMap<String, String> EXPECTED_MD5_HASHES = new HashMap<String, String>();
        EXPECTED_MD5_HASHES.put(StandardCharsets.UTF_8.name(), "a968b5ec1d52449963dcc517789baaaf");
        EXPECTED_MD5_HASHES.put(StandardCharsets.UTF_16.name(), "b8413d18f7e64042bb0322a1cd61eba2");
        EXPECTED_MD5_HASHES.put(StandardCharsets.UTF_16BE.name(), "b8413d18f7e64042bb0322a1cd61eba2");
        EXPECTED_MD5_HASHES.put(StandardCharsets.UTF_16LE.name(), "91c3b67f9f8ae77156f21f271cc09121");
        for (Charset charset : charsets) {
            String EXPECTED_HASH = HashService.hashValue((HashAlgorithm)algorithm, (String)((String)attributes.get("test_attribute")), (Charset)charset);
            Assertions.assertEquals((Object)EXPECTED_HASH, EXPECTED_MD5_HASHES.get(charset.name()));
            this.runner.clearProperties();
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.setProperty(CryptographicHashAttribute.HASH_ALGORITHM, algorithm.getName());
            this.runner.setProperty(CryptographicHashAttribute.CHARACTER_SET, charset.name());
            for (String attr : attributeKeys) {
                this.runner.setProperty(attr, String.format("%s_%s", attr, algorithm.getName()));
            }
            this.runner.enqueue(new byte[0], attributes);
            this.runner.run(1);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_FAILURE, 0);
            this.runner.assertTransferCount(CryptographicHashAttribute.REL_SUCCESS, 1);
            List successfulFlowfiles = this.runner.getFlowFilesForRelationship(CryptographicHashAttribute.REL_SUCCESS);
            MockFlowFile flowFile = (MockFlowFile)successfulFlowfiles.get(0);
            flowFile.assertAttributeEquals(String.format("test_attribute_%s", algorithm.getName()), EXPECTED_HASH);
        }
    }
}

