/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.PreencodedMimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
@Tags(value={"email", "put", "notify", "smtp"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Sends an e-mail to configured recipients for each incoming FlowFile")
@SupportsSensitiveDynamicProperties
@DynamicProperty(name="mail.propertyName", value="Value for a specific property to be set in the JavaMail Session object", description="Dynamic property names that will be passed to the Mail session. Possible properties can be found in: https://javaee.github.io/javamail/docs/api/com/sun/mail/smtp/package-summary.html.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="The entirety of the FlowFile's content (as a String object) will be read into memory in case the property to use the flow file content as the email body is set to true.")
public class PutEmail
extends AbstractProcessor {
    private static final Pattern MAIL_PROPERTY_PATTERN = Pattern.compile("^mail\\.smtps?\\.([a-z0-9\\.]+)$");
    public static final PropertyDescriptor SMTP_HOSTNAME = new PropertyDescriptor.Builder().name("SMTP Hostname").description("The hostname of the SMTP host").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SMTP_PORT = new PropertyDescriptor.Builder().name("SMTP Port").description("The Port used for SMTP communications").required(true).defaultValue("25").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final AllowableValue PASSWORD_BASED_AUTHORIZATION_MODE = new AllowableValue("password-based-authorization-mode", "Use Password", "Use password");
    public static final AllowableValue OAUTH_AUTHORIZATION_MODE = new AllowableValue("oauth-based-authorization-mode", "Use OAuth2", "Use OAuth2 to acquire access token");
    public static final PropertyDescriptor AUTHORIZATION_MODE = new PropertyDescriptor.Builder().name("authorization-mode").displayName("Authorization Mode").description("How to authorize sending email on the user's behalf.").required(true).allowableValues(new AllowableValue[]{PASSWORD_BASED_AUTHORIZATION_MODE, OAUTH_AUTHORIZATION_MODE}).defaultValue(PASSWORD_BASED_AUTHORIZATION_MODE.getValue()).build();
    public static final PropertyDescriptor OAUTH2_ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("oauth2-access-token-provider").displayName("OAuth2 Access Token Provider").description("OAuth2 service that can provide access tokens.").identifiesControllerService(OAuth2AccessTokenProvider.class).dependsOn(AUTHORIZATION_MODE, new AllowableValue[]{OAUTH_AUTHORIZATION_MODE}).required(true).build();
    public static final PropertyDescriptor SMTP_USERNAME = new PropertyDescriptor.Builder().name("SMTP Username").description("Username for the SMTP account").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor SMTP_PASSWORD = new PropertyDescriptor.Builder().name("SMTP Password").description("Password for the SMTP account").dependsOn(AUTHORIZATION_MODE, new AllowableValue[]{PASSWORD_BASED_AUTHORIZATION_MODE}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).sensitive(true).build();
    public static final PropertyDescriptor SMTP_AUTH = new PropertyDescriptor.Builder().name("SMTP Auth").description("Flag indicating whether authentication should be used").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").build();
    public static final PropertyDescriptor SMTP_TLS = new PropertyDescriptor.Builder().name("SMTP TLS").displayName("SMTP STARTTLS").description("Flag indicating whether Opportunistic TLS should be enabled using STARTTLS command").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor SMTP_SOCKET_FACTORY = new PropertyDescriptor.Builder().name("SMTP Socket Factory").description("Socket Factory to use for SMTP Connection").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("javax.net.ssl.SSLSocketFactory").build();
    public static final PropertyDescriptor HEADER_XMAILER = new PropertyDescriptor.Builder().name("SMTP X-Mailer Header").description("X-Mailer used in the header of the outgoing email").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("NiFi").build();
    public static final PropertyDescriptor ATTRIBUTE_NAME_REGEX = new PropertyDescriptor.Builder().name("attribute-name-regex").displayName("Attributes to Send as Headers (Regex)").description("A Regular Expression that is matched against all FlowFile attribute names. Any attribute whose name matches the regex will be added to the Email messages as a Header. If not specified, no FlowFile attributes will be added as headers.").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content Type").description("Mime Type used to interpret the contents of the email, such as text/plain or text/html").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("text/plain").build();
    public static final PropertyDescriptor FROM = new PropertyDescriptor.Builder().name("From").description("Specifies the Email address to use as the sender. Comma separated sequence of addresses following RFC822 syntax.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TO = new PropertyDescriptor.Builder().name("To").description("The recipients to include in the To-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CC = new PropertyDescriptor.Builder().name("CC").description("The recipients to include in the CC-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BCC = new PropertyDescriptor.Builder().name("BCC").description("The recipients to include in the BCC-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SUBJECT = new PropertyDescriptor.Builder().name("Subject").description("The email subject").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("Message from NiFi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MESSAGE = new PropertyDescriptor.Builder().name("Message").description("The body of the email message").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTACH_FILE = new PropertyDescriptor.Builder().name("Attach File").description("Specifies whether or not the FlowFile content should be attached to the email").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor CONTENT_AS_MESSAGE = new PropertyDescriptor.Builder().name("email-ff-content-as-message").displayName("Flow file content as message").description("Specifies whether or not the FlowFile content should be the message of the email. If true, the 'Message' property is ignored.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor INCLUDE_ALL_ATTRIBUTES = new PropertyDescriptor.Builder().name("Include All Attributes In Message").description("Specifies whether or not all FlowFile attributes should be recorded in the body of the email message").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor INPUT_CHARACTER_SET = new PropertyDescriptor.Builder().name("input-character-set").displayName("Input Character Set").description("Specifies the character set of the FlowFile contents for reading input FlowFile contents to generate the message body or as an attachment to the message. If not set, UTF-8 will be the default value.").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue(StandardCharsets.UTF_8.name()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are successfully sent will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that fail to send will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private static final Map<String, PropertyDescriptor> propertyToContext = new HashMap<String, PropertyDescriptor>();
    private volatile Pattern attributeNamePattern = null;
    private volatile Optional<OAuth2AccessTokenProvider> oauth2AccessTokenProviderOptional;
    public static final String BODY_SEPARATOR = "\n\n--------------------------------------------------\n";

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SMTP_HOSTNAME);
        properties.add(SMTP_PORT);
        properties.add(AUTHORIZATION_MODE);
        properties.add(OAUTH2_ACCESS_TOKEN_PROVIDER);
        properties.add(SMTP_USERNAME);
        properties.add(SMTP_PASSWORD);
        properties.add(SMTP_AUTH);
        properties.add(SMTP_TLS);
        properties.add(SMTP_SOCKET_FACTORY);
        properties.add(HEADER_XMAILER);
        properties.add(ATTRIBUTE_NAME_REGEX);
        properties.add(CONTENT_TYPE);
        properties.add(FROM);
        properties.add(TO);
        properties.add(CC);
        properties.add(BCC);
        properties.add(SUBJECT);
        properties.add(MESSAGE);
        properties.add(CONTENT_AS_MESSAGE);
        properties.add(INPUT_CHARACTER_SET);
        properties.add(ATTACH_FILE);
        properties.add(INCLUDE_ALL_ATTRIBUTES);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("SMTP property passed to the Mail Session").required(false).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)new DynamicMailPropertyValidator()).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(context));
        String to = context.getProperty(TO).getValue();
        String cc = context.getProperty(CC).getValue();
        String bcc = context.getProperty(BCC).getValue();
        if (to == null && cc == null && bcc == null) {
            errors.add(new ValidationResult.Builder().subject("To, CC, BCC").valid(false).explanation("Must specify at least one To/CC/BCC address").build());
        }
        return errors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        String attributeNameRegex = context.getProperty(ATTRIBUTE_NAME_REGEX).getValue();
        Pattern pattern = this.attributeNamePattern = attributeNameRegex == null ? null : Pattern.compile(attributeNameRegex);
        if (context.getProperty(OAUTH2_ACCESS_TOKEN_PROVIDER).isSet()) {
            OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)context.getProperty(OAUTH2_ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
            oauth2AccessTokenProvider.getAccessDetails();
            this.oauth2AccessTokenProviderOptional = Optional.of(oauth2AccessTokenProvider);
        } else {
            this.oauth2AccessTokenProviderOptional = Optional.empty();
        }
    }

    private void setMessageHeader(String header, String value, Message message) throws MessagingException {
        ComponentLog logger = this.getLogger();
        try {
            message.setHeader(header, MimeUtility.encodeText((String)value));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Unable to add header {} with value {} due to encoding exception", new Object[]{header, value});
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Properties properties = this.getMailPropertiesFromFlowFile(context, flowFile);
        Session mailSession = this.createMailSession(properties);
        MimeMessage message = new MimeMessage(mailSession);
        try {
            message.addFrom((Address[])this.toInetAddresses(context, flowFile, FROM));
            message.setRecipients(Message.RecipientType.TO, (Address[])this.toInetAddresses(context, flowFile, TO));
            message.setRecipients(Message.RecipientType.CC, (Address[])this.toInetAddresses(context, flowFile, CC));
            message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInetAddresses(context, flowFile, BCC));
            if (this.attributeNamePattern != null) {
                for (Map.Entry entry : flowFile.getAttributes().entrySet()) {
                    if (!this.attributeNamePattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                    this.setMessageHeader((String)entry.getKey(), (String)entry.getValue(), (Message)message);
                }
            }
            this.setMessageHeader("X-Mailer", context.getProperty(HEADER_XMAILER).evaluateAttributeExpressions(flowFile).getValue(), (Message)message);
            message.setSubject(context.getProperty(SUBJECT).evaluateAttributeExpressions(flowFile).getValue());
            String messageText = this.getMessage(flowFile, context, session);
            String contentType = context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions(flowFile).getValue();
            Charset charset = this.getCharset(context);
            message.setContent((Object)messageText, contentType + String.format("; charset=\"%s\"", MimeUtility.mimeCharset((String)charset.name())));
            message.setSentDate(new Date());
            if (context.getProperty(ATTACH_FILE).asBoolean().booleanValue()) {
                String encoding = this.getEncoding(context);
                PreencodedMimeBodyPart mimeText = new PreencodedMimeBodyPart(encoding);
                byte[] messageBytes = messageText.getBytes(charset);
                byte[] encodedMessageBytes = "base64".equals(encoding) ? Base64.encodeBase64((byte[])messageBytes) : messageBytes;
                DataHandler messageDataHandler = new DataHandler((DataSource)new ByteArrayDataSource(encodedMessageBytes, contentType + String.format("; charset=\"%s\"", MimeUtility.mimeCharset((String)charset.name()))));
                mimeText.setDataHandler(messageDataHandler);
                mimeText.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding((DataHandler)mimeText.getDataHandler()));
                MimeBodyPart mimeFile = new MimeBodyPart();
                session.read(flowFile, stream -> {
                    try {
                        mimeFile.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(stream, "application/octet-stream")));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                });
                mimeFile.setFileName(MimeUtility.encodeText((String)flowFile.getAttribute(CoreAttributes.FILENAME.key()), (String)charset.name(), null));
                mimeFile.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding((DataHandler)mimeFile.getDataHandler()));
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)mimeText);
                multipart.addBodyPart((BodyPart)mimeFile);
                message.setContent((Multipart)multipart);
            } else {
                message.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding((DataHandler)message.getDataHandler()));
            }
            message.saveChanges();
            this.send((Message)message);
            session.getProvenanceReporter().send(flowFile, "mailto:" + message.getAllRecipients()[0].toString());
            session.transfer(flowFile, REL_SUCCESS);
            this.getLogger().debug("Sent email as a result of receiving {}", new Object[]{flowFile});
        }
        catch (MessagingException | IOException | ProcessException e) {
            context.yield();
            this.getLogger().error("Failed to send email for {}: {}; routing to failure", new Object[]{flowFile, e.getMessage(), e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private String getMessage(FlowFile flowFile, ProcessContext context, ProcessSession session) {
        String messageText = "";
        if (context.getProperty(CONTENT_AS_MESSAGE).evaluateAttributeExpressions(flowFile).asBoolean().booleanValue()) {
            byte[] byteBuffer = new byte[(int)flowFile.getSize()];
            session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])byteBuffer, (boolean)false));
            Charset charset = this.getCharset(context);
            messageText = new String(byteBuffer, 0, byteBuffer.length, charset);
        } else if (context.getProperty(MESSAGE).isSet()) {
            messageText = context.getProperty(MESSAGE).evaluateAttributeExpressions(flowFile).getValue();
        }
        if (context.getProperty(INCLUDE_ALL_ATTRIBUTES).asBoolean().booleanValue()) {
            return PutEmail.formatAttributes(flowFile, messageText);
        }
        return messageText;
    }

    private Session createMailSession(final Properties properties) {
        boolean auth = Boolean.parseBoolean(properties.getProperty("mail.smtp.auth"));
        return auth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                String username = properties.getProperty("mail.smtp.user");
                String password = properties.getProperty("mail.smtp.password");
                return new PasswordAuthentication(username, password);
            }
        }) : Session.getInstance((Properties)properties);
    }

    private Properties getMailPropertiesFromFlowFile(ProcessContext context, FlowFile flowFile) {
        Properties properties = new Properties();
        for (Map.Entry<String, PropertyDescriptor> entry : propertyToContext.entrySet()) {
            String flowFileValue = context.getProperty(entry.getValue()).evaluateAttributeExpressions(flowFile).getValue();
            String property = entry.getKey();
            if (null == flowFileValue) continue;
            properties.setProperty(property, flowFileValue);
        }
        this.oauth2AccessTokenProviderOptional.ifPresent(oAuth2AccessTokenProvider -> {
            String accessToken = oAuth2AccessTokenProvider.getAccessDetails().getAccessToken();
            properties.setProperty("mail.smtp.password", accessToken);
            properties.put("mail.smtp.auth.mechanisms", "XOAUTH2");
        });
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            String mailPropertyValue;
            if (!descriptor.isDynamic() || null == (mailPropertyValue = context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue())) continue;
            properties.setProperty(descriptor.getName(), mailPropertyValue);
        }
        return properties;
    }

    private static String formatAttributes(FlowFile flowFile, String messagePrepend) {
        StringBuilder message = new StringBuilder(messagePrepend);
        message.append(BODY_SEPARATOR);
        message.append("\nStandard FlowFile Metadata:");
        message.append(String.format("\n\t%1$s = '%2$s'", "id", flowFile.getAttribute(CoreAttributes.UUID.key())));
        message.append(String.format("\n\t%1$s = '%2$s'", "entryDate", new Date(flowFile.getEntryDate())));
        message.append(String.format("\n\t%1$s = '%2$s'", "fileSize", flowFile.getSize()));
        message.append("\nFlowFile Attributes:");
        for (Map.Entry attribute : flowFile.getAttributes().entrySet()) {
            message.append(String.format("\n\t%1$s = '%2$s'", attribute.getKey(), attribute.getValue()));
        }
        message.append("\n");
        return message.toString();
    }

    private InternetAddress[] toInetAddresses(ProcessContext context, FlowFile flowFile, PropertyDescriptor propertyDescriptor) throws AddressException {
        InternetAddress[] parse;
        String value = context.getProperty(propertyDescriptor).evaluateAttributeExpressions(flowFile).getValue();
        if (value == null || value.isEmpty()) {
            if (propertyDescriptor.isRequired()) {
                String exceptionMsg = "Required property '" + propertyDescriptor.getDisplayName() + "' evaluates to an empty string.";
                throw new AddressException(exceptionMsg);
            }
            parse = new InternetAddress[]{};
        } else {
            try {
                parse = InternetAddress.parse((String)value);
            }
            catch (AddressException e) {
                String exceptionMsg = "Unable to parse a valid address for property '" + propertyDescriptor.getDisplayName() + "' with value '" + value + "'";
                throw new AddressException(exceptionMsg);
            }
        }
        return parse;
    }

    protected void send(Message msg) throws MessagingException {
        Transport.send((Message)msg);
    }

    private Charset getCharset(ProcessContext context) {
        return Charset.forName(context.getProperty(INPUT_CHARACTER_SET).getValue());
    }

    private String getEncoding(ProcessContext context) {
        Charset charset = Charset.forName(context.getProperty(INPUT_CHARACTER_SET).getValue());
        if (Charset.forName("US-ASCII").equals(charset)) {
            return "7bit";
        }
        return "base64";
    }

    static {
        propertyToContext.put("mail.smtp.host", SMTP_HOSTNAME);
        propertyToContext.put("mail.smtp.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.socketFactory.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.socketFactory.class", SMTP_SOCKET_FACTORY);
        propertyToContext.put("mail.smtp.auth", SMTP_AUTH);
        propertyToContext.put("mail.smtp.starttls.enable", SMTP_TLS);
        propertyToContext.put("mail.smtp.user", SMTP_USERNAME);
        propertyToContext.put("mail.smtp.password", SMTP_PASSWORD);
    }

    private static class DynamicMailPropertyValidator
    implements Validator {
        private DynamicMailPropertyValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            Matcher matcher = MAIL_PROPERTY_PATTERN.matcher(subject);
            if (!matcher.matches()) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(String.format("[%s] does not start with mail.smtp", subject)).build();
            }
            if (propertyToContext.containsKey(subject)) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(String.format("[%s] overwrites standard properties", subject)).build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).explanation("Valid mail.smtp property found").build();
        }
    }
}

