/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.VersionInfo;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.InvokeHTTP;
import org.apache.nifi.processors.standard.util.HTTPUtils;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.LeakyBucketStreamThrottler;
import org.apache.nifi.stream.io.StreamThrottler;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.apache.nifi.util.FlowFilePackagerV2;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;

@Deprecated
@DeprecationNotice(alternatives={InvokeHTTP.class}, reason="This processor is deprecated and may be removed in future releases.")
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"http", "https", "remote", "copy", "archive"})
@CapabilityDescription(value="Please be aware this processor is deprecated and may be removed in the near future. Use InvokeHTTP instead. Performs an HTTP Post with the content of the FlowFile. Uses a connection pool with max number of connections equal to the number of possible endpoints multiplied by the Concurrent Tasks configuration.")
public class PostHTTP
extends AbstractProcessor {
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String FLOWFILE_CONFIRMATION_HEADER = "x-prefer-acknowledge-uri";
    public static final String LOCATION_HEADER_NAME = "Location";
    public static final String LOCATION_URI_INTENT_NAME = "x-location-uri-intent";
    public static final String LOCATION_URI_INTENT_VALUE = "flowfile-hold";
    public static final String GZIPPED_HEADER = "flowfile-gzipped";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String CONTENT_ENCODING_GZIP_VALUE = "gzip";
    public static final String PROTOCOL_VERSION_HEADER = "x-nifi-transfer-protocol-version";
    public static final String TRANSACTION_ID_HEADER = "x-nifi-transaction-id";
    public static final String PROTOCOL_VERSION = "3";
    public static final String REMOTE_DN = "remote.dn";
    private static final String FLOW_FILE_CONNECTION_LOG = "Connection to URI {} will be using Content Type {} if sending data as FlowFile";
    public static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("URL").description("The URL to POST to. The URL may be defined using the Attribute Expression Language. A separate connection pool will be created for each unique host:port combination.").required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("https?\\://.*"))).addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SEND_AS_FLOWFILE = new PropertyDescriptor.Builder().name("Send as FlowFile").description("If true, will package the FlowFile's contents and attributes together and send the FlowFile Package; otherwise, will send only the FlowFile's content").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("How long to wait when attempting to connect to the remote server before giving up").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor DATA_TIMEOUT = new PropertyDescriptor.Builder().name("Data Timeout").description("How long to wait between receiving segments of data from the remote server before giving up and discarding the partial file").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username required to access the URL").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password required to access the URL").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_AGENT = new PropertyDescriptor.Builder().name("User Agent").description("What to report as the User Agent when we connect to the remote server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue(VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class)).build();
    public static final PropertyDescriptor COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Compression Level").description("Determines the GZIP Compression Level to use when sending the file; the value must be in the range of 0-9. A value of 0 indicates that the file will not be GZIP'ed").required(true).addValidator(StandardValidators.createLongValidator((long)0L, (long)9L, (boolean)true)).defaultValue("0").build();
    public static final PropertyDescriptor ATTRIBUTES_AS_HEADERS_REGEX = new PropertyDescriptor.Builder().name("Attributes to Send as HTTP Headers (Regex)").description("Specifies the Regular Expression that determines the names of FlowFile attributes that should be sent as HTTP Headers").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    public static final PropertyDescriptor MAX_DATA_RATE = new PropertyDescriptor.Builder().name("Max Data to Post per Second").description("The maximum amount of data to send per second; this allows the bandwidth to be throttled to a specified data rate; if not specified, the data rate is not throttled").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("Max Batch Size").description("If the Send as FlowFile property is true, specifies the max data size for a batch of FlowFiles to send in a single HTTP POST. If not specified, each FlowFile will be sent separately. If the Send as FlowFile property is false, this property is ignored").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("100 MB").build();
    public static final PropertyDescriptor CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("Use Chunked Encoding").description("Specifies whether or not to use Chunked Encoding to send the data. This property is ignored in the event the contents are compressed or sent as FlowFiles.").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content-Type").description("The Content-Type to specify for the content of the FlowFile being POSTed if " + SEND_AS_FLOWFILE.getName() + " is false. In the case of an empty value after evaluating an expression language expression, Content-Type defaults to application/octet-stream").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${" + CoreAttributes.MIME_TYPE.key() + "}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that are successfully send will be transferred to success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that fail to send will transferred to failure").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<StreamThrottler> throttlerRef = new AtomicReference();
    private final ConcurrentMap<String, DestinationAccepts> destinationAcceptsMap = new ConcurrentHashMap<String, DestinationAccepts>();
    private volatile PoolingHttpClientConnectionManager connManager;
    private volatile CloseableHttpClient client;
    private volatile RequestConfig requestConfig;
    private volatile Principal principal;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(MAX_BATCH_SIZE);
        properties.add(MAX_DATA_RATE);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(USERNAME);
        properties.add(PASSWORD);
        properties.add(SEND_AS_FLOWFILE);
        properties.add(CHUNKED_ENCODING);
        properties.add(COMPRESSION_LEVEL);
        properties.add(CONNECTION_TIMEOUT);
        properties.add(DATA_TIMEOUT);
        properties.add(ATTRIBUTES_AS_HEADERS_REGEX);
        properties.add(USER_AGENT);
        properties.add(HTTPUtils.PROXY_CONFIGURATION_SERVICE);
        properties.add(HTTPUtils.PROXY_HOST);
        properties.add(HTTPUtils.PROXY_PORT);
        properties.add(CONTENT_TYPE);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (context.getProperty(URL).getValue().startsWith("https") && context.getProperty(SSL_CONTEXT_SERVICE).getValue() == null) {
            results.add(new ValidationResult.Builder().explanation("URL is set to HTTPS protocol but no SSLContext has been specified").valid(false).subject("SSL Context").build());
        }
        boolean sendAsFlowFile = context.getProperty(SEND_AS_FLOWFILE).asBoolean();
        int compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
        boolean chunkedSet = context.getProperty(CHUNKED_ENCODING).isSet();
        if (compressionLevel == 0 && !sendAsFlowFile && !chunkedSet) {
            results.add(new ValidationResult.Builder().valid(false).subject(CHUNKED_ENCODING.getName()).explanation("if compression level is 0 and not sending as a FlowFile, then the '" + CHUNKED_ENCODING.getName() + "' property must be set").build());
        }
        HTTPUtils.validateProxyProperties(context, results);
        return results;
    }

    @OnStopped
    public void onStopped() {
        this.destinationAcceptsMap.clear();
        try {
            this.connManager.shutdown();
            this.client.close();
        }
        catch (IOException e) {
            this.getLogger().error("Could not properly shutdown connections", (Throwable)e);
        }
        StreamThrottler throttler = this.throttlerRef.getAndSet(null);
        if (throttler != null) {
            try {
                throttler.close();
            }
            catch (IOException e) {
                this.getLogger().error("Failed to close StreamThrottler", (Throwable)e);
            }
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        Double bytesPerSecond = context.getProperty(MAX_DATA_RATE).asDataSize(DataUnit.B);
        this.throttlerRef.set((StreamThrottler)(bytesPerSecond == null ? null : new LeakyBucketStreamThrottler(bytesPerSecond.intValue())));
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.principal = new X500Principal("CN=" + hostname + ", OU=unknown, O=unknown, C=unknown");
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService == null) {
            this.connManager = new PoolingHttpClientConnectionManager();
        } else {
            SSLContext sslContext;
            try {
                sslContext = sslContextService.createContext();
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
            this.connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        }
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(context.getProperty(CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        SocketConfig socketConfig = socketConfigBuilder.build();
        this.connManager.setDefaultSocketConfig(socketConfig);
        this.connManager.setDefaultMaxPerRoute(context.getMaxConcurrentTasks() + 1);
        this.connManager.setMaxTotal(1);
        this.connManager.setValidateAfterInactivity(30000);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)this.connManager);
        clientBuilder.setUserAgent(context.getProperty(USER_AGENT).getValue());
        clientBuilder.addInterceptorFirst(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
                ManagedHttpClientConnection conn = (ManagedHttpClientConnection)coreContext.getConnection(ManagedHttpClientConnection.class);
                if (!conn.isOpen()) {
                    return;
                }
                SSLSession sslSession = conn.getSSLSession();
                if (sslSession != null) {
                    Certificate[] certChain = sslSession.getPeerCertificates();
                    if (certChain == null || certChain.length == 0) {
                        throw new SSLPeerUnverifiedException("No certificates found");
                    }
                    X509Certificate cert = (X509Certificate)certChain[0];
                    httpContext.setAttribute(PostHTTP.REMOTE_DN, (Object)cert.getSubjectDN().getName().trim());
                }
            }
        });
        HttpRequestRetryHandler retryHandler = (exception, attempt, httpContext) -> {
            if (attempt > 3 || !this.isScheduled()) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
            if (exception instanceof NoHttpResponseException) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Sleeping for 5 secs then retrying {} request for remote server {}", new Object[]{clientContext.getRequest().getRequestLine().getMethod(), clientContext.getTargetHost()});
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
                return true;
            }
            return false;
        };
        clientBuilder.setRetryHandler(retryHandler);
        clientBuilder.disableContentCompression();
        String username = context.getProperty(USERNAME).getValue();
        String password = context.getProperty(PASSWORD).getValue();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (username != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        HTTPUtils.setProxy(context, clientBuilder, (CredentialsProvider)credentialsProvider);
        this.client = clientBuilder.build();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectionRequestTimeout(context.getProperty(DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        requestConfigBuilder.setConnectTimeout(context.getProperty(CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        requestConfigBuilder.setRedirectsEnabled(false);
        requestConfigBuilder.setSocketTimeout(context.getProperty(DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        this.requestConfig = requestConfigBuilder.build();
    }

    private String getBaseUrl(String url) {
        int index = url.indexOf("/", 9);
        if (index < 0) {
            return url;
        }
        return url.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrigger(final ProcessContext context, final ProcessSession session) {
        Object locationUriHeader;
        long uploadMillis;
        String uploadDataRate;
        String contentType;
        Object flowFileDescription;
        DestinationAccepts accepts;
        HttpPost post;
        HttpClientContext httpClientContext;
        String transactionId;
        AtomicLong bytesToSend;
        int compressionLevel;
        boolean sendAsFlowFile;
        ArrayList<FlowFile> toSend;
        String url;
        ComponentLog logger;
        block74: {
            block76: {
                block77: {
                    FlowFile firstFlowFile = session.get();
                    if (firstFlowFile == null) {
                        return;
                    }
                    logger = this.getLogger();
                    url = context.getProperty(URL).evaluateAttributeExpressions(firstFlowFile).getValue();
                    try {
                        new URL(url);
                    }
                    catch (MalformedURLException e) {
                        logger.error("After substituting attribute values for {}, URL is {}; this is not a valid URL, so routing to failure", new Object[]{firstFlowFile, url});
                        firstFlowFile = session.penalize(firstFlowFile);
                        session.transfer(firstFlowFile, REL_FAILURE);
                        return;
                    }
                    toSend = new ArrayList<FlowFile>();
                    toSend.add(firstFlowFile);
                    sendAsFlowFile = context.getProperty(SEND_AS_FLOWFILE).asBoolean();
                    compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                    final StreamThrottler throttler = this.throttlerRef.get();
                    final Double maxBatchBytes = context.getProperty(MAX_BATCH_SIZE).asDataSize(DataUnit.B);
                    bytesToSend = new AtomicLong(firstFlowFile.getSize());
                    DestinationAccepts destinationAccepts = null;
                    transactionId = UUID.randomUUID().toString();
                    httpClientContext = HttpClientContext.create();
                    httpClientContext.setUserToken((Object)this.principal);
                    String baseUrl = this.getBaseUrl(url);
                    destinationAccepts = (DestinationAccepts)this.destinationAcceptsMap.get(baseUrl);
                    if (destinationAccepts == null) {
                        try {
                            destinationAccepts = this.getDestinationAcceptance(sendAsFlowFile, url, transactionId, (HttpContext)httpClientContext);
                            if (null == this.destinationAcceptsMap.putIfAbsent(baseUrl, destinationAccepts)) {
                                this.connManager.setMaxTotal(this.connManager.getMaxTotal() + this.connManager.getDefaultMaxPerRoute());
                            }
                        }
                        catch (IOException e) {
                            firstFlowFile = session.penalize(firstFlowFile);
                            session.transfer(firstFlowFile, REL_FAILURE);
                            logger.error("Unable to communicate with destination {} to determine whether or not it can accept flowfiles/gzip; routing {} to failure", new Object[]{url, firstFlowFile, e});
                            return;
                        }
                    }
                    if (sendAsFlowFile && (destinationAccepts.isFlowFileV3Accepted() || destinationAccepts.isFlowFileV2Accepted())) {
                        toSend.addAll(session.get(new FlowFileFilter(){

                            public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
                                if ((double)(bytesToSend.get() + flowFile.getSize()) > maxBatchBytes) {
                                    return FlowFileFilter.FlowFileFilterResult.REJECT_AND_TERMINATE;
                                }
                                String urlToCheck = context.getProperty(URL).evaluateAttributeExpressions(flowFile).getValue();
                                if (url.equals(urlToCheck)) {
                                    bytesToSend.addAndGet(flowFile.getSize());
                                    return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
                                }
                                return FlowFileFilter.FlowFileFilterResult.REJECT_AND_CONTINUE;
                            }
                        }));
                    }
                    post = new HttpPost(url);
                    accepts = destinationAccepts;
                    final boolean isDestinationLegacyNiFi = accepts.getProtocolVersion() == null;
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream rawOut) throws IOException {
                            OutputStream throttled = throttler == null ? rawOut : throttler.newThrottledOutputStream(rawOut);
                            BufferedOutputStream wrappedOut = new BufferedOutputStream(throttled);
                            if (compressionLevel > 0 && accepts.isGzipAccepted()) {
                                wrappedOut = new GZIPOutputStream((OutputStream)wrappedOut, compressionLevel);
                            }
                            try (BufferedOutputStream out = wrappedOut;){
                                Object packager = !sendAsFlowFile ? null : (accepts.isFlowFileV3Accepted() ? new FlowFilePackagerV3() : (accepts.isFlowFileV2Accepted() ? new FlowFilePackagerV2() : (accepts.isFlowFileV1Accepted() ? new FlowFilePackagerV1() : null)));
                                for (FlowFile flowFile : toSend) {
                                    session.read(flowFile, new InputStreamCallback((FlowFilePackager)packager, out, flowFile){
                                        final /* synthetic */ FlowFilePackager val$packager;
                                        final /* synthetic */ OutputStream val$out;
                                        final /* synthetic */ FlowFile val$flowFile;
                                        {
                                            this.val$packager = flowFilePackager;
                                            this.val$out = outputStream;
                                            this.val$flowFile = flowFile;
                                        }

                                        public void process(InputStream rawIn) throws IOException {
                                            try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                                                if (this.val$packager == null) {
                                                    StreamUtils.copy((InputStream)in, (OutputStream)this.val$out);
                                                } else {
                                                    HashMap<String, String> flowFileAttributes;
                                                    if (isDestinationLegacyNiFi) {
                                                        flowFileAttributes = new HashMap<String, String>(this.val$flowFile.getAttributes());
                                                        flowFileAttributes.put("nf.file.name", this.val$flowFile.getAttribute(CoreAttributes.FILENAME.key()));
                                                        flowFileAttributes.put("nf.file.path", this.val$flowFile.getAttribute(CoreAttributes.PATH.key()));
                                                    } else {
                                                        flowFileAttributes = this.val$flowFile.getAttributes();
                                                    }
                                                    this.val$packager.packageFlowFile((InputStream)in, this.val$out, flowFileAttributes, this.val$flowFile.getSize());
                                                }
                                            }
                                        }
                                    });
                                }
                                ((OutputStream)out).flush();
                            }
                            catch (ProcessException pe) {
                                Throwable t = pe.getCause();
                                if (t != null && t instanceof IOException) {
                                    IOException ioe = new IOException(t.getMessage());
                                    ioe.setStackTrace(t.getStackTrace());
                                    throw ioe;
                                }
                                throw pe;
                            }
                        }
                    }){

                        public long getContentLength() {
                            if (compressionLevel == 0 && !sendAsFlowFile && !context.getProperty(CHUNKED_ENCODING).asBoolean().booleanValue()) {
                                return ((FlowFile)toSend.get(0)).getSize();
                            }
                            return -1L;
                        }
                    };
                    Object object = flowFileDescription = toSend.size() <= 10 ? ((Object)toSend).toString() : toSend.size() + " FlowFiles";
                    if (context.getProperty(CHUNKED_ENCODING).isSet()) {
                        entity.setChunked(context.getProperty(CHUNKED_ENCODING).asBoolean().booleanValue());
                    }
                    post.setEntity((HttpEntity)entity);
                    post.setConfig(this.requestConfig);
                    if (!sendAsFlowFile) break block76;
                    if (!accepts.isFlowFileV3Accepted()) break block77;
                    contentType = StandardFlowFileMediaType.VERSION_3.getMediaType();
                    break block74;
                }
                if (accepts.isFlowFileV2Accepted()) {
                    contentType = StandardFlowFileMediaType.VERSION_2.getMediaType();
                    break block74;
                } else if (accepts.isFlowFileV1Accepted()) {
                    contentType = StandardFlowFileMediaType.VERSION_1.getMediaType();
                    break block74;
                } else {
                    logger.error("Cannot send {} to {} because the destination does not accept FlowFiles and this processor is configured to deliver FlowFiles; routing to failure", new Object[]{flowFileDescription, url});
                    Iterator iterator = toSend.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        FlowFile flowFile = (FlowFile)iterator.next();
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, REL_FAILURE);
                    }
                }
            }
            String contentTypeValue = context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions((FlowFile)toSend.get(0)).getValue();
            contentType = StringUtils.isBlank((String)contentTypeValue) ? DEFAULT_CONTENT_TYPE : contentTypeValue;
        }
        String attributeHeaderRegex = context.getProperty(ATTRIBUTES_AS_HEADERS_REGEX).getValue();
        if (attributeHeaderRegex != null && !sendAsFlowFile && toSend.size() == 1) {
            Pattern pattern = Pattern.compile(attributeHeaderRegex);
            Map attributes = ((FlowFile)toSend.get(0)).getAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                if (!pattern.matcher(key).matches()) continue;
                post.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        post.setHeader(CONTENT_TYPE_HEADER, contentType);
        post.setHeader(FLOWFILE_CONFIRMATION_HEADER, "true");
        post.setHeader(PROTOCOL_VERSION_HEADER, PROTOCOL_VERSION);
        post.setHeader(TRANSACTION_ID_HEADER, transactionId);
        if (compressionLevel > 0 && accepts.isGzipAccepted()) {
            if (sendAsFlowFile) {
                post.setHeader(GZIPPED_HEADER, "true");
            } else {
                post.setHeader(CONTENT_ENCODING_HEADER, CONTENT_ENCODING_GZIP_VALUE);
            }
        }
        CloseableHttpResponse response = null;
        try {
            StopWatch stopWatch = new StopWatch(true);
            response = this.client.execute((HttpUriRequest)post, (HttpContext)httpClientContext);
            stopWatch.stop();
            uploadDataRate = stopWatch.calculateDataRate(bytesToSend.get());
            uploadMillis = stopWatch.getDuration(TimeUnit.MILLISECONDS);
        }
        catch (IOException | ProcessException e) {
            logger.error("Failed to Post {} transferring to failure", new Object[]{flowFileDescription, e});
            Iterator iterator = toSend.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                FlowFile flowFile = (FlowFile)iterator.next();
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
        int responseCode = response.getStatusLine().getStatusCode();
        String responseReason = response.getStatusLine().getReasonPhrase();
        String holdUri = null;
        if (responseCode == 303) {
            Object holdUriHeader;
            locationUriHeader = response.getFirstHeader(LOCATION_URI_INTENT_NAME);
            if (locationUriHeader != null && LOCATION_URI_INTENT_VALUE.equals(locationUriHeader.getValue()) && (holdUriHeader = response.getFirstHeader(LOCATION_HEADER_NAME)) != null) {
                holdUri = holdUriHeader.getValue();
            }
            if (holdUri == null) {
                logger.error("Failed to Post {} to {}: sent content and received status code {}:{} but no Hold URI", new Object[]{flowFileDescription, url, responseCode, responseReason});
                holdUriHeader = toSend.iterator();
                while (true) {
                    if (!holdUriHeader.hasNext()) {
                        return;
                    }
                    FlowFile flowFile = (FlowFile)holdUriHeader.next();
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                }
            }
        }
        if (holdUri == null) {
            FlowFile flowFile;
            if (responseCode == 503) {
                logger.error("Failed to Post {} to {}: response code was {}:{}", new Object[]{flowFileDescription, url, responseCode, responseReason});
                locationUriHeader = toSend.iterator();
                while (true) {
                    if (!locationUriHeader.hasNext()) {
                        return;
                    }
                    flowFile = (FlowFile)locationUriHeader.next();
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                }
            }
            if (responseCode >= 300) {
                logger.error("Failed to Post {} to {}: response code was {}:{}", new Object[]{flowFileDescription, url, responseCode, responseReason});
                locationUriHeader = toSend.iterator();
                while (true) {
                    if (!locationUriHeader.hasNext()) {
                        return;
                    }
                    flowFile = (FlowFile)locationUriHeader.next();
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                }
            }
            logger.info("Successfully Posted {} to {} in {} at a rate of {}", new Object[]{flowFileDescription, url, FormatUtils.formatMinutesSeconds((long)uploadMillis, (TimeUnit)TimeUnit.MILLISECONDS), uploadDataRate});
            locationUriHeader = toSend.iterator();
            while (true) {
                if (!locationUriHeader.hasNext()) {
                    return;
                }
                flowFile = (FlowFile)locationUriHeader.next();
                session.getProvenanceReporter().send(flowFile, url, "Remote DN=" + httpClientContext.getAttribute(REMOTE_DN), uploadMillis, true);
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        Object fullHoldUri = holdUri;
        if (holdUri.startsWith("/contentListener")) {
            fullHoldUri = url + holdUri.substring(16);
        } else if (holdUri.startsWith("/")) {
            int firstSlash = url.indexOf("/", 8);
            if (firstSlash < 0) {
                firstSlash = url.length();
            }
            String beforeSlash = url.substring(0, firstSlash);
            fullHoldUri = beforeSlash + holdUri;
        } else if (!holdUri.startsWith("http")) {
            fullHoldUri = url + (url.endsWith("/") ? "" : "/") + holdUri;
        }
        HttpDelete delete = new HttpDelete((String)fullHoldUri);
        delete.setHeader(TRANSACTION_ID_HEADER, transactionId);
        delete.setConfig(this.requestConfig);
        CloseableHttpResponse holdResponse = null;
        try {
            holdResponse = this.client.execute((HttpUriRequest)delete, (HttpContext)httpClientContext);
            int holdStatusCode = holdResponse.getStatusLine().getStatusCode();
            String holdReason = holdResponse.getStatusLine().getReasonPhrase();
            if (holdStatusCode >= 300) {
                logger.error("Failed to delete Hold that destination placed on {}: got response code {}:{}; routing to failure", new Object[]{flowFileDescription, holdStatusCode, holdReason});
                Iterator iterator = toSend.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    FlowFile flowFile = (FlowFile)iterator.next();
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                }
            }
            logger.info("Successfully Posted {} to {} in {} at a rate of {}", new Object[]{flowFileDescription, url, FormatUtils.formatMinutesSeconds((long)uploadMillis, (TimeUnit)TimeUnit.MILLISECONDS), uploadDataRate});
            for (FlowFile flowFile : toSend) {
                session.getProvenanceReporter().send(flowFile, url, "Remote DN=" + httpClientContext.getAttribute(REMOTE_DN), uploadMillis, true);
                session.transfer(flowFile, REL_SUCCESS);
            }
            return;
        }
        catch (IOException e) {
            logger.warn("Failed to delete Hold that destination placed on, routing to failure", new Object[]{flowFileDescription, e});
            for (FlowFile flowFile : toSend) {
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
            }
            return;
        }
        finally {
            if (null != holdResponse) {
                try {
                    EntityUtils.consume((HttpEntity)holdResponse.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private DestinationAccepts getDestinationAcceptance(boolean sendAsFlowFile, String uri, String transactionId, HttpContext httpContext) throws IOException {
        HttpHead head = new HttpHead(uri);
        head.setConfig(this.requestConfig);
        if (sendAsFlowFile) {
            head.addHeader(TRANSACTION_ID_HEADER, transactionId);
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)head, httpContext);
        boolean acceptsFlowFileV1 = sendAsFlowFile;
        boolean acceptsFlowFileV2 = false;
        boolean acceptsFlowFileV3 = false;
        boolean acceptsGzip = false;
        Integer protocolVersion = null;
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == Response.Status.METHOD_NOT_ALLOWED.getStatusCode()) {
            return new DestinationAccepts(acceptsFlowFileV3, acceptsFlowFileV2, acceptsFlowFileV1, false, null);
        }
        if (statusCode == Response.Status.OK.getStatusCode()) {
            Header[] headers = response.getHeaders(ACCEPT);
            if (sendAsFlowFile) {
                Header destinationVersion;
                if (headers != null) {
                    for (Header header : headers) {
                        for (String accepted : header.getValue().split(",")) {
                            String trimmed = accepted.trim();
                            if (trimmed.equals(StandardFlowFileMediaType.VERSION_3.getMediaType())) {
                                acceptsFlowFileV3 = true;
                                continue;
                            }
                            if (!trimmed.equals(StandardFlowFileMediaType.VERSION_2.getMediaType())) continue;
                            acceptsFlowFileV2 = true;
                        }
                    }
                }
                if ((destinationVersion = response.getFirstHeader(PROTOCOL_VERSION_HEADER)) != null) {
                    try {
                        protocolVersion = Integer.valueOf(destinationVersion.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    if (acceptsFlowFileV3) {
                        this.getLogger().debug(FLOW_FILE_CONNECTION_LOG, new Object[]{uri, StandardFlowFileMediaType.VERSION_3.getMediaType()});
                    } else if (acceptsFlowFileV2) {
                        this.getLogger().debug(FLOW_FILE_CONNECTION_LOG, new Object[]{uri, StandardFlowFileMediaType.VERSION_2.getMediaType()});
                    } else if (acceptsFlowFileV1) {
                        this.getLogger().debug(FLOW_FILE_CONNECTION_LOG, new Object[]{uri, StandardFlowFileMediaType.VERSION_1.getMediaType()});
                    }
                }
            }
            if ((headers = response.getHeaders(ACCEPT_ENCODING)) != null) {
                for (Header header : headers) {
                    for (String accepted : header.getValue().split(",")) {
                        if (!accepted.equalsIgnoreCase(CONTENT_ENCODING_GZIP_VALUE)) continue;
                        acceptsGzip = true;
                    }
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                if (acceptsGzip) {
                    this.getLogger().debug("Connection to URI " + uri + " indicates that inline GZIP compression is supported");
                } else {
                    this.getLogger().debug("Connection to URI " + uri + " indicates that it does NOT support inline GZIP compression");
                }
            }
            return new DestinationAccepts(acceptsFlowFileV3, acceptsFlowFileV2, acceptsFlowFileV1, acceptsGzip, protocolVersion);
        }
        this.getLogger().warn("Unable to communicate with destination; when attempting to perform an HTTP HEAD, got unexpected response code of " + statusCode + ": " + response.getStatusLine().getReasonPhrase());
        return new DestinationAccepts(false, false, false, false, null);
    }

    private static class DestinationAccepts {
        private final boolean flowFileV1;
        private final boolean flowFileV2;
        private final boolean flowFileV3;
        private final boolean gzip;
        private final Integer protocolVersion;

        public DestinationAccepts(boolean flowFileV3, boolean flowFileV2, boolean flowFileV1, boolean gzip, Integer protocolVersion) {
            this.flowFileV3 = flowFileV3;
            this.flowFileV2 = flowFileV2;
            this.flowFileV1 = flowFileV1;
            this.gzip = gzip;
            this.protocolVersion = protocolVersion;
        }

        public boolean isFlowFileV3Accepted() {
            return this.flowFileV3;
        }

        public boolean isFlowFileV2Accepted() {
            return this.flowFileV2;
        }

        public boolean isFlowFileV1Accepted() {
            return this.flowFileV1;
        }

        public boolean isGzipAccepted() {
            return this.gzip;
        }

        public Integer getProtocolVersion() {
            return this.protocolVersion;
        }
    }
}

