/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockPropertyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSFTPTransfer {
    private static final int FILE_MASK_UNKNOWN_777 = Integer.parseInt("000777", 8);
    private static final int FILE_MASK_REGULAR_777 = Integer.parseInt("100777", 8);
    private static final PropertyValue BOOLEAN_FALSE_PROPERTY_VALUE = new MockPropertyValue(Boolean.FALSE.toString());
    private static final PropertyValue BOOLEAN_TRUE_PROPERTY_VALUE = new MockPropertyValue(Boolean.TRUE.toString());

    private SFTPTransfer createSftpTransfer(ProcessContext processContext, final SFTPClient sftpClient) {
        ComponentLog componentLog = (ComponentLog)Mockito.mock(ComponentLog.class);
        return new SFTPTransfer((PropertyContext)processContext, componentLog){

            protected SFTPClient getSFTPClient(FlowFile flowFile) {
                return sftpClient;
            }
        };
    }

    @Test
    public void testEnsureDirectoryExistsAlreadyExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsFailedToStat() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failure")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Failed to determine if remote directory exists at /dir1/dir2/dir3 due to 4: Failure", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsParentNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        Mockito.when((Object)sftpClient.stat("/dir1/dir2")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsNotExistedFailedToCreate() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        Mockito.when((Object)sftpClient.stat("/dir1/dir2/dir3")).thenThrow(new Throwable[]{new SFTPException(Response.StatusCode.NO_SUCH_FILE, "No such file")});
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failed")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Failed to create remote directory /dir1/dir2/dir3 due to 4: Failed", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyParentNotExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        AtomicInteger mkdirCount = new AtomicInteger(0);
        ((SFTPClient)Mockito.doAnswer(invocation -> {
            int cnt = mkdirCount.getAndIncrement();
            if (cnt == 0) {
                throw new SFTPException(Response.StatusCode.NO_SUCH_FILE, "Failure");
            }
            return true;
        }).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)2))).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyAlreadyExisted() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.FAILURE, "Failure")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir);
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testEnsureDirectoryExistsBlindlyFailed() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty(SFTPTransfer.DISABLE_DIRECTORY_LISTING)).thenReturn((Object)new MockPropertyValue("true"));
        SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);
        ((SFTPClient)Mockito.doThrow((Throwable[])new Throwable[]{new SFTPException(Response.StatusCode.PERMISSION_DENIED, "Permission denied")}).when((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
        MockFlowFile flowFile = new MockFlowFile(0L);
        File remoteDir = new File("/dir1/dir2/dir3");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> sftpTransfer.ensureDirectoryExists((FlowFile)flowFile, remoteDir));
        Assertions.assertEquals((Object)"Could not blindly create remote directory due to Permission denied", (Object)e.getMessage());
        ((SFTPClient)Mockito.verify((Object)sftpClient, (VerificationMode)Mockito.times((int)0))).stat((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
        ((SFTPClient)Mockito.verify((Object)sftpClient)).mkdir((String)ArgumentMatchers.eq((Object)"/dir1/dir2/dir3"));
    }

    @Test
    public void testFileTypeUnknown() throws IOException {
        ProcessContext processContext = (ProcessContext)Mockito.mock(ProcessContext.class);
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.REMOTE_PATH))).thenReturn((Object)new MockPropertyValue("."));
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.IGNORE_DOTTED_FILES))).thenReturn((Object)BOOLEAN_TRUE_PROPERTY_VALUE);
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.RECURSIVE_SEARCH))).thenReturn((Object)BOOLEAN_FALSE_PROPERTY_VALUE);
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.FOLLOW_SYMLINK))).thenReturn((Object)BOOLEAN_FALSE_PROPERTY_VALUE);
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.FILE_FILTER_REGEX))).thenReturn((Object)new MockPropertyValue(".*"));
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.PATH_FILTER_REGEX))).thenReturn((Object)new MockPropertyValue(".*"));
        Mockito.when((Object)processContext.getProperty((PropertyDescriptor)ArgumentMatchers.eq((Object)FileTransfer.REMOTE_PATH))).thenReturn((Object)new MockPropertyValue("."));
        try (SFTPClient sftpClient = (SFTPClient)Mockito.mock(SFTPClient.class);){
            Mockito.when((Object)sftpClient.ls((String)ArgumentMatchers.any(), (RemoteResourceFilter)ArgumentMatchers.any(RemoteResourceFilter.class))).then(invocation -> {
                LinkedHashMap extended = new LinkedHashMap();
                ArrayList<RemoteResourceInfo> list = new ArrayList<RemoteResourceInfo>();
                list.add(new RemoteResourceInfo(new PathComponents("./", "unknown.txt", "/"), new FileAttributes(FileAttributes.Flag.MODE.get(), 0L, 0, 0, new FileMode(FILE_MASK_UNKNOWN_777), 0L, 0L, extended)));
                list.add(new RemoteResourceInfo(new PathComponents("./", "regular.txt", "/"), new FileAttributes(FileAttributes.Flag.MODE.get(), 0L, 0, 0, new FileMode(FILE_MASK_REGULAR_777), 0L, 0L, extended)));
                RemoteResourceFilter filter = (RemoteResourceFilter)invocation.getArgument(1, RemoteResourceFilter.class);
                list.forEach(arg_0 -> ((RemoteResourceFilter)filter).accept(arg_0));
                return list;
            });
            SFTPTransfer sftpTransfer = this.createSftpTransfer(processContext, sftpClient);
            List listing = sftpTransfer.getListing(false);
            Assertions.assertEquals((int)2, (int)listing.size());
        }
    }
}

