/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ConvertCharacterSet;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConvertCharacterSet {
    @Test
    public void testSimple() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ConvertCharacterSet());
        runner.setProperty(ConvertCharacterSet.INPUT_CHARSET, "ASCII");
        runner.setProperty(ConvertCharacterSet.OUTPUT_CHARSET, "UTF-32");
        runner.enqueue(Paths.get("src/test/resources/CharacterSetConversionSamples/Original.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertCharacterSet.REL_SUCCESS, 1);
        MockFlowFile output = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertCharacterSet.REL_SUCCESS).get(0);
        output.assertContentEquals(new File("src/test/resources/CharacterSetConversionSamples/Converted2.txt"));
    }

    @Test
    public void testExpressionLanguageInput() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ConvertCharacterSet());
        runner.setProperty(ConvertCharacterSet.INPUT_CHARSET, "${characterSet}");
        runner.setProperty(ConvertCharacterSet.OUTPUT_CHARSET, "UTF-32");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("characterSet", "ASCII");
        runner.enqueue(Paths.get("src/test/resources/CharacterSetConversionSamples/Original.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertCharacterSet.REL_SUCCESS, 1);
        MockFlowFile output = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertCharacterSet.REL_SUCCESS).get(0);
        output.assertContentEquals(new File("src/test/resources/CharacterSetConversionSamples/Converted2.txt"));
    }

    @Test
    public void testExpressionLanguageOutput() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ConvertCharacterSet());
        runner.setProperty(ConvertCharacterSet.INPUT_CHARSET, "ASCII");
        runner.setProperty(ConvertCharacterSet.OUTPUT_CHARSET, "${characterSet}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("characterSet", "UTF-32");
        runner.enqueue(Paths.get("src/test/resources/CharacterSetConversionSamples/Original.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertCharacterSet.REL_SUCCESS, 1);
        MockFlowFile output = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertCharacterSet.REL_SUCCESS).get(0);
        output.assertContentEquals(new File("src/test/resources/CharacterSetConversionSamples/Converted2.txt"));
    }

    @Test
    public void testExpressionLanguageConfig() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ConvertCharacterSet());
        runner.setProperty(ConvertCharacterSet.INPUT_CHARSET, "${now()}");
        runner.setProperty(ConvertCharacterSet.OUTPUT_CHARSET, "UTF-32");
        runner.enqueue(Paths.get("src/test/resources/CharacterSetConversionSamples/Original.txt", new String[0]));
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
        runner.setProperty(ConvertCharacterSet.INPUT_CHARSET, "UTF-32");
        runner.setProperty(ConvertCharacterSet.OUTPUT_CHARSET, "${anyAttribute(\"abc\", \"xyz\"):contains(\"bye\")}");
        runner.enqueue(Paths.get("src/test/resources/CharacterSetConversionSamples/Original.txt", new String[0]));
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }
}

