/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.List;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.SplitRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSplitRecord {
    @Test
    public void testIndividualRecordPerSplit() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SplitRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SplitRecord.RECORD_READER, "reader");
        runner.setProperty(SplitRecord.RECORD_WRITER, "writer");
        runner.setProperty(SplitRecord.RECORDS_PER_SPLIT, "1");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        MockFlowFile inputFlowFile = runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SplitRecord.REL_SPLITS, 3);
        runner.assertTransferCount(SplitRecord.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitRecord.REL_FAILURE, 0);
        List out = runner.getFlowFilesForRelationship(SplitRecord.REL_SPLITS);
        int fragmentIndex = 0;
        String fragmentUUID = null;
        for (MockFlowFile mff2 : out) {
            if (fragmentUUID == null) {
                fragmentUUID = mff2.getAttribute(SplitRecord.FRAGMENT_ID);
            } else {
                mff2.assertAttributeEquals(SplitRecord.FRAGMENT_ID, fragmentUUID);
            }
            mff2.assertAttributeEquals(SplitRecord.FRAGMENT_COUNT, "3");
            mff2.assertAttributeEquals(SplitRecord.FRAGMENT_INDEX, String.valueOf(fragmentIndex));
            mff2.assertAttributeEquals(SplitRecord.SEGMENT_ORIGINAL_FILENAME, inputFlowFile.getAttribute(CoreAttributes.FILENAME.key()));
            mff2.assertAttributeEquals("record.count", "1");
            mff2.assertAttributeEquals("mime.type", "text/plain");
            ++fragmentIndex;
        }
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("header\nJohn Doe,48\n")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("header\nJane Doe,47\n")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("header\nJimmy Doe,14\n")).count());
        MockFlowFile originalFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(SplitRecord.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeEquals(SplitRecord.FRAGMENT_COUNT, "3");
        originalFlowFile.assertAttributeEquals(SplitRecord.FRAGMENT_ID, fragmentUUID);
    }

    @Test
    public void testMultipleRecordsPerSplit() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SplitRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SplitRecord.RECORD_READER, "reader");
        runner.setProperty(SplitRecord.RECORD_WRITER, "writer");
        runner.setProperty(SplitRecord.RECORDS_PER_SPLIT, "2");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SplitRecord.REL_SPLITS, 2);
        runner.assertTransferCount(SplitRecord.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitRecord.REL_FAILURE, 0);
        List out = runner.getFlowFilesForRelationship(SplitRecord.REL_SPLITS);
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.getAttribute("record.count").equals("1")).count());
        Assertions.assertTrue((boolean)out.stream().allMatch(mff -> mff.getAttribute("mime.type").equals("text/plain")));
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("header\nJohn Doe,48\nJane Doe,47\n")).count());
        Assertions.assertEquals((long)1L, (long)out.stream().filter(mff -> mff.isContentEqual("header\nJimmy Doe,14\n")).count());
    }

    @Test
    public void testAllSplitsOneDesintation() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser();
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SplitRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SplitRecord.RECORD_READER, "reader");
        runner.setProperty(SplitRecord.RECORD_WRITER, "writer");
        runner.setProperty(SplitRecord.RECORDS_PER_SPLIT, "3");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        runner.enqueue("");
        runner.run();
        runner.assertTransferCount(SplitRecord.REL_SPLITS, 1);
        runner.assertTransferCount(SplitRecord.REL_ORIGINAL, 1);
        runner.assertTransferCount(SplitRecord.REL_FAILURE, 0);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(SplitRecord.REL_SPLITS).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("header\nJohn Doe,48\nJane Doe,47\nJimmy Doe,14\n");
    }

    @Test
    public void testReadFailure() throws InitializationException {
        MockRecordParser readerService = new MockRecordParser(2);
        MockRecordWriter writerService = new MockRecordWriter("header", false);
        TestRunner runner = TestRunners.newTestRunner(SplitRecord.class);
        runner.addControllerService("reader", (ControllerService)readerService);
        runner.enableControllerService((ControllerService)readerService);
        runner.addControllerService("writer", (ControllerService)writerService);
        runner.enableControllerService((ControllerService)writerService);
        runner.setProperty(SplitRecord.RECORD_READER, "reader");
        runner.setProperty(SplitRecord.RECORD_WRITER, "writer");
        runner.setProperty(SplitRecord.RECORDS_PER_SPLIT, "1");
        readerService.addSchemaField("name", RecordFieldType.STRING);
        readerService.addSchemaField("age", RecordFieldType.INT);
        readerService.addRecord(new Object[]{"John Doe", 48});
        readerService.addRecord(new Object[]{"Jane Doe", 47});
        readerService.addRecord(new Object[]{"Jimmy Doe", 14});
        MockFlowFile original = runner.enqueue("");
        runner.run();
        runner.assertAllFlowFilesTransferred(SplitRecord.REL_FAILURE, 1);
        MockFlowFile failed = (MockFlowFile)runner.getFlowFilesForRelationship(SplitRecord.REL_FAILURE).get(0);
        Assertions.assertTrue((original == failed ? 1 : 0) != 0);
    }
}

