/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.RouteOnContent;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestRouteOnContent {
    @Test
    public void testCloning() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnContent());
        runner.setProperty(RouteOnContent.MATCH_REQUIREMENT, "content must contain match");
        runner.setProperty("hello", "Hello");
        runner.setProperty("world", "World");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertTransferCount("hello", 1);
        runner.assertTransferCount("world", 1);
        runner.assertTransferCount(RouteOnContent.REL_NO_MATCH, 0);
    }

    @Test
    public void testSubstituteAttributes() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnContent());
        runner.setProperty(RouteOnContent.MATCH_REQUIREMENT, "content must contain match");
        runner.setProperty("attr", "Hel${highLow}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("highLow", "lo");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred("attr", 1);
    }

    @Test
    public void testBufferSize() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnContent());
        runner.setProperty(RouteOnContent.MATCH_REQUIREMENT, "content must match exactly");
        runner.setProperty(RouteOnContent.BUFFER_SIZE, "3 B");
        runner.setProperty("rel", "Hel");
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred("rel", 1);
    }
}

