/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processors.standard.GetJMSQueue;
import org.apache.nifi.processors.standard.JmsConsumer;
import org.apache.nifi.processors.standard.util.JmsProcessingSummary;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockProcessorInitializationContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJmsConsumer {
    protected static MapMessage createMapMessage() throws JMSException {
        ActiveMQMapMessage mapMessage = new ActiveMQMapMessage();
        mapMessage.setString("name", "Arnold");
        mapMessage.setInt("age", 97);
        mapMessage.setDouble("xyz", 89686.564);
        mapMessage.setBoolean("good", true);
        return mapMessage;
    }

    @Test
    public void testCreateMapMessageValues() throws JMSException {
        MapMessage mapMessage = TestJmsConsumer.createMapMessage();
        Map mapMessageValues = JmsConsumer.createMapMessageValues((MapMessage)mapMessage);
        Assertions.assertEquals((int)4, (int)mapMessageValues.size());
        Assertions.assertEquals((Object)"Arnold", mapMessageValues.get("jms.mapmessage.name"));
        Assertions.assertEquals((Object)"97", mapMessageValues.get("jms.mapmessage.age"));
        Assertions.assertEquals((Object)"89686.564", mapMessageValues.get("jms.mapmessage.xyz"));
        Assertions.assertEquals((Object)"true", mapMessageValues.get("jms.mapmessage.good"));
    }

    @Test
    public void testMap2FlowFileMapMessage() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(GetJMSQueue.class);
        MapMessage mapMessage = TestJmsConsumer.createMapMessage();
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockProcessorInitializationContext pic = new MockProcessorInitializationContext(runner.getProcessor(), (MockProcessContext)runner.getProcessContext());
        JmsProcessingSummary summary = JmsConsumer.map2FlowFile((ProcessContext)context, (ProcessSession)session, (Message)mapMessage, (boolean)true, (ComponentLog)pic.getLogger());
        Assertions.assertEquals((long)0L, (long)summary.getBytesReceived(), (String)"MapMessage should not create FlowFile content");
        Map attributes = summary.getLastFlowFile().getAttributes();
        Assertions.assertEquals((Object)"Arnold", attributes.get("jms.mapmessage.name"));
        Assertions.assertEquals((Object)"97", attributes.get("jms.mapmessage.age"));
        Assertions.assertEquals((Object)"89686.564", attributes.get("jms.mapmessage.xyz"));
        Assertions.assertEquals((Object)"true", attributes.get("jms.mapmessage.good"));
    }

    @Test
    public void testMap2FlowFileTextMessage() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(GetJMSQueue.class);
        ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
        String payload = "Hello world!";
        textMessage.setText(payload);
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockProcessorInitializationContext pic = new MockProcessorInitializationContext(runner.getProcessor(), (MockProcessContext)runner.getProcessContext());
        JmsProcessingSummary summary = JmsConsumer.map2FlowFile((ProcessContext)context, (ProcessSession)session, (Message)textMessage, (boolean)true, (ComponentLog)pic.getLogger());
        Assertions.assertEquals((long)payload.length(), (long)summary.getLastFlowFile().getSize(), (String)"TextMessage content length should equal to FlowFile content size");
        final byte[] buffer = new byte[payload.length()];
        runner.clearTransferState();
        session.read(summary.getLastFlowFile(), new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false);
            }
        });
        String contentString = new String(buffer, "UTF-8");
        Assertions.assertEquals((Object)payload, (Object)contentString);
    }

    @Test
    public void testMap2FlowFileBytesMessage() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(GetJMSQueue.class);
        ActiveMQBytesMessage bytesMessage = new ActiveMQBytesMessage();
        String sourceString = "Apache NiFi is an easy to use, powerful, and reliable system to process and distribute data.!";
        byte[] payload = sourceString.getBytes("UTF-8");
        bytesMessage.writeBytes(payload);
        bytesMessage.reset();
        ProcessContext context = runner.getProcessContext();
        ProcessSession session = runner.getProcessSessionFactory().createSession();
        MockProcessorInitializationContext pic = new MockProcessorInitializationContext(runner.getProcessor(), (MockProcessContext)runner.getProcessContext());
        JmsProcessingSummary summary = JmsConsumer.map2FlowFile((ProcessContext)context, (ProcessSession)session, (Message)bytesMessage, (boolean)true, (ComponentLog)pic.getLogger());
        Assertions.assertEquals((long)payload.length, (long)summary.getLastFlowFile().getSize(), (String)"BytesMessage content length should equal to FlowFile content size");
        final byte[] buffer = new byte[payload.length];
        runner.clearTransferState();
        session.read(summary.getLastFlowFile(), new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false);
            }
        });
        String contentString = new String(buffer, "UTF-8");
        Assertions.assertEquals((Object)sourceString, (Object)contentString);
    }
}

